/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.indices;

import io.skylite.common.Nullable;
import io.skylite.core.action.admin.indices.refresh.RefreshStats;
import io.skylite.core.action.admin.indices.stats.CommonStats;
import io.skylite.core.action.admin.indices.stats.IndexShardStats;
import io.skylite.core.action.admin.indices.stats.ShardStats;
import io.skylite.core.action.search.SearchRequestStats;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.index.Index;
import io.skylite.core.index.cache.query.QueryCacheStats;
import io.skylite.core.index.cache.request.RequestCacheStats;
import io.skylite.core.index.engine.SegmentsStats;
import io.skylite.core.index.fielddata.FieldDataStats;
import io.skylite.core.index.flush.FlushStats;
import io.skylite.core.index.get.GetStats;
import io.skylite.core.index.merge.MergeStats;
import io.skylite.core.index.recovery.RecoveryStats;
import io.skylite.core.index.shard.DocsStats;
import io.skylite.core.index.shard.IndexingStats;
import io.skylite.core.index.store.StoreStats;
import io.skylite.core.index.translog.TranslogStats;
import io.skylite.core.index.warmer.WarmerStats;
import io.skylite.core.search.stats.SearchStats;
import io.skylite.core.search.suggest.completion.CompletionStats;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentFragment;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NodeIndicesStats
implements Writeable,
ToXContentFragment {
    private CommonStats stats;
    private Map<Index, List<IndexShardStats>> statsByShard;

    public NodeIndicesStats(StreamInput in) throws IOException {
        this.stats = new CommonStats(in);
        if (in.readBoolean()) {
            int entries = in.readVInt();
            this.statsByShard = new HashMap<Index, List<IndexShardStats>>();
            for (int i = 0; i < entries; ++i) {
                Index index = new Index(in);
                int indexShardListSize = in.readVInt();
                ArrayList<IndexShardStats> indexShardStats = new ArrayList<IndexShardStats>(indexShardListSize);
                for (int j = 0; j < indexShardListSize; ++j) {
                    indexShardStats.add(new IndexShardStats(in));
                }
                this.statsByShard.put(index, indexShardStats);
            }
        }
    }

    public NodeIndicesStats(CommonStats oldStats, Map<Index, List<IndexShardStats>> statsByShard, SearchRequestStats searchRequestStats) {
        this.statsByShard = statsByShard;
        this.stats = oldStats;
        for (List<IndexShardStats> shardStatsList : statsByShard.values()) {
            for (IndexShardStats indexShardStats : shardStatsList) {
                for (ShardStats shardStats : indexShardStats.getShards()) {
                    this.stats.add(shardStats.getStats());
                }
            }
        }
        if (this.stats.search != null) {
            this.stats.search.setSearchRequestStats(searchRequestStats);
        }
    }

    @Nullable
    public StoreStats getStore() {
        return this.stats.getStore();
    }

    @Nullable
    public DocsStats getDocs() {
        return this.stats.getDocs();
    }

    @Nullable
    public IndexingStats getIndexing() {
        return this.stats.getIndexing();
    }

    @Nullable
    public GetStats getGet() {
        return this.stats.getGet();
    }

    @Nullable
    public SearchStats getSearch() {
        return this.stats.getSearch();
    }

    @Nullable
    public MergeStats getMerge() {
        return this.stats.getMerge();
    }

    @Nullable
    public RefreshStats getRefresh() {
        return this.stats.getRefresh();
    }

    @Nullable
    public FlushStats getFlush() {
        return this.stats.getFlush();
    }

    @Nullable
    public WarmerStats getWarmer() {
        return this.stats.getWarmer();
    }

    @Nullable
    public FieldDataStats getFieldData() {
        return this.stats.getFieldData();
    }

    @Nullable
    public QueryCacheStats getQueryCache() {
        return this.stats.getQueryCache();
    }

    @Nullable
    public RequestCacheStats getRequestCache() {
        return this.stats.getRequestCache();
    }

    @Nullable
    public CompletionStats getCompletion() {
        return this.stats.getCompletion();
    }

    @Nullable
    public SegmentsStats getSegments() {
        return this.stats.getSegments();
    }

    @Nullable
    public TranslogStats getTranslog() {
        return this.stats.getTranslog();
    }

    @Nullable
    public RecoveryStats getRecoveryStats() {
        return this.stats.getRecoveryStats();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.stats.writeTo(out);
        out.writeBoolean(this.statsByShard != null);
        if (this.statsByShard != null) {
            out.writeVInt(this.statsByShard.size());
            for (Map.Entry<Index, List<IndexShardStats>> entry : this.statsByShard.entrySet()) {
                entry.getKey().writeTo(out);
                out.writeVInt(entry.getValue().size());
                for (IndexShardStats indexShardStats : entry.getValue()) {
                    indexShardStats.writeTo(out);
                }
            }
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        boolean isLevelValid;
        String level = params.param("level", "node");
        boolean bl = isLevelValid = "indices".equalsIgnoreCase(level) || "node".equalsIgnoreCase(level) || "shards".equalsIgnoreCase(level);
        if (!isLevelValid) {
            throw new IllegalArgumentException("level parameter must be one of [indices] or [node] or [shards] but was [" + level + "]");
        }
        builder.startObject("indices");
        this.stats.toXContent(builder, params);
        if ("indices".equals(level)) {
            Map<Index, CommonStats> indexStats = this.createStatsByIndex();
            builder.startObject("indices");
            for (Map.Entry<Index, CommonStats> entry : indexStats.entrySet()) {
                builder.startObject(entry.getKey().getName());
                entry.getValue().toXContent(builder, params);
                builder.endObject();
            }
            builder.endObject();
        } else if ("shards".equals(level)) {
            builder.startObject("shards");
            for (Map.Entry<Index, List<IndexShardStats>> entry : this.statsByShard.entrySet()) {
                builder.startArray(entry.getKey().getName());
                for (IndexShardStats indexShardStats : entry.getValue()) {
                    builder.startObject().startObject(String.valueOf(indexShardStats.getShardId().getId()));
                    for (ShardStats shardStats : indexShardStats.getShards()) {
                        shardStats.toXContent(builder, params);
                    }
                    builder.endObject().endObject();
                }
                builder.endArray();
            }
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    private Map<Index, CommonStats> createStatsByIndex() {
        HashMap<Index, CommonStats> statsMap = new HashMap<Index, CommonStats>();
        for (Map.Entry<Index, List<IndexShardStats>> entry : this.statsByShard.entrySet()) {
            if (!statsMap.containsKey(entry.getKey())) {
                statsMap.put(entry.getKey(), new CommonStats());
            }
            for (IndexShardStats indexShardStats : entry.getValue()) {
                for (ShardStats shardStats : indexShardStats.getShards()) {
                    ((CommonStats)statsMap.get(entry.getKey())).add(shardStats.getStats());
                }
            }
        }
        return statsMap;
    }

    public List<IndexShardStats> getShardStats(Index index) {
        if (this.statsByShard == null) {
            return null;
        }
        return this.statsByShard.get(index);
    }

    static final class Fields {
        static final String INDICES = "indices";

        Fields() {
        }
    }
}

