/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.indices;

import io.skylite.common.Nullable;
import io.skylite.common.collect.Tuple;
import io.skylite.core.index.Index;
import io.skylite.core.indices.SystemIndexDescriptor;
import io.skylite.core.tasks.BaseTaskResultsService;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.automaton.Automata;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.CharacterRunAutomaton;
import org.apache.lucene.util.automaton.Operations;

public class SystemIndices {
    private static final Automaton EMPTY = Automata.makeEmpty();
    private static final Logger logger = LogManager.getLogger(SystemIndices.class);
    private static final Map<String, Collection<SystemIndexDescriptor>> SERVER_SYSTEM_INDEX_DESCRIPTORS = Collections.singletonMap(BaseTaskResultsService.class.getName(), Collections.singletonList(BaseTaskResultsService.TASKS_DESCRIPTOR));
    private final CharacterRunAutomaton runAutomaton;
    private final Collection<SystemIndexDescriptor> systemIndexDescriptors;

    public SystemIndices(Map<String, Collection<SystemIndexDescriptor>> pluginAndModulesDescriptors) {
        Map<String, Collection<SystemIndexDescriptor>> descriptorsMap = SystemIndices.buildSystemIndexDescriptorMap(pluginAndModulesDescriptors);
        SystemIndices.checkForOverlappingPatterns(descriptorsMap);
        this.systemIndexDescriptors = descriptorsMap.values().stream().flatMap(Collection::stream).collect(Collectors.toUnmodifiableList());
        this.checkForDuplicateAliases(this.systemIndexDescriptors);
        this.runAutomaton = SystemIndices.buildCharacterRunAutomaton(this.systemIndexDescriptors);
    }

    private void checkForDuplicateAliases(Collection<SystemIndexDescriptor> descriptors) {
        HashMap<String, Integer> aliasCounts = new HashMap<String, Integer>();
        for (SystemIndexDescriptor descriptor : descriptors) {
            String aliasName = descriptor.getAliasName();
            if (aliasName == null) continue;
            aliasCounts.compute(aliasName, (alias, existingCount) -> 1 + (existingCount == null ? 0 : existingCount));
        }
        List duplicateAliases = aliasCounts.entrySet().stream().filter(entry -> (Integer)entry.getValue() > 1).map(Map.Entry::getKey).sorted().collect(Collectors.toList());
        if (!duplicateAliases.isEmpty()) {
            throw new IllegalStateException("Found aliases associated with multiple system index descriptors: " + String.valueOf(duplicateAliases));
        }
    }

    public boolean isSystemIndex(Index index) {
        return this.isSystemIndex(index.getName());
    }

    public boolean isSystemIndex(String indexName) {
        return this.runAutomaton.run(indexName);
    }

    @Nullable
    public SystemIndexDescriptor findMatchingDescriptor(String name) {
        List matchingDescriptors = this.systemIndexDescriptors.stream().filter(descriptor -> descriptor.matchesIndexPattern(name)).collect(Collectors.toList());
        if (matchingDescriptors.isEmpty()) {
            return null;
        }
        if (matchingDescriptors.size() == 1) {
            return (SystemIndexDescriptor)matchingDescriptors.get(0);
        }
        StringBuilder errorMessage = new StringBuilder().append("index name [").append(name).append("] is claimed as a system index by multiple system index patterns: [").append(matchingDescriptors.stream().map(descriptor -> "pattern: [" + descriptor.getIndexPattern() + "], description: [" + descriptor.getDescription() + "]").collect(Collectors.joining("; ")));
        assert (false) : errorMessage.toString();
        throw new IllegalStateException(errorMessage.toString());
    }

    public boolean validateSystemIndex(String index) {
        SystemIndexDescriptor matchingDescriptor;
        if (index.charAt(0) == '.' && (matchingDescriptor = this.findMatchingDescriptor(index)) != null) {
            logger.trace("index [{}] is a system index because it matches index pattern [{}] with description [{}]", (Object)index, (Object)matchingDescriptor.getIndexPattern(), (Object)matchingDescriptor.getDescription());
            return true;
        }
        return false;
    }

    private static CharacterRunAutomaton buildCharacterRunAutomaton(Collection<SystemIndexDescriptor> descriptors) {
        Optional<Automaton> automaton = descriptors.stream().map(descriptor -> SystemIndexDescriptor.buildAutomaton(descriptor.getIndexPattern(), descriptor.getAliasName())).reduce(Operations::union);
        return new CharacterRunAutomaton(Operations.determinize((Automaton)automaton.orElse(EMPTY), (int)10000));
    }

    static void checkForOverlappingPatterns(Map<String, Collection<SystemIndexDescriptor>> sourceToDescriptors) {
        List<Tuple> sourceDescriptorPair = sourceToDescriptors.entrySet().stream().flatMap(entry -> ((Collection)entry.getValue()).stream().map(descriptor -> new Tuple((Object)((String)entry.getKey()), descriptor))).sorted(Comparator.comparing(d -> (String)d.v1() + ":" + ((SystemIndexDescriptor)d.v2()).getIndexPattern())).collect(Collectors.toList());
        sourceDescriptorPair.forEach(descriptorToCheck -> {
            List descriptorsMatchingThisPattern = sourceDescriptorPair.stream().filter(d -> descriptorToCheck.v2() != d.v2()).filter(d -> SystemIndices.overlaps((SystemIndexDescriptor)descriptorToCheck.v2(), (SystemIndexDescriptor)d.v2())).collect(Collectors.toList());
            if (!descriptorsMatchingThisPattern.isEmpty()) {
                throw new IllegalStateException("a system index descriptor [" + String.valueOf(descriptorToCheck.v2()) + "] from [" + (String)descriptorToCheck.v1() + "] overlaps with other system index descriptors: [" + descriptorsMatchingThisPattern.stream().map(descriptor -> String.valueOf(descriptor.v2()) + " from [" + (String)descriptor.v1() + "]").collect(Collectors.joining(", ")));
            }
        });
    }

    private static boolean overlaps(SystemIndexDescriptor a1, SystemIndexDescriptor a2) {
        Automaton a2Automaton;
        Automaton a1Automaton = SystemIndexDescriptor.buildAutomaton(a1.getIndexPattern(), null);
        return !Operations.isEmpty((Automaton)Operations.intersection((Automaton)a1Automaton, (Automaton)(a2Automaton = SystemIndexDescriptor.buildAutomaton(a2.getIndexPattern(), null))));
    }

    private static Map<String, Collection<SystemIndexDescriptor>> buildSystemIndexDescriptorMap(Map<String, Collection<SystemIndexDescriptor>> pluginAndModulesMap) {
        HashMap<String, Collection<SystemIndexDescriptor>> map = new HashMap<String, Collection<SystemIndexDescriptor>>(pluginAndModulesMap.size() + SERVER_SYSTEM_INDEX_DESCRIPTORS.size());
        map.putAll(pluginAndModulesMap);
        SERVER_SYSTEM_INDEX_DESCRIPTORS.forEach((source, descriptors) -> {
            if (map.putIfAbsent((String)source, (Collection<SystemIndexDescriptor>)descriptors) != null) {
                throw new IllegalArgumentException("plugin or module attempted to define the same source [" + source + "] as a built-in system index");
            }
        });
        return Collections.unmodifiableMap(map);
    }

    public Collection<SystemIndexDescriptor> getSystemIndexDescriptors() {
        return this.systemIndexDescriptors;
    }
}

