/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.indices.cluster;

import io.skylite.common.Nullable;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.cluster.node.DiscoveryNodes;
import io.skylite.core.cluster.routing.ShardRouting;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.env.ShardLockObtainFailedException;
import io.skylite.core.index.Index;
import io.skylite.core.index.IndexSettings;
import io.skylite.core.index.remote.RemoteStoreStatsTrackerFactory;
import io.skylite.core.index.seqno.ReplicationCheckpoint;
import io.skylite.core.index.seqno.RetentionLeaseSyncer;
import io.skylite.core.index.shard.BaseIndexShard;
import io.skylite.core.index.shard.IndexEventListener;
import io.skylite.core.index.shard.ShardId;
import io.skylite.core.index.shard.ShardInterface;
import io.skylite.core.indices.cluster.AllocatedIndexInterface;
import io.skylite.core.indices.recovery.BasePeerRecoveryTargetService;
import io.skylite.core.indices.recovery.RecoveryListener;
import io.skylite.core.repositories.RepositoriesService;
import java.io.IOException;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;

public interface AllocatedIndicesInterface<T extends ShardInterface, U extends AllocatedIndexInterface<T>>
extends Iterable<U> {
    public U createIndex(IndexMetadata var1, List<IndexEventListener> var2, boolean var3) throws IOException;

    public IndexMetadata verifyIndexIsDeleted(Index var1, ClusterState var2);

    public void deleteUnassignedIndex(String var1, IndexMetadata var2, ClusterState var3);

    public void removeIndex(Index var1, IndexRemovalReason var2, String var3);

    @Nullable
    public U indexService(Index var1);

    public T createShard(ShardRouting var1, BiFunction<BaseIndexShard, ReplicationCheckpoint, Void> var2, BasePeerRecoveryTargetService var3, RecoveryListener var4, RepositoriesService var5, Consumer<BaseIndexShard.ShardFailure> var6, Consumer<ShardId> var7, RetentionLeaseSyncer var8, DiscoveryNode var9, @Nullable DiscoveryNode var10, RemoteStoreStatsTrackerFactory var11, DiscoveryNodes var12) throws IOException;

    default public T getShardOrNull(ShardId shardId) {
        U indexRef = this.indexService(shardId.getIndex());
        if (indexRef != null) {
            return indexRef.getShardOrNull(shardId.id());
        }
        return null;
    }

    public void processPendingDeletes(Index var1, IndexSettings var2, TimeValue var3) throws IOException, InterruptedException, ShardLockObtainFailedException;

    public static enum IndexRemovalReason {
        NO_LONGER_ASSIGNED,
        DELETED,
        CLOSED,
        FAILURE,
        REOPENED;

    }
}

