/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.indices.replication.common;

import io.skylite.core.index.remote.RemoteStoreSettings;
import io.skylite.core.settings.Setting;
import io.skylite.core.settings.spi.SettingsProvider;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public enum ReplicationType {
    DOCUMENT,
    SEGMENT;

    public static final Setting<ReplicationType> INDEX_REPLICATION_TYPE_SETTING;

    public static ReplicationType parseString(String replicationType) {
        try {
            return ReplicationType.valueOf(replicationType);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Could not parse ReplicationStrategy for [" + replicationType + "]");
        }
        catch (NullPointerException npe) {
            return DOCUMENT;
        }
    }

    static {
        INDEX_REPLICATION_TYPE_SETTING = new Setting<ReplicationType>("index.replication.type", DOCUMENT.toString(), ReplicationType::parseString, new Setting.Validator<ReplicationType>(){

            @Override
            public void validate(ReplicationType value) {
            }

            @Override
            public void validate(ReplicationType value, Map<Setting<?>, Object> settings) {
                Object remoteStoreEnabled = settings.get(RemoteStoreSettings.INDEX_REMOTE_STORE_ENABLED_SETTING);
                if (!SEGMENT.equals((Object)value) && Objects.equals(remoteStoreEnabled, true)) {
                    throw new IllegalArgumentException("To enable " + RemoteStoreSettings.INDEX_REMOTE_STORE_ENABLED_SETTING.getKey() + ", " + INDEX_REPLICATION_TYPE_SETTING.getKey() + " should be set to " + String.valueOf((Object)SEGMENT));
                }
            }

            @Override
            public Iterator<Setting<?>> settings() {
                List<Setting<Boolean>> settings = List.of(RemoteStoreSettings.INDEX_REMOTE_STORE_ENABLED_SETTING);
                return settings.iterator();
            }
        }, Setting.Property.IndexScope, Setting.Property.Final);
    }

    public static class SettingsProviderImpl
    implements SettingsProvider {
        @Override
        public List<? extends Setting<?>> getSettings() {
            return Collections.singletonList(INDEX_REPLICATION_TYPE_SETTING);
        }
    }
}

