/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.ingest;

import io.skylite.common.processor.AbstractProcessor;
import io.skylite.core.ingest.BaseIngestService;
import io.skylite.core.ingest.ConfigurationUtils;
import io.skylite.core.ingest.IngestDocument;
import io.skylite.core.ingest.IngestProcessor;
import io.skylite.core.ingest.Pipeline;
import io.skylite.core.script.TemplateScript;
import java.util.Map;
import java.util.function.BiConsumer;

public class PipelineProcessor
extends AbstractProcessor
implements IngestProcessor {
    public static final String TYPE = "pipeline";
    private final TemplateScript.Factory pipelineTemplate;
    private final BaseIngestService ingestService;

    public PipelineProcessor(String tag, String description, TemplateScript.Factory pipelineTemplate, BaseIngestService ingestService) {
        super(tag, description);
        this.pipelineTemplate = pipelineTemplate;
        this.ingestService = ingestService;
    }

    @Override
    public void execute(IngestDocument ingestDocument, BiConsumer<IngestDocument, Exception> handler) {
        String pipelineName = ingestDocument.renderTemplate(this.pipelineTemplate);
        Pipeline pipeline = this.ingestService.getPipeline(pipelineName);
        if (pipeline != null) {
            ingestDocument.executePipeline(pipeline, handler);
        } else {
            handler.accept(null, new IllegalStateException("Pipeline processor configured for non-existent pipeline [" + pipelineName + "]"));
        }
    }

    @Override
    public IngestDocument execute(IngestDocument ingestDocument) throws Exception {
        throw new UnsupportedOperationException("this method should not get executed");
    }

    Pipeline getPipeline(IngestDocument ingestDocument) {
        return this.ingestService.getPipeline(this.getPipelineToCallName(ingestDocument));
    }

    String getPipelineToCallName(IngestDocument ingestDocument) {
        return ingestDocument.renderTemplate(this.pipelineTemplate);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public TemplateScript.Factory getPipelineTemplate() {
        return this.pipelineTemplate;
    }

    public static final class Factory
    implements AbstractProcessor.Factory<PipelineProcessor> {
        private final BaseIngestService ingestService;

        public Factory(BaseIngestService ingestService) {
            this.ingestService = ingestService;
        }

        public PipelineProcessor create(Map<String, AbstractProcessor.Factory<?>> registry, String processorTag, String description, Map<String, Object> config) throws Exception {
            TemplateScript.Factory pipelineTemplate = ConfigurationUtils.readTemplateProperty(PipelineProcessor.TYPE, processorTag, config, "name", this.ingestService.getScriptService());
            return new PipelineProcessor(processorTag, description, pipelineTemplate, this.ingestService);
        }
    }
}

