/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.ingest;

import io.skylite.core.script.Script;
import io.skylite.core.script.ScriptService;
import io.skylite.core.script.ScriptType;
import io.skylite.core.script.TemplateScript;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public interface ValueSource {
    public Object copyAndResolve(Map<String, Object> var1);

    public static ValueSource wrap(Object value, ScriptService scriptService) {
        if (value instanceof Map) {
            Map mapValue = (Map)value;
            HashMap<ValueSource, ValueSource> valueTypeMap = new HashMap<ValueSource, ValueSource>(mapValue.size());
            for (Map.Entry entry : mapValue.entrySet()) {
                valueTypeMap.put(ValueSource.wrap(entry.getKey(), scriptService), ValueSource.wrap(entry.getValue(), scriptService));
            }
            return new MapValue(valueTypeMap);
        }
        if (value instanceof List) {
            List listValue = (List)value;
            ArrayList<ValueSource> valueSourceList = new ArrayList<ValueSource>(listValue.size());
            for (Object item : listValue) {
                valueSourceList.add(ValueSource.wrap(item, scriptService));
            }
            return new ListValue(valueSourceList);
        }
        if (value == null || value instanceof Number || value instanceof Boolean) {
            return new ObjectValue(value);
        }
        if (value instanceof byte[]) {
            return new ByteValue((byte[])value);
        }
        if (value instanceof String) {
            if (scriptService.isLangSupported("mustache") && ((String)value).contains("{{")) {
                Script script = new Script(ScriptType.INLINE, "mustache", (String)value, Collections.emptyMap());
                return new TemplatedValue(scriptService.compile(script, TemplateScript.CONTEXT));
            }
            return new ObjectValue(value);
        }
        throw new IllegalArgumentException("unexpected value type [" + String.valueOf(value.getClass()) + "]");
    }

    public static final class MapValue
    implements ValueSource {
        private final Map<ValueSource, ValueSource> map;

        MapValue(Map<ValueSource, ValueSource> map) {
            this.map = map;
        }

        @Override
        public Object copyAndResolve(Map<String, Object> model) {
            HashMap<Object, Object> copy = new HashMap<Object, Object>();
            for (Map.Entry<ValueSource, ValueSource> entry : this.map.entrySet()) {
                copy.put(entry.getKey().copyAndResolve(model), entry.getValue().copyAndResolve(model));
            }
            return copy;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MapValue mapValue = (MapValue)o;
            return this.map.equals(mapValue.map);
        }

        public int hashCode() {
            return this.map.hashCode();
        }
    }

    public static final class ListValue
    implements ValueSource {
        private final List<ValueSource> values;

        ListValue(List<ValueSource> values) {
            this.values = values;
        }

        @Override
        public Object copyAndResolve(Map<String, Object> model) {
            ArrayList<Object> copy = new ArrayList<Object>(this.values.size());
            for (ValueSource value : this.values) {
                copy.add(value.copyAndResolve(model));
            }
            return copy;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ListValue listValue = (ListValue)o;
            return this.values.equals(listValue.values);
        }

        public int hashCode() {
            return this.values.hashCode();
        }
    }

    public static final class ObjectValue
    implements ValueSource {
        private final Object value;

        ObjectValue(Object value) {
            this.value = value;
        }

        @Override
        public Object copyAndResolve(Map<String, Object> model) {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ObjectValue objectValue = (ObjectValue)o;
            return Objects.equals(this.value, objectValue.value);
        }

        public int hashCode() {
            return Objects.hashCode(this.value);
        }
    }

    public static final class ByteValue
    implements ValueSource {
        private final byte[] value;

        ByteValue(byte[] value) {
            this.value = value;
        }

        @Override
        public Object copyAndResolve(Map<String, Object> model) {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ByteValue objectValue = (ByteValue)o;
            return Arrays.equals(this.value, objectValue.value);
        }

        public int hashCode() {
            return Arrays.hashCode(this.value);
        }
    }

    public static final class TemplatedValue
    implements ValueSource {
        private final TemplateScript.Factory template;

        TemplatedValue(TemplateScript.Factory template) {
            this.template = template;
        }

        @Override
        public Object copyAndResolve(Map<String, Object> model) {
            return this.template.newInstance(model).execute();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TemplatedValue templatedValue = (TemplatedValue)o;
            return Objects.equals(this.template, templatedValue.template);
        }

        public int hashCode() {
            return Objects.hashCode(this.template);
        }
    }
}

