/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.lucene;

import io.skylite.SkyliteExceptionsHelper;
import io.skylite.common.Nullable;
import io.skylite.common.SuppressForbidden;
import io.skylite.core.analysis.AnalyzerScope;
import io.skylite.core.analysis.NamedAnalyzer;
import io.skylite.core.common.Strings;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.index.fielddata.IndexFieldDataFieldComparatorSource;
import io.skylite.core.lucene.search.TopDocsAndMaxScore;
import io.skylite.core.lucene.search.grouping.TopFieldGroups;
import io.skylite.core.search.sort.SortedWiderNumericSortField;
import java.io.IOException;
import java.math.BigInteger;
import java.text.ParseException;
import java.util.Arrays;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.KeywordAnalyzer;
import org.apache.lucene.analysis.core.WhitespaceAnalyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.LatLonDocValuesField;
import org.apache.lucene.index.CodecReader;
import org.apache.lucene.index.FilterCodecReader;
import org.apache.lucene.index.FilterLeafReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.NoMergePolicy;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.SortedNumericSortField;
import org.apache.lucene.search.SortedSetSortField;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.TotalHits;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.Lock;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.Version;

public class Lucene {
    public static final String LATEST_CODEC = "Lucene103";
    public static final String SOFT_DELETES_FIELD = "__soft_deletes";
    public static final ScoreDoc[] EMPTY_SCORE_DOCS = new ScoreDoc[0];
    public static final TopDocs EMPTY_TOP_DOCS = new TopDocs(new TotalHits(0L, TotalHits.Relation.EQUAL_TO), EMPTY_SCORE_DOCS);
    public static final NamedAnalyzer STANDARD_ANALYZER = new NamedAnalyzer("_standard", AnalyzerScope.GLOBAL, (Analyzer)new StandardAnalyzer());
    public static final NamedAnalyzer KEYWORD_ANALYZER = new NamedAnalyzer("_keyword", AnalyzerScope.GLOBAL, (Analyzer)new KeywordAnalyzer());
    public static final NamedAnalyzer WHITESPACE_ANALYZER = new NamedAnalyzer("_whitespace", AnalyzerScope.GLOBAL, (Analyzer)new WhitespaceAnalyzer());
    private static final Class<?> GEO_DISTANCE_SORT_TYPE_CLASS = LatLonDocValuesField.newDistanceSort((String)"some_geo_field", (double)0.0, (double)0.0).getClass();

    private Lucene() {
    }

    public static Bits asSequentialAccessBits(int maxDoc, @Nullable ScorerSupplier scorerSupplier) throws IOException {
        return Lucene.asSequentialAccessBits(maxDoc, scorerSupplier, 0L);
    }

    public static Bits asSequentialAccessBits(final int maxDoc, @Nullable ScorerSupplier scorerSupplier, long estimatedGetCount) throws IOException {
        if (scorerSupplier == null) {
            return new Bits.MatchNoBits(maxDoc);
        }
        Scorer scorer = scorerSupplier.get(estimatedGetCount);
        final TwoPhaseIterator twoPhase = scorer.twoPhaseIterator();
        final DocIdSetIterator iterator = twoPhase == null ? scorer.iterator() : twoPhase.approximation();
        return new Bits(){
            int previous = -1;
            boolean previousMatched = false;

            public boolean get(int index) {
                if (index < 0 || index >= maxDoc) {
                    throw new IndexOutOfBoundsException(index + " is out of bounds: [0-" + maxDoc + "[");
                }
                if (index < this.previous) {
                    throw new IllegalArgumentException("This Bits instance can only be consumed in order. Got called on [" + index + "] while previously called on [" + this.previous + "]");
                }
                if (index == this.previous) {
                    return this.previousMatched;
                }
                this.previous = index;
                int doc = iterator.docID();
                if (doc < index) {
                    try {
                        doc = iterator.advance(index);
                    }
                    catch (IOException e) {
                        throw new IllegalStateException("Cannot advance iterator", e);
                    }
                }
                if (index == doc) {
                    try {
                        this.previousMatched = twoPhase == null || twoPhase.matches();
                        return this.previousMatched;
                    }
                    catch (IOException e) {
                        throw new IllegalStateException("Cannot validate match", e);
                    }
                }
                this.previousMatched = false;
                return false;
            }

            public int length() {
                return maxDoc;
            }
        };
    }

    public static boolean canEarlyTerminate(Sort searchSort, Sort indexSort) {
        SortField[] fields2;
        SortField[] fields1 = searchSort.getSort();
        if (fields1.length > (fields2 = indexSort.getSort()).length) {
            return false;
        }
        return Arrays.asList(fields1).equals(Arrays.asList(fields2).subList(0, fields1.length));
    }

    public static SegmentReader segmentReader(LeafReader reader) {
        if (reader instanceof SegmentReader) {
            return (SegmentReader)reader;
        }
        if (reader instanceof FilterLeafReader) {
            FilterLeafReader fReader = (FilterLeafReader)reader;
            return Lucene.segmentReader(FilterLeafReader.unwrap((LeafReader)fReader));
        }
        if (reader instanceof FilterCodecReader) {
            FilterCodecReader fReader = (FilterCodecReader)reader;
            return Lucene.segmentReader((LeafReader)FilterCodecReader.unwrap((CodecReader)fReader));
        }
        throw new IllegalStateException("Can not extract segment reader from given index reader [" + String.valueOf(reader) + "]");
    }

    public static Version parseVersionLenient(String toParse, Version defaultValue) {
        return LenientParser.parse(toParse, defaultValue);
    }

    public static boolean isCorruptionException(Throwable t) {
        return SkyliteExceptionsHelper.unwrapCorruption(t) != null;
    }

    public static void cleanLuceneIndex(Directory directory) throws IOException {
        try (Lock writeLock = directory.obtainLock("write.lock");){
            for (String file : directory.listAll()) {
                if (!file.startsWith("segments")) continue;
                directory.deleteFile(file);
            }
        }
        IndexWriter writer = new IndexWriter(directory, new IndexWriterConfig((Analyzer)STANDARD_ANALYZER).setSoftDeletesField(SOFT_DELETES_FIELD).setMergePolicy(NoMergePolicy.INSTANCE).setCommitOnClose(false).setOpenMode(IndexWriterConfig.OpenMode.CREATE));
        writer.close();
    }

    private static Number readExplanationValue(StreamInput in) throws IOException {
        byte numberType = in.readByte();
        switch (numberType) {
            case 0: {
                return Float.valueOf(in.readFloat());
            }
            case 1: {
                return in.readDouble();
            }
            case 2: {
                return in.readZLong();
            }
        }
        throw new IOException("Unexpected number type: " + numberType);
    }

    public static Explanation readExplanation(StreamInput in) throws IOException {
        boolean match = in.readBoolean();
        String description = in.readString();
        Explanation[] subExplanations = new Explanation[in.readVInt()];
        for (int i = 0; i < subExplanations.length; ++i) {
            subExplanations[i] = Lucene.readExplanation(in);
        }
        if (match) {
            return Explanation.match((Number)Lucene.readExplanationValue(in), (String)description, (Explanation[])subExplanations);
        }
        return Explanation.noMatch((String)description, (Explanation[])subExplanations);
    }

    private static void writeExplanationValue(StreamOutput out, Number value) throws IOException {
        if (value instanceof Float) {
            out.writeByte((byte)0);
            out.writeFloat(value.floatValue());
        } else if (value instanceof Double) {
            out.writeByte((byte)1);
            out.writeDouble(value.doubleValue());
        } else {
            out.writeByte((byte)2);
            out.writeZLong(value.longValue());
        }
    }

    public static void writeExplanation(StreamOutput out, Explanation explanation) throws IOException {
        out.writeBoolean(explanation.isMatch());
        out.writeString(explanation.getDescription());
        Explanation[] subExplanations = explanation.getDetails();
        out.writeVInt(subExplanations.length);
        for (Explanation subExp : subExplanations) {
            Lucene.writeExplanation(out, subExp);
        }
        if (explanation.isMatch()) {
            Lucene.writeExplanationValue(out, explanation.getValue());
        }
    }

    public static int getNumDocs(SegmentInfos info) {
        int numDocs = 0;
        for (SegmentCommitInfo si : info) {
            numDocs += si.info.maxDoc() - si.getDelCount() - si.getSoftDelCount();
        }
        return numDocs;
    }

    public static Comparable readSortValue(StreamInput in) throws IOException {
        byte type = in.readByte();
        if (type == 0) {
            return null;
        }
        if (type == 1) {
            return in.readString();
        }
        if (type == 2) {
            return Integer.valueOf(in.readInt());
        }
        if (type == 3) {
            return Long.valueOf(in.readLong());
        }
        if (type == 4) {
            return Float.valueOf(in.readFloat());
        }
        if (type == 5) {
            return Double.valueOf(in.readDouble());
        }
        if (type == 6) {
            return Byte.valueOf(in.readByte());
        }
        if (type == 7) {
            return Short.valueOf(in.readShort());
        }
        if (type == 8) {
            return Boolean.valueOf(in.readBoolean());
        }
        if (type == 9) {
            return in.readBytesRef();
        }
        if (type == 10) {
            return new BigInteger(in.readString());
        }
        throw new IOException("Can't match type [" + type + "]");
    }

    public static void writeSortValue(StreamOutput out, Object field) throws IOException {
        if (field == null) {
            out.writeByte((byte)0);
        } else {
            Class<?> type = field.getClass();
            if (type == String.class) {
                out.writeByte((byte)1);
                out.writeString((String)field);
            } else if (type == Integer.class) {
                out.writeByte((byte)2);
                out.writeInt((Integer)field);
            } else if (type == Long.class) {
                out.writeByte((byte)3);
                out.writeLong((Long)field);
            } else if (type == Float.class) {
                out.writeByte((byte)4);
                out.writeFloat(((Float)field).floatValue());
            } else if (type == Double.class) {
                out.writeByte((byte)5);
                out.writeDouble((Double)field);
            } else if (type == Byte.class) {
                out.writeByte((byte)6);
                out.writeByte((Byte)field);
            } else if (type == Short.class) {
                out.writeByte((byte)7);
                out.writeShort((Short)field);
            } else if (type == Boolean.class) {
                out.writeByte((byte)8);
                out.writeBoolean((Boolean)field);
            } else if (type == BytesRef.class) {
                out.writeByte((byte)9);
                out.writeBytesRef((BytesRef)field);
            } else if (type == BigInteger.class) {
                out.writeByte((byte)10);
                out.writeString(field.toString());
            } else {
                throw new IOException("Can't handle sort field value of type [" + String.valueOf(type) + "]");
            }
        }
    }

    public static TotalHits readTotalHits(StreamInput in) throws IOException {
        long totalHits = in.readVLong();
        TotalHits.Relation totalHitsRelation = in.readEnum(TotalHits.Relation.class);
        return new TotalHits(totalHits, totalHitsRelation);
    }

    public static void writeTotalHits(StreamOutput out, TotalHits totalHits) throws IOException {
        out.writeVLong(totalHits.value());
        out.writeEnum(totalHits.relation());
    }

    private static Object readMissingValue(StreamInput in) throws IOException {
        byte id = in.readByte();
        switch (id) {
            case 0: {
                return in.readGenericValue();
            }
            case 1: {
                return SortField.STRING_FIRST;
            }
            case 2: {
                return SortField.STRING_LAST;
            }
        }
        throw new IOException("Unknown missing value id: " + id);
    }

    public static SortField.Type readSortType(StreamInput in) throws IOException {
        return SortField.Type.values()[in.readVInt()];
    }

    public static SortField readSortField(StreamInput in) throws IOException {
        String field = null;
        if (in.readBoolean()) {
            field = in.readString();
        }
        SortField.Type sortType = Lucene.readSortType(in);
        Object missingValue = Lucene.readMissingValue(in);
        boolean reverse = in.readBoolean();
        SortField sortField = new SortField(field, sortType, reverse);
        if (missingValue != null) {
            sortField.setMissingValue(missingValue);
        }
        return sortField;
    }

    private static void writeMissingValue(StreamOutput out, Object missingValue) throws IOException {
        if (missingValue == SortField.STRING_FIRST) {
            out.writeByte((byte)1);
        } else if (missingValue == SortField.STRING_LAST) {
            out.writeByte((byte)2);
        } else {
            out.writeByte((byte)0);
            out.writeGenericValue(missingValue);
        }
    }

    public static void writeSortType(StreamOutput out, SortField.Type sortType) throws IOException {
        out.writeVInt(sortType.ordinal());
    }

    public static void writeSortField(StreamOutput out, SortField sortField) throws IOException {
        if (sortField.getClass() == GEO_DISTANCE_SORT_TYPE_CLASS) {
            newSortField = new SortField(sortField.getField(), SortField.Type.DOUBLE);
            newSortField.setMissingValue(sortField.getMissingValue());
            sortField = newSortField;
        } else if (sortField.getClass() == SortedSetSortField.class) {
            newSortField = new SortField(sortField.getField(), SortField.Type.STRING, sortField.getReverse());
            newSortField.setMissingValue(sortField.getMissingValue());
            sortField = newSortField;
        } else if (sortField.getClass() == SortedNumericSortField.class || sortField.getClass() == SortedWiderNumericSortField.class) {
            newSortField = new SortField(sortField.getField(), ((SortedNumericSortField)sortField).getNumericType(), sortField.getReverse());
            newSortField.setMissingValue(sortField.getMissingValue());
            sortField = newSortField;
        }
        if (sortField.getClass() != SortField.class) {
            throw new IllegalArgumentException("Cannot serialize SortField impl [" + String.valueOf(sortField) + "]");
        }
        if (sortField.getField() == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeString(sortField.getField());
        }
        if (sortField.getComparatorSource() != null) {
            IndexFieldDataFieldComparatorSource comparatorSource = (IndexFieldDataFieldComparatorSource)sortField.getComparatorSource();
            Lucene.writeSortType(out, comparatorSource.reducedType());
            Lucene.writeMissingValue(out, comparatorSource.missingValue(sortField.getReverse()));
        } else {
            Lucene.writeSortType(out, sortField.getType());
            Lucene.writeMissingValue(out, sortField.getMissingValue());
        }
        out.writeBoolean(sortField.getReverse());
    }

    public static ScoreDoc readScoreDoc(StreamInput in) throws IOException {
        return new ScoreDoc(in.readVInt(), in.readFloat());
    }

    public static void writeScoreDoc(StreamOutput out, ScoreDoc scoreDoc) throws IOException {
        if (!scoreDoc.getClass().equals(ScoreDoc.class)) {
            throw new IllegalArgumentException("This method can only be used to serialize a ScoreDoc, not a " + String.valueOf(scoreDoc.getClass()));
        }
        out.writeVInt(scoreDoc.doc);
        out.writeFloat(scoreDoc.score);
    }

    public static void writeTopDocs(StreamOutput out, TopDocsAndMaxScore topDocs) throws IOException {
        if (topDocs.topDocs instanceof TopFieldGroups) {
            out.writeByte((byte)2);
            TopFieldGroups topFieldGroups = (TopFieldGroups)topDocs.topDocs;
            Lucene.writeTotalHits(out, topDocs.topDocs.totalHits);
            out.writeFloat(topDocs.maxScore);
            out.writeString(topFieldGroups.field);
            out.writeArray(Lucene::writeSortField, topFieldGroups.fields);
            out.writeVInt(topDocs.topDocs.scoreDocs.length);
            for (int i = 0; i < topDocs.topDocs.scoreDocs.length; ++i) {
                ScoreDoc doc = topFieldGroups.scoreDocs[i];
                Lucene.writeFieldDoc(out, (FieldDoc)doc);
                Lucene.writeSortValue(out, topFieldGroups.groupValues[i]);
            }
        } else if (topDocs.topDocs instanceof TopFieldDocs) {
            out.writeByte((byte)1);
            TopFieldDocs topFieldDocs = (TopFieldDocs)topDocs.topDocs;
            Lucene.writeTotalHits(out, topDocs.topDocs.totalHits);
            out.writeFloat(topDocs.maxScore);
            out.writeArray(Lucene::writeSortField, topFieldDocs.fields);
            out.writeVInt(topDocs.topDocs.scoreDocs.length);
            for (ScoreDoc doc : topFieldDocs.scoreDocs) {
                Lucene.writeFieldDoc(out, (FieldDoc)doc);
            }
        } else {
            out.writeByte((byte)0);
            Lucene.writeTotalHits(out, topDocs.topDocs.totalHits);
            out.writeFloat(topDocs.maxScore);
            out.writeVInt(topDocs.topDocs.scoreDocs.length);
            for (ScoreDoc doc : topDocs.topDocs.scoreDocs) {
                Lucene.writeScoreDoc(out, doc);
            }
        }
    }

    public static void writeFieldDoc(StreamOutput out, FieldDoc fieldDoc) throws IOException {
        out.writeVInt(fieldDoc.fields.length);
        for (Object field : fieldDoc.fields) {
            Lucene.writeSortValue(out, field);
        }
        out.writeVInt(fieldDoc.doc);
        out.writeFloat(fieldDoc.score);
    }

    public static TopDocsAndMaxScore readTopDocs(StreamInput in) throws IOException {
        byte type = in.readByte();
        if (type == 0) {
            ScoreDoc[] scoreDocs;
            TotalHits totalHits = Lucene.readTotalHits(in);
            float maxScore = in.readFloat();
            int scoreDocCount = in.readVInt();
            if (scoreDocCount == 0) {
                scoreDocs = EMPTY_SCORE_DOCS;
            } else {
                scoreDocs = new ScoreDoc[scoreDocCount];
                for (int i = 0; i < scoreDocs.length; ++i) {
                    scoreDocs[i] = new ScoreDoc(in.readVInt(), in.readFloat());
                }
            }
            return new TopDocsAndMaxScore(new TopDocs(totalHits, scoreDocs), maxScore);
        }
        if (type == 1) {
            TotalHits totalHits = Lucene.readTotalHits(in);
            float maxScore = in.readFloat();
            SortField[] fields = in.readArray(Lucene::readSortField, SortField[]::new);
            FieldDoc[] fieldDocs = new FieldDoc[in.readVInt()];
            for (int i = 0; i < fieldDocs.length; ++i) {
                fieldDocs[i] = Lucene.readFieldDoc(in);
            }
            return new TopDocsAndMaxScore((TopDocs)new TopFieldDocs(totalHits, (ScoreDoc[])fieldDocs, fields), maxScore);
        }
        if (type == 2) {
            TotalHits totalHits = Lucene.readTotalHits(in);
            float maxScore = in.readFloat();
            String field = in.readString();
            SortField[] fields = in.readArray(Lucene::readSortField, SortField[]::new);
            int size = in.readVInt();
            Object[] collapseValues = new Object[size];
            FieldDoc[] fieldDocs = new FieldDoc[size];
            for (int i = 0; i < fieldDocs.length; ++i) {
                fieldDocs[i] = Lucene.readFieldDoc(in);
                collapseValues[i] = Lucene.readSortValue(in);
            }
            return new TopDocsAndMaxScore((TopDocs)new TopFieldGroups(field, totalHits, (ScoreDoc[])fieldDocs, fields, collapseValues), maxScore);
        }
        throw new IllegalStateException("Unknown type " + type);
    }

    public static FieldDoc readFieldDoc(StreamInput in) throws IOException {
        Object[] cFields = new Comparable[in.readVInt()];
        for (int j = 0; j < cFields.length; ++j) {
            byte type = in.readByte();
            if (type == 0) {
                cFields[j] = null;
                continue;
            }
            if (type == 1) {
                cFields[j] = in.readString();
                continue;
            }
            if (type == 2) {
                cFields[j] = in.readInt();
                continue;
            }
            if (type == 3) {
                cFields[j] = in.readLong();
                continue;
            }
            if (type == 4) {
                cFields[j] = Float.valueOf(in.readFloat());
                continue;
            }
            if (type == 5) {
                cFields[j] = in.readDouble();
                continue;
            }
            if (type == 6) {
                cFields[j] = in.readByte();
                continue;
            }
            if (type == 7) {
                cFields[j] = in.readShort();
                continue;
            }
            if (type == 8) {
                cFields[j] = in.readBoolean();
                continue;
            }
            if (type == 9) {
                cFields[j] = in.readBytesRef();
                continue;
            }
            if (type == 10) {
                cFields[j] = new BigInteger(in.readString());
                continue;
            }
            throw new IOException("Can't match type [" + type + "]");
        }
        return new FieldDoc(in.readVInt(), in.readFloat(), cFields);
    }

    @SuppressForbidden(reason="Version#parseLeniently() used in a central place")
    private static final class LenientParser {
        private LenientParser() {
        }

        public static Version parse(String toParse, Version defaultValue) {
            if (Strings.hasLength(toParse)) {
                try {
                    return Version.parseLeniently((String)toParse);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            return defaultValue;
        }
    }
}

