/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.lucene.analysis.miscellaneous;

import org.apache.lucene.util.RamUsageEstimator;

public class DuplicateByteSequenceSpotter {
    public static final int TREE_DEPTH = 6;
    public static final int MAX_HIT_COUNT = 255;
    private final TreeNode root;
    private boolean sequenceBufferFilled = false;
    private final byte[] sequenceBuffer = new byte[6];
    private int nextFreePos = 0;
    private final int[] nodesAllocatedByDepth = new int[4];
    private int nodesResizedByDepth;
    private long bytesAllocated = 0L;
    static final long TREE_NODE_OBJECT_SIZE = RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + RamUsageEstimator.NUM_BYTES_OBJECT_REF;
    static final long ROOT_TREE_NODE_OBJECT_SIZE = TREE_NODE_OBJECT_SIZE + (long)RamUsageEstimator.NUM_BYTES_OBJECT_REF;
    static final long LIGHTWEIGHT_TREE_NODE_OBJECT_SIZE = TREE_NODE_OBJECT_SIZE + (long)RamUsageEstimator.NUM_BYTES_OBJECT_REF;
    static final long LEAF_NODE_OBJECT_SIZE = TREE_NODE_OBJECT_SIZE + 2L + 4L;

    public DuplicateByteSequenceSpotter() {
        this.root = new RootTreeNode(1, null, 0);
    }

    public void startNewSequence() {
        this.sequenceBufferFilled = false;
        this.nextFreePos = 0;
    }

    public short addByte(byte b) {
        this.sequenceBuffer[this.nextFreePos] = b;
        ++this.nextFreePos;
        if (this.nextFreePos >= this.sequenceBuffer.length) {
            this.nextFreePos = 0;
            this.sequenceBufferFilled = true;
        }
        if (!this.sequenceBufferFilled) {
            return 0;
        }
        TreeNode node = this.root;
        int p = this.nextFreePos;
        node = node.add(this.sequenceBuffer[p], 0);
        p = this.nextBufferPos(p);
        node = node.add(this.sequenceBuffer[p], 1);
        p = this.nextBufferPos(p);
        node = node.add(this.sequenceBuffer[p], 2);
        p = this.nextBufferPos(p);
        int sequence = 0xFF & this.sequenceBuffer[p];
        p = this.nextBufferPos(p);
        sequence = sequence << 8 | 0xFF & this.sequenceBuffer[p];
        p = this.nextBufferPos(p);
        sequence = sequence << 8 | 0xFF & this.sequenceBuffer[p];
        return (short)(node.add(sequence << 8) - 1);
    }

    private int nextBufferPos(int p) {
        if (++p >= this.sequenceBuffer.length) {
            p = 0;
        }
        return p;
    }

    public final long getEstimatedSizeInBytes() {
        return this.bytesAllocated;
    }

    public int[] getNodesAllocatedByDepth() {
        return (int[])this.nodesAllocatedByDepth.clone();
    }

    public int getNodesResizedByDepth() {
        return this.nodesResizedByDepth;
    }

    class RootTreeNode
    extends TreeNode {
        TreeNode[] children;

        RootTreeNode(byte key, TreeNode parentNode, int depth) {
            super(DuplicateByteSequenceSpotter.this, key, parentNode, depth);
            DuplicateByteSequenceSpotter.this.bytesAllocated += ROOT_TREE_NODE_OBJECT_SIZE;
        }

        @Override
        public TreeNode add(byte b, int depth) {
            int bIndex;
            TreeNode node;
            if (this.children == null) {
                this.children = new TreeNode[256];
                DuplicateByteSequenceSpotter.this.bytesAllocated += (long)(RamUsageEstimator.NUM_BYTES_OBJECT_REF * 256);
            }
            if ((node = this.children[bIndex = 0xFF & b]) == null) {
                node = depth <= 1 ? new RootTreeNode(b, this, depth) : new LightweightTreeNode(b, this, depth);
                this.children[bIndex] = node;
            }
            return node;
        }

        @Override
        public short add(int byteSequence) {
            throw new UnsupportedOperationException("Root nodes do not support byte sequences encoded as integers");
        }
    }

    abstract class TreeNode {
        TreeNode(DuplicateByteSequenceSpotter this$0, byte key, TreeNode parentNode, int depth) {
            int n = depth;
            this$0.nodesAllocatedByDepth[n] = this$0.nodesAllocatedByDepth[n] + 1;
        }

        public abstract TreeNode add(byte var1, int var2);

        public abstract short add(int var1);
    }

    final class LightweightTreeNode
    extends TreeNode {
        int[] children;

        LightweightTreeNode(byte key, TreeNode parentNode, int depth) {
            super(DuplicateByteSequenceSpotter.this, key, parentNode, depth);
            this.children = null;
            DuplicateByteSequenceSpotter.this.bytesAllocated += LIGHTWEIGHT_TREE_NODE_OBJECT_SIZE;
        }

        @Override
        public short add(int byteSequence) {
            if (this.children == null) {
                this.children = new int[1];
                DuplicateByteSequenceSpotter.this.bytesAllocated += (long)(RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + 4);
                this.children[0] = byteSequence + 1;
                return 1;
            }
            for (int i = 0; i < this.children.length; ++i) {
                int child = this.children[i];
                if (byteSequence != (child & 0xFFFFFF00)) continue;
                int hitCount = child & 0xFF;
                if (hitCount < 255) {
                    int n = i;
                    this.children[n] = this.children[n] + 1;
                }
                return (short)(hitCount + 1);
            }
            int[] newChildren = new int[this.children.length + 1];
            DuplicateByteSequenceSpotter.this.bytesAllocated += 4L;
            System.arraycopy(this.children, 0, newChildren, 0, this.children.length);
            this.children = newChildren;
            this.children[newChildren.length - 1] = byteSequence + 1;
            ++DuplicateByteSequenceSpotter.this.nodesResizedByDepth;
            return 1;
        }

        @Override
        public TreeNode add(byte b, int depth) {
            throw new UnsupportedOperationException("Leaf nodes do not take byte sequences");
        }
    }
}

