/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.lucene.search;

import io.skylite.core.lucene.Lucene;
import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.FilterLeafCollector;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;

public class FilteredCollector
implements Collector {
    private final Collector collector;
    private final Weight filter;

    public FilteredCollector(Collector collector, Weight filter) {
        this.collector = collector;
        this.filter = filter;
    }

    public Collector getCollector() {
        return this.collector;
    }

    public LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
        ScorerSupplier filterScorerSupplier = this.filter.scorerSupplier(context);
        LeafCollector in = this.collector.getLeafCollector(context);
        final Bits bits = Lucene.asSequentialAccessBits(context.reader().maxDoc(), filterScorerSupplier);
        return new FilterLeafCollector(this, in){

            public void collect(int doc) throws IOException {
                if (bits.get(doc)) {
                    this.in.collect(doc);
                }
            }
        };
    }

    public ScoreMode scoreMode() {
        return this.collector.scoreMode();
    }
}

