/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.lucene.search.grouping;

import io.skylite.core.index.fielddata.AbstractNumericDocValues;
import io.skylite.core.index.fielddata.AbstractSortedDocValues;
import io.skylite.core.mapper.BaseMappedFieldType;
import java.io.IOException;
import java.util.Collection;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.grouping.GroupSelector;
import org.apache.lucene.search.grouping.SearchGroup;
import org.apache.lucene.util.BytesRef;

abstract class GroupingDocValuesSelector<T>
extends GroupSelector<T> {
    protected final String field;

    GroupingDocValuesSelector(String field) {
        this.field = field;
    }

    public void setGroups(Collection<SearchGroup<T>> groups) {
        throw new UnsupportedOperationException();
    }

    private static DocValuesType getDocValuesType(LeafReader in, String field) {
        FieldInfo fi = in.getFieldInfos().fieldInfo(field);
        if (fi != null) {
            return fi.getDocValuesType();
        }
        return null;
    }

    static class Keyword
    extends GroupingDocValuesSelector<BytesRef> {
        private SortedDocValues values;
        private int ord;

        Keyword(BaseMappedFieldType fieldType) {
            super(fieldType.name());
        }

        public GroupSelector.State advanceTo(int doc) throws IOException {
            if (this.values.advanceExact(doc)) {
                this.ord = this.values.ordValue();
                return GroupSelector.State.ACCEPT;
            }
            this.ord = -1;
            return GroupSelector.State.SKIP;
        }

        public BytesRef currentValue() {
            if (this.ord == -1) {
                return null;
            }
            try {
                return this.values.lookupOrd(this.ord);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public BytesRef copyValue() {
            BytesRef value = this.currentValue();
            if (value == null) {
                return null;
            }
            return BytesRef.deepCopyOf((BytesRef)value);
        }

        public void setNextReader(LeafReaderContext readerContext) throws IOException {
            LeafReader reader = readerContext.reader();
            DocValuesType type = GroupingDocValuesSelector.getDocValuesType(reader, this.field);
            if (type == null || type == DocValuesType.NONE) {
                this.values = DocValues.emptySorted();
                return;
            }
            switch (type) {
                case SORTED: {
                    this.values = DocValues.getSorted((LeafReader)reader, (String)this.field);
                    break;
                }
                case SORTED_SET: {
                    final SortedSetDocValues sorted = DocValues.getSortedSet((LeafReader)reader, (String)this.field);
                    this.values = DocValues.unwrapSingleton((SortedSetDocValues)sorted);
                    if (this.values != null) break;
                    this.values = new AbstractSortedDocValues(this){
                        private int ord;

                        public boolean advanceExact(int target) throws IOException {
                            if (sorted.advanceExact(target)) {
                                this.ord = (int)sorted.nextOrd();
                                if (sorted.nextOrd() >= (long)sorted.docValueCount()) {
                                    throw new IllegalStateException("failed to extract doc: " + target + ", the grouping field must be single valued");
                                }
                                return true;
                            }
                            return false;
                        }

                        public int docID() {
                            return sorted.docID();
                        }

                        public int ordValue() {
                            return this.ord;
                        }

                        public BytesRef lookupOrd(int ord) throws IOException {
                            return sorted.lookupOrd((long)ord);
                        }

                        public int getValueCount() {
                            return (int)sorted.getValueCount();
                        }
                    };
                    break;
                }
                default: {
                    throw new IllegalStateException("unexpected doc values type " + String.valueOf(type) + "` for field `" + this.field + "`");
                }
            }
        }

        public void setScorer(Scorable scorer) throws IOException {
        }
    }

    static class Numeric
    extends GroupingDocValuesSelector<Long> {
        private NumericDocValues values;
        private long value;
        private boolean hasValue;

        Numeric(BaseMappedFieldType fieldType) {
            super(fieldType.name());
        }

        public GroupSelector.State advanceTo(int doc) throws IOException {
            if (this.values.advanceExact(doc)) {
                this.hasValue = true;
                this.value = this.values.longValue();
                return GroupSelector.State.ACCEPT;
            }
            this.hasValue = false;
            return GroupSelector.State.SKIP;
        }

        public Long currentValue() {
            return this.hasValue ? Long.valueOf(this.value) : null;
        }

        public Long copyValue() {
            return this.currentValue();
        }

        public void setNextReader(LeafReaderContext readerContext) throws IOException {
            LeafReader reader = readerContext.reader();
            DocValuesType type = GroupingDocValuesSelector.getDocValuesType(reader, this.field);
            if (type == null || type == DocValuesType.NONE) {
                this.values = DocValues.emptyNumeric();
                return;
            }
            switch (type) {
                case NUMERIC: {
                    this.values = DocValues.getNumeric((LeafReader)reader, (String)this.field);
                    break;
                }
                case SORTED_NUMERIC: {
                    final SortedNumericDocValues sorted = DocValues.getSortedNumeric((LeafReader)reader, (String)this.field);
                    this.values = DocValues.unwrapSingleton((SortedNumericDocValues)sorted);
                    if (this.values != null) break;
                    this.values = new AbstractNumericDocValues(this){
                        private long value;

                        public boolean advanceExact(int target) throws IOException {
                            if (sorted.advanceExact(target)) {
                                if (sorted.docValueCount() > 1) {
                                    throw new IllegalStateException("failed to extract doc: " + target + ", the grouping field must be single valued");
                                }
                                this.value = sorted.nextValue();
                                return true;
                            }
                            return false;
                        }

                        public int docID() {
                            return sorted.docID();
                        }

                        public long longValue() throws IOException {
                            return this.value;
                        }
                    };
                    break;
                }
                default: {
                    throw new IllegalStateException("unexpected doc values type " + String.valueOf(type) + "` for field `" + this.field + "`");
                }
            }
        }

        public void setScorer(Scorable scorer) throws IOException {
        }
    }
}

