/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.mapper;

import io.skylite.common.Nullable;
import io.skylite.core.analysis.NamedAnalyzer;
import io.skylite.core.common.time.DateMathParser;
import io.skylite.core.index.fielddata.DocValueFormat;
import io.skylite.core.index.query.IntervalMode;
import io.skylite.core.index.query.QueryRewriteContext;
import io.skylite.core.mapper.TextSearchInfo;
import java.io.IOException;
import java.time.ZoneId;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.queries.intervals.IntervalsSource;

public abstract class BaseMappedFieldType {
    protected final String name;
    protected final boolean docValues;
    protected final boolean isIndexed;
    protected final boolean isStored;
    protected final Map<String, String> meta;
    protected final TextSearchInfo textSearchInfo;
    private boolean eagerGlobalOrdinals;

    public BaseMappedFieldType(String name, boolean hasDocValues, boolean isIndexed, boolean isStored, Map<String, String> meta, TextSearchInfo textSearchInfo) {
        this.name = Objects.requireNonNull(name);
        this.docValues = hasDocValues;
        this.isIndexed = isIndexed;
        this.isStored = isStored;
        this.meta = meta;
        this.textSearchInfo = Objects.requireNonNull(textSearchInfo);
    }

    public String name() {
        return this.name;
    }

    public abstract String typeName();

    public boolean hasDocValues() {
        return this.docValues;
    }

    public boolean isSearchable() {
        return this.isIndexed;
    }

    public boolean isStored() {
        return this.isStored;
    }

    public Map<String, String> meta() {
        return this.meta;
    }

    public TextSearchInfo getTextSearchInfo() {
        return this.textSearchInfo;
    }

    public String familyTypeName() {
        return this.typeName();
    }

    public boolean eagerGlobalOrdinals() {
        return this.eagerGlobalOrdinals;
    }

    public void setEagerGlobalOrdinals(boolean eagerGlobalOrdinals) {
        this.eagerGlobalOrdinals = eagerGlobalOrdinals;
    }

    protected final void failIfNoDocValues() {
        if (!this.hasDocValues()) {
            throw new IllegalArgumentException("Can't load fielddata on [" + this.name() + "] because fielddata is unsupported on fields of type [" + this.typeName() + "]. Use doc values instead.");
        }
    }

    protected final void failIfNotIndexed() {
        if (!this.isIndexed) {
            throw new IllegalArgumentException("Cannot search on field [" + this.name() + "] since it is not indexed.");
        }
    }

    public Object valueForDisplay(Object value) {
        return value;
    }

    @Nullable
    public Function<byte[], Number> pointReaderIfPossible() {
        return null;
    }

    public IntervalsSource intervals(String query, int max_gaps, IntervalMode mode, NamedAnalyzer analyzer, boolean prefix) throws IOException {
        throw new IllegalArgumentException("Can only use interval queries on text fields - not on [" + this.name + "] which is of type [" + this.typeName() + "]");
    }

    public Relation isFieldWithinQuery(IndexReader reader, Object from, Object to, boolean includeLower, boolean includeUpper, ZoneId timeZone, DateMathParser dateMathParser, QueryRewriteContext context) throws IOException {
        return Relation.INTERSECTS;
    }

    public DocValueFormat docValueFormat(@Nullable String format, ZoneId timeZone) {
        if (format != null) {
            throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] does not support custom formats");
        }
        if (timeZone != null) {
            throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] does not support custom time zones");
        }
        return DocValueFormat.RAW;
    }

    public static enum Relation {
        WITHIN,
        INTERSECTS,
        DISJOINT;

    }
}

