/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.mapper;

import io.skylite.SkyliteException;
import io.skylite.core.ParseField;
import io.skylite.core.aggregations.values.CoreValuesSourceType;
import io.skylite.core.common.bytes.BytesArray;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.common.io.stream.BytesStreamOutput;
import io.skylite.core.common.util.CollectionUtils;
import io.skylite.core.index.fielddata.BaseIndexFieldData;
import io.skylite.core.index.fielddata.DocValueFormat;
import io.skylite.core.index.fielddata.plain.BytesBinaryIndexFieldData;
import io.skylite.core.index.query.QueryShardContext;
import io.skylite.core.index.query.QueryShardException;
import io.skylite.core.mapper.ContentPath;
import io.skylite.core.mapper.CustomDocValuesField;
import io.skylite.core.mapper.FieldMapper;
import io.skylite.core.mapper.MappedFieldType;
import io.skylite.core.mapper.ParseContext;
import io.skylite.core.mapper.SourceValueFetcher;
import io.skylite.core.mapper.TextSearchInfo;
import io.skylite.core.mapper.ValueFetcher;
import io.skylite.core.search.lookup.SearchLookup;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.lucene.document.InvertableType;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StoredValue;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;

public class BinaryFieldMapper
extends FieldMapper {
    public static final String CONTENT_TYPE = ParseField.CoreTypes.BINARY_FIELD.getPreferredName();
    public static final FieldMapper.TypeParser PARSER = new FieldMapper.TypeParser((n, c) -> new Builder((String)n));
    private final boolean stored;
    private final boolean hasDocValues;

    private static BinaryFieldMapper toType(FieldMapper in) {
        return (BinaryFieldMapper)in;
    }

    protected BinaryFieldMapper(String simpleName, MappedFieldType mappedFieldType, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, Builder builder) {
        super(simpleName, mappedFieldType, multiFields, copyTo);
        this.stored = builder.stored.getValue();
        this.hasDocValues = builder.hasDocValues.getValue();
    }

    @Override
    protected void parseCreateField(ParseContext context) throws IOException {
        if (!this.stored && !this.hasDocValues) {
            return;
        }
        byte[] value = context.parseExternalValue(byte[].class);
        if (value == null) {
            if (context.parser().currentToken() == XContentParser.Token.VALUE_NULL) {
                return;
            }
            value = context.parser().binaryValue();
        }
        if (value == null) {
            return;
        }
        if (this.stored) {
            context.doc().add((IndexableField)new StoredField(this.fieldType().name(), value));
        }
        if (this.hasDocValues) {
            CustomBinaryDocValuesField field = (CustomBinaryDocValuesField)context.doc().getByKey(this.fieldType().name());
            if (field == null) {
                field = new CustomBinaryDocValuesField(this.fieldType().name(), value);
                context.doc().addWithKey(this.fieldType().name(), field);
            } else {
                field.add(value);
            }
        } else {
            context.addFieldToFieldNamesField(this.fieldType().name());
        }
    }

    @Override
    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.simpleName()).init(this);
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    public static class Builder
    extends FieldMapper.Builder {
        private final FieldMapper.Parameter<Boolean> stored = FieldMapper.Parameter.storeParam(m -> BinaryFieldMapper.toType((FieldMapper)m).stored, false);
        private final FieldMapper.Parameter<Boolean> hasDocValues = FieldMapper.Parameter.docValuesParam(m -> BinaryFieldMapper.toType((FieldMapper)m).hasDocValues, false);
        private final FieldMapper.Parameter<Map<String, String>> meta = FieldMapper.Parameter.metaParam();

        public Builder(String name) {
            this(name, false);
        }

        public Builder(String name, boolean hasDocValues) {
            super(name);
            this.hasDocValues.setValue(hasDocValues);
        }

        @Override
        public List<FieldMapper.Parameter<?>> getParameters() {
            return Arrays.asList(this.meta, this.stored, this.hasDocValues);
        }

        @Override
        public BinaryFieldMapper build(ContentPath contentPath) {
            return new BinaryFieldMapper(this.name, (MappedFieldType)new BinaryFieldType(this.buildFullName(contentPath), this.stored.getValue(), this.hasDocValues.getValue(), this.meta.getValue()), this.multiFieldsBuilder.build(this, contentPath), this.copyTo.build(), this);
        }
    }

    public static class CustomBinaryDocValuesField
    extends CustomDocValuesField {
        private final ArrayList<byte[]> bytesList = new ArrayList();

        public CustomBinaryDocValuesField(String name, byte[] bytes) {
            super(name);
            this.add(bytes);
        }

        public void add(byte[] bytes) {
            this.bytesList.add(bytes);
        }

        public BytesRef binaryValue() {
            CollectionUtils.sortAndDedup(this.bytesList, Arrays::compareUnsigned);
            int size = this.bytesList.stream().map(b -> ((byte[])b).length).reduce(0, Integer::sum);
            int length = this.bytesList.size();
            BytesStreamOutput out = new BytesStreamOutput(size + (length + 1) * 5);
            try {
                out.writeVInt(length);
                for (byte[] value : this.bytesList) {
                    int valueLength = value.length;
                    out.writeVInt(valueLength);
                    out.writeBytes(value, 0, valueLength);
                }
                BytesRef bytesRef = out.bytes().toBytesRef();
                out.close();
                return bytesRef;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        out.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new SkyliteException("Failed to get binary value", (Throwable)e, new Object[0]);
                }
            }
        }

        public StoredValue storedValue() {
            return null;
        }

        public InvertableType invertableType() {
            return InvertableType.BINARY;
        }
    }

    public static final class BinaryFieldType
    extends MappedFieldType {
        private BinaryFieldType(String name, boolean isStored, boolean hasDocValues, Map<String, String> meta) {
            super(name, false, isStored, hasDocValues, TextSearchInfo.NONE, meta);
        }

        public BinaryFieldType(String name) {
            this(name, false, true, Collections.emptyMap());
        }

        @Override
        public String typeName() {
            return CONTENT_TYPE;
        }

        @Override
        public ValueFetcher valueFetcher(QueryShardContext context, SearchLookup searchLookup, String format) {
            return SourceValueFetcher.identity(this.name(), context, format);
        }

        @Override
        public DocValueFormat docValueFormat(String format, ZoneId timeZone) {
            return DocValueFormat.BINARY;
        }

        @Override
        public BytesReference valueForDisplay(Object value) {
            if (value == null) {
                return null;
            }
            BytesReference bytes = value instanceof BytesRef ? new BytesArray((BytesRef)value) : (value instanceof BytesReference ? (BytesReference)value : (value instanceof byte[] ? new BytesArray((byte[])value) : new BytesArray(Base64.getDecoder().decode(value.toString()))));
            return bytes;
        }

        @Override
        public BaseIndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName, Supplier<SearchLookup> searchLookup) {
            this.failIfNoDocValues();
            return new BytesBinaryIndexFieldData.Builder(this.name(), CoreValuesSourceType.BYTES);
        }

        @Override
        public Query termQuery(Object value, QueryShardContext context) {
            throw new QueryShardException(context.getFullyQualifiedIndex(), "Binary fields do not support searching", new Object[0]);
        }
    }
}

