/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.mapper;

import io.skylite.SkyliteGenerationException;
import io.skylite.core.common.text.Text;
import io.skylite.core.compress.CompressedXContent;
import io.skylite.core.index.IndexSettings;
import io.skylite.core.mapper.ContentPath;
import io.skylite.core.mapper.DocumentParser;
import io.skylite.core.mapper.IdFieldMapper;
import io.skylite.core.mapper.IndexFieldMapper;
import io.skylite.core.mapper.MappedParsedDocument;
import io.skylite.core.mapper.MapperParsingException;
import io.skylite.core.mapper.MapperService;
import io.skylite.core.mapper.Mapping;
import io.skylite.core.mapper.MappingLookup;
import io.skylite.core.mapper.MergeReason;
import io.skylite.core.mapper.MetadataFieldMapper;
import io.skylite.core.mapper.NestedObjectMapper;
import io.skylite.core.mapper.ObjectMapper;
import io.skylite.core.mapper.RootObjectMapper;
import io.skylite.core.mapper.RoutingFieldMapper;
import io.skylite.core.mapper.SourceFieldMapper;
import io.skylite.core.mapper.SourceToParse;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentFragment;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DocumentMapper
implements ToXContentFragment {
    private final String type;
    private final Text typeText;
    private final CompressedXContent mappingSource;
    private final DocumentParser documentParser;
    private final MappingLookup mappingLookup;

    public static DocumentMapper createEmpty(MapperService mapperService) {
        RootObjectMapper root = new RootObjectMapper.Builder("_doc").build(new ContentPath(1));
        MetadataFieldMapper[] metadata = mapperService.getMetadataMappers().values().toArray(new MetadataFieldMapper[0]);
        Mapping mapping = new Mapping(root, metadata, Collections.emptyMap());
        return new DocumentMapper(mapperService.documentParser(), mapping);
    }

    DocumentMapper(DocumentParser documentParser, Mapping mapping) {
        this.type = mapping.getRoot().name();
        this.typeText = new Text(this.type);
        this.documentParser = documentParser;
        this.mappingLookup = Mapping.fromMapping(mapping);
        try {
            this.mappingSource = new CompressedXContent(this, ToXContent.EMPTY_PARAMS);
        }
        catch (Exception e) {
            throw new SkyliteGenerationException("failed to serialize source for type [" + this.type + "]", e);
        }
    }

    public Mapping mapping() {
        return this.mappingLookup.getMapping();
    }

    public String type() {
        return this.type;
    }

    public Text typeText() {
        return this.typeText;
    }

    public CompressedXContent mappingSource() {
        return this.mappingSource;
    }

    public <T extends MetadataFieldMapper> T metadataMapper(Class<T> type) {
        return this.mapping().getMetadataMapperByClass(type);
    }

    public SourceFieldMapper sourceMapper() {
        return this.metadataMapper(SourceFieldMapper.class);
    }

    public IdFieldMapper idFieldMapper() {
        return this.metadataMapper(IdFieldMapper.class);
    }

    public RoutingFieldMapper routingFieldMapper() {
        return this.metadataMapper(RoutingFieldMapper.class);
    }

    public IndexFieldMapper IndexFieldMapper() {
        return this.metadataMapper(IndexFieldMapper.class);
    }

    public boolean hasNestedObjects() {
        return this.mappers().hasNested();
    }

    public MappingLookup mappers() {
        return this.mappingLookup;
    }

    public MappedParsedDocument parse(SourceToParse source) throws MapperParsingException {
        return this.documentParser.parseDocument(source, this.mappingLookup);
    }

    public boolean hasNonNestedParent(String path) {
        ObjectMapper mapper = this.mappers().objectMappers().get(path);
        if (mapper == null) {
            return false;
        }
        while (mapper != null) {
            if (!mapper.isNested()) {
                return true;
            }
            if (!path.contains(".")) {
                return false;
            }
            path = path.substring(0, path.lastIndexOf("."));
            mapper = this.mappers().objectMappers().get(path);
        }
        return false;
    }

    public List<NestedObjectMapper> getNestedMappers() {
        ArrayList<NestedObjectMapper> childMappers = new ArrayList<NestedObjectMapper>();
        for (ObjectMapper mapper : this.mappers().objectMappers().values()) {
            if (!mapper.isNested()) continue;
            childMappers.add((NestedObjectMapper)mapper);
        }
        return childMappers;
    }

    public List<NestedObjectMapper> getNestedParentMappers() {
        ArrayList<NestedObjectMapper> parents = new ArrayList<NestedObjectMapper>();
        for (ObjectMapper mapper : this.mappers().objectMappers().values()) {
            ObjectMapper parent;
            String nestedParentPath = this.getNestedParent(mapper.fullPath());
            if (nestedParentPath == null || !(parent = this.mappers().objectMappers().get(nestedParentPath)).isNested()) continue;
            parents.add((NestedObjectMapper)parent);
        }
        return parents;
    }

    public String getNestedParent(String path) {
        ObjectMapper mapper = this.mappers().objectMappers().get(path);
        if (mapper == null) {
            return null;
        }
        if (!path.contains(".")) {
            return null;
        }
        do {
            path = path.substring(0, path.lastIndexOf("."));
            mapper = this.mappers().objectMappers().get(path);
            if (mapper == null) {
                return null;
            }
            if (!mapper.isNested()) continue;
            return path;
        } while (path.contains("."));
        return null;
    }

    public DocumentMapper merge(Mapping mapping, MergeReason reason) {
        Mapping merged = this.mapping().merge(mapping, reason);
        return new DocumentMapper(this.documentParser, merged);
    }

    public void validate(IndexSettings settings, boolean checkLimits) {
        this.mapping().validate(this.mappingLookup);
        if (settings.getIndexMetadata().isRoutingPartitionedIndex() && !this.routingFieldMapper().required()) {
            throw new IllegalArgumentException("mapping type [" + this.type() + "] must have routing required for partitioned index [" + settings.getIndex().getName() + "]");
        }
        if (settings.getIndexSortConfig().hasIndexSort() && this.mappers().hasNested()) {
            throw new IllegalArgumentException("cannot have nested fields when index sort is activated");
        }
        if (checkLimits) {
            this.mappingLookup.checkLimits(settings);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return this.mapping().toXContent(builder, params);
    }

    public String toString() {
        return "DocumentMapper{type='" + this.type + "', typeText=" + String.valueOf(this.typeText) + ", mappingSource=" + String.valueOf(this.mappingSource) + ", mapping=" + String.valueOf(this.mappingLookup.getMapping()) + ", documentParser=" + String.valueOf(this.documentParser) + ", fieldMappers=" + String.valueOf(this.mappingLookup.fieldMappers()) + ", objectMappers=" + String.valueOf(this.mappingLookup.objectMappers()) + ", hasNestedObjects=" + this.mappers().hasNested() + "}";
    }
}

