/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.mapper;

import io.skylite.core.ParseField;
import io.skylite.core.aggregations.values.CoreValuesSourceType;
import io.skylite.core.aggregations.values.ValuesSourceType;
import io.skylite.core.common.logging.DeprecationLogger;
import io.skylite.core.common.util.BigArrays;
import io.skylite.core.index.fielddata.BaseIndexFieldData;
import io.skylite.core.index.fielddata.DocValueFormat;
import io.skylite.core.index.fielddata.IndexFieldData;
import io.skylite.core.index.fielddata.IndexFieldDataCache;
import io.skylite.core.index.fielddata.IndexFieldDataFieldComparatorSource;
import io.skylite.core.index.fielddata.LeafFieldData;
import io.skylite.core.index.fielddata.ScriptDocValues;
import io.skylite.core.index.fielddata.SortedBinaryDocValues;
import io.skylite.core.index.fielddata.fieldcomparator.BytesRefFieldComparatorSource;
import io.skylite.core.index.fielddata.plain.PagedBytesIndexFieldData;
import io.skylite.core.index.query.QueryShardContext;
import io.skylite.core.indices.IndicesServiceSettings;
import io.skylite.core.indices.breaker.CircuitBreakerService;
import io.skylite.core.lucene.Lucene;
import io.skylite.core.mapper.MetadataFieldMapper;
import io.skylite.core.mapper.MetadataFieldsUtil;
import io.skylite.core.mapper.ParseContext;
import io.skylite.core.mapper.TermBasedFieldType;
import io.skylite.core.mapper.TextSearchInfo;
import io.skylite.core.mapper.Uid;
import io.skylite.core.mapper.ValueFetcher;
import io.skylite.core.search.MultiValueMode;
import io.skylite.core.search.lookup.SearchLookup;
import io.skylite.core.search.sort.BucketedSort;
import io.skylite.core.search.sort.SortOrder;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.FieldComparatorSource;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermInSetQuery;
import org.apache.lucene.util.BytesRef;

public class IdFieldMapper
extends MetadataFieldMapper {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(IdFieldMapper.class);
    static final String ID_FIELD_DATA_DEPRECATION_MESSAGE = "Loading the fielddata on the _id field is deprecated and will be removed in future versions. If you require sorting or aggregating on this field you should also include the id in the body of your documents, and map this field as a keyword field that has [doc_values] enabled";
    public static final String CONTENT_TYPE = ParseField.CommonMetaFields.ID_FIELD.getPreferredName();
    public static final MetadataFieldMapper.TypeParser PARSER = new MetadataFieldMapper.FixedTypeParser(c -> new IdFieldMapper(c.isIdFieldDataEnabled()));

    private static LeafFieldData wrap(final LeafFieldData in) {
        return new LeafFieldData(){

            public void close() {
                in.close();
            }

            public long ramBytesUsed() {
                return in.ramBytesUsed();
            }

            @Override
            public ScriptDocValues<?> getScriptValues() {
                return new ScriptDocValues.Strings(this.getBytesValues());
            }

            @Override
            public SortedBinaryDocValues getBytesValues() {
                final SortedBinaryDocValues inValues = in.getBytesValues();
                return new SortedBinaryDocValues(this){

                    @Override
                    public BytesRef nextValue() throws IOException {
                        BytesRef encoded = inValues.nextValue();
                        return new BytesRef((CharSequence)Uid.decodeId(Arrays.copyOfRange(encoded.bytes, encoded.offset, encoded.offset + encoded.length)));
                    }

                    @Override
                    public int docValueCount() {
                        int count = inValues.docValueCount();
                        assert (count == 1);
                        return inValues.docValueCount();
                    }

                    @Override
                    public boolean advanceExact(int doc) throws IOException {
                        return inValues.advanceExact(doc);
                    }
                };
            }
        };
    }

    private IdFieldMapper(BooleanSupplier fieldDataEnabled) {
        super(new IdFieldType(fieldDataEnabled), Lucene.KEYWORD_ANALYZER);
    }

    @Override
    public void preParse(ParseContext context) {
        context.doc().add((IndexableField)IdFieldMapper.idField(context.sourceToParse().id()));
    }

    public static Field idField(String id) {
        return MetadataFieldsUtil.idField(id);
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    static final class IdFieldType
    extends TermBasedFieldType {
        private final BooleanSupplier fieldDataEnabled;

        IdFieldType(BooleanSupplier fieldDataEnabled) {
            super(ParseField.CommonMetaFields.ID_FIELD.getPreferredName(), true, true, false, TextSearchInfo.SIMPLE_MATCH_ONLY, Collections.emptyMap());
            this.fieldDataEnabled = fieldDataEnabled;
        }

        @Override
        public String typeName() {
            return CONTENT_TYPE;
        }

        @Override
        public boolean isSearchable() {
            return true;
        }

        @Override
        public ValueFetcher valueFetcher(QueryShardContext context, SearchLookup lookup, String format) {
            throw new UnsupportedOperationException("Cannot fetch values for internal field [" + this.name() + "].");
        }

        @Override
        public Query termQuery(Object value, QueryShardContext context) {
            return this.termsQuery(Arrays.asList(value), context);
        }

        @Override
        public Query existsQuery(QueryShardContext context) {
            return new MatchAllDocsQuery();
        }

        @Override
        public Query termsQuery(List<?> values, QueryShardContext context) {
            this.failIfNotIndexed();
            List<BytesRef> bytesRefs = values.stream().map(v -> {
                Object idObject = v;
                if (idObject instanceof BytesRef) {
                    idObject = ((BytesRef)idObject).utf8ToString();
                }
                return Uid.encodeId(idObject.toString());
            }).toList();
            return new TermInSetQuery(this.name(), bytesRefs);
        }

        @Override
        public BaseIndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName, Supplier<SearchLookup> searchLookup) {
            if (!this.fieldDataEnabled.getAsBoolean()) {
                throw new IllegalArgumentException("Fielddata access on the _id field is disallowed, you can re-enable it by updating the dynamic cluster setting: " + IndicesServiceSettings.INDICES_ID_FIELD_DATA_ENABLED_SETTING.getKey());
            }
            final PagedBytesIndexFieldData.Builder fieldDataBuilder = new PagedBytesIndexFieldData.Builder(this.name(), 0.0, 2.147483647E9, 0, CoreValuesSourceType.BYTES);
            return new BaseIndexFieldData.Builder(){

                public IndexFieldData<?> build(IndexFieldDataCache cache, CircuitBreakerService breakerService) {
                    deprecationLogger.deprecate("id_field_data", IdFieldMapper.ID_FIELD_DATA_DEPRECATION_MESSAGE, new Object[0]);
                    final IndexFieldData fieldData = (IndexFieldData)fieldDataBuilder.build(cache, breakerService);
                    return new IndexFieldData<LeafFieldData>(this){

                        @Override
                        public String getFieldName() {
                            return fieldData.getFieldName();
                        }

                        @Override
                        public ValuesSourceType getValuesSourceType() {
                            return fieldData.getValuesSourceType();
                        }

                        @Override
                        public LeafFieldData load(LeafReaderContext context) {
                            return IdFieldMapper.wrap(fieldData.load(context));
                        }

                        @Override
                        public LeafFieldData loadDirect(LeafReaderContext context) throws Exception {
                            return IdFieldMapper.wrap(fieldData.loadDirect(context));
                        }

                        @Override
                        public SortField sortField(Object missingValue, MultiValueMode sortMode, IndexFieldDataFieldComparatorSource.Nested nested, boolean reverse) {
                            BytesRefFieldComparatorSource source = new BytesRefFieldComparatorSource(this, missingValue, sortMode, nested);
                            return new SortField(this.getFieldName(), (FieldComparatorSource)source, reverse);
                        }

                        @Override
                        public BucketedSort newBucketedSort(BigArrays bigArrays, Object missingValue, MultiValueMode sortMode, IndexFieldDataFieldComparatorSource.Nested nested, SortOrder sortOrder, DocValueFormat format, int bucketSize, BucketedSort.ExtraData extra) {
                            throw new UnsupportedOperationException("can't sort on the [" + CONTENT_TYPE + "] field");
                        }

                        @Override
                        public BaseIndexFieldData.Global<LeafFieldData> loadGlobal(DirectoryReader indexReader) {
                            return fieldData.loadGlobal(indexReader);
                        }

                        @Override
                        public BaseIndexFieldData.Global<LeafFieldData> loadGlobalDirect(DirectoryReader indexReader) throws Exception {
                            return fieldData.loadGlobalDirect(indexReader);
                        }
                    };
                }
            };
        }
    }

    public static class Defaults {
        public static final String NAME = ParseField.CommonMetaFields.ID_FIELD.getPreferredName();
        public static final FieldType FIELD_TYPE = MetadataFieldsUtil.DEFAULT_ID_FIELD_TYPE;
        public static final FieldType NESTED_FIELD_TYPE = new FieldType();

        static {
            NESTED_FIELD_TYPE.setTokenized(false);
            NESTED_FIELD_TYPE.setIndexOptions(IndexOptions.DOCS);
            NESTED_FIELD_TYPE.setStored(true);
            NESTED_FIELD_TYPE.setOmitNorms(true);
            NESTED_FIELD_TYPE.setStored(false);
            NESTED_FIELD_TYPE.freeze();
        }
    }
}

