/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.mapper;

import io.skylite.core.aggregations.values.CoreValuesSourceType;
import io.skylite.core.common.Strings;
import io.skylite.core.index.fielddata.BaseIndexFieldData;
import io.skylite.core.index.fielddata.plain.ConstantIndexFieldData;
import io.skylite.core.index.query.QueryShardContext;
import io.skylite.core.mapper.ConstantFieldType;
import io.skylite.core.mapper.MetadataFieldMapper;
import io.skylite.core.mapper.ValueFetcher;
import io.skylite.core.search.lookup.SearchLookup;
import java.util.Collections;
import java.util.function.Supplier;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;

public class IndexFieldMapper
extends MetadataFieldMapper {
    public static final String NAME = "_index";
    public static final String CONTENT_TYPE = "_index";
    public static final MetadataFieldMapper.TypeParser PARSER = new MetadataFieldMapper.FixedTypeParser(c -> new IndexFieldMapper());

    public IndexFieldMapper() {
        super(IndexFieldType.INSTANCE);
    }

    @Override
    protected String contentType() {
        return "_index";
    }

    static final class IndexFieldType
    extends ConstantFieldType {
        static final IndexFieldType INSTANCE = new IndexFieldType();

        private IndexFieldType() {
            super("_index", Collections.emptyMap());
        }

        @Override
        public String typeName() {
            return "_index";
        }

        @Override
        protected boolean matches(String pattern, boolean caseInsensitive, QueryShardContext context) {
            if (caseInsensitive) {
                pattern = Strings.toLowercaseAscii(pattern);
            }
            return context.indexMatches(pattern);
        }

        @Override
        public Query existsQuery(QueryShardContext context) {
            return new MatchAllDocsQuery();
        }

        @Override
        public BaseIndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName, Supplier<SearchLookup> searchLookup) {
            return new ConstantIndexFieldData.Builder(fullyQualifiedIndexName, this.name(), CoreValuesSourceType.BYTES);
        }

        @Override
        public ValueFetcher valueFetcher(QueryShardContext context, SearchLookup searchLookup, String format) {
            throw new UnsupportedOperationException("Cannot fetch values for internal field [" + this.name() + "].");
        }
    }
}

