/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.mapper;

import io.skylite.common.Nullable;
import io.skylite.core.common.time.DateMathParser;
import io.skylite.core.common.unit.Fuzziness;
import io.skylite.core.geo.ShapeRelation;
import io.skylite.core.index.fielddata.BaseIndexFieldData;
import io.skylite.core.index.query.QueryShardContext;
import io.skylite.core.index.query.QueryShardException;
import io.skylite.core.mapper.BaseMappedFieldType;
import io.skylite.core.mapper.FieldNamesFieldMapper;
import io.skylite.core.mapper.TextSearchInfo;
import io.skylite.core.mapper.ValueFetcher;
import io.skylite.core.search.lookup.SearchLookup;
import java.io.IOException;
import java.time.ZoneId;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.spans.SpanMultiTermQueryWrapper;
import org.apache.lucene.queries.spans.SpanQuery;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.FieldExistsQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

public abstract class MappedFieldType
extends BaseMappedFieldType {
    public static final String DISTANCE_FEATURE_QUERY_NAME = "distance_feature";

    public MappedFieldType(String name, boolean isIndexed, boolean isStored, boolean hasDocValues, TextSearchInfo textSearchInfo, Map<String, String> meta) {
        super(name, hasDocValues, isIndexed, isStored, meta, textSearchInfo);
    }

    public BaseIndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName, Supplier<SearchLookup> searchLookup) {
        throw new IllegalArgumentException("Fielddata is not supported on field [" + this.name() + "] of type [" + this.typeName() + "]");
    }

    public abstract ValueFetcher valueFetcher(QueryShardContext var1, SearchLookup var2, @Nullable String var3);

    public boolean isAggregatable() {
        try {
            this.fielddataBuilder("", () -> {
                throw new UnsupportedOperationException("SearchLookup not available");
            });
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public abstract Query termQuery(Object var1, @Nullable QueryShardContext var2);

    public Query termQueryCaseInsensitive(Object value, @Nullable QueryShardContext context) {
        throw new QueryShardException(context.getFullyQualifiedIndex(), "[" + this.name + "] field which is of type [" + this.typeName() + "], does not support case insensitive term queries", new Object[0]);
    }

    public Query termsQuery(List<?> values, @Nullable QueryShardContext context) {
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        for (Object value : values) {
            builder.add(this.termQuery(value, context), BooleanClause.Occur.SHOULD);
        }
        return new ConstantScoreQuery((Query)builder.build());
    }

    public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, ShapeRelation relation, ZoneId timeZone, DateMathParser parser, QueryShardContext context) {
        throw new IllegalArgumentException("Field [" + this.name + "] of type [" + this.typeName() + "] does not support range queries");
    }

    public Query fuzzyQuery(Object value, Fuzziness fuzziness, int prefixLength, int maxExpansions, boolean transpositions, QueryShardContext context, @Nullable MultiTermQuery.RewriteMethod rewriteMethod) {
        throw new IllegalArgumentException("Can only use fuzzy queries on keyword and text fields - not on [" + this.name + "] which is of type [" + this.typeName() + "]");
    }

    public Query fuzzyQuery(Object value, Fuzziness fuzziness, int prefixLength, int maxExpansions, boolean transpositions, QueryShardContext context) {
        return this.fuzzyQuery(value, fuzziness, prefixLength, maxExpansions, transpositions, context, null);
    }

    public final Query prefixQuery(String value, @Nullable MultiTermQuery.RewriteMethod method, QueryShardContext context) {
        return this.prefixQuery(value, method, false, context);
    }

    public Query prefixQuery(String value, @Nullable MultiTermQuery.RewriteMethod method, boolean caseInsensitve, QueryShardContext context) {
        throw new QueryShardException(context.getFullyQualifiedIndex(), "Can only use prefix queries on keyword and text fields - not on [" + this.name + "] which is of type [" + this.typeName() + "]", new Object[0]);
    }

    public final Query wildcardQuery(String value, @Nullable MultiTermQuery.RewriteMethod method, QueryShardContext context) {
        return this.wildcardQuery(value, method, false, context);
    }

    public Query wildcardQuery(String value, @Nullable MultiTermQuery.RewriteMethod method, boolean caseInsensitve, QueryShardContext context) {
        throw new QueryShardException(context.getFullyQualifiedIndex(), "Can only use wildcard queries on keyword and text fields - not on [" + this.name + "] which is of type [" + this.typeName() + "]", new Object[0]);
    }

    public Query normalizedWildcardQuery(String value, @Nullable MultiTermQuery.RewriteMethod method, QueryShardContext context) {
        throw new QueryShardException(context.getFullyQualifiedIndex(), "Can only use wildcard queries on keyword and text fields - not on [" + this.name + "] which is of type [" + this.typeName() + "]", new Object[0]);
    }

    public Query regexpQuery(String value, int syntaxFlags, int matchFlags, int maxDeterminizedStates, @Nullable MultiTermQuery.RewriteMethod method, QueryShardContext context) {
        throw new QueryShardException(context.getFullyQualifiedIndex(), "Can only use regexp queries on keyword and text fields - not on [" + this.name + "] which is of type [" + this.typeName() + "]", new Object[0]);
    }

    public Query existsQuery(QueryShardContext context) {
        if (this.hasDocValues() || this.getTextSearchInfo().hasNorms()) {
            return new FieldExistsQuery(this.name());
        }
        return new TermQuery(new Term(FieldNamesFieldMapper.NAME, this.name()));
    }

    public Query phraseQuery(TokenStream stream, int slop, boolean enablePositionIncrements) throws IOException {
        throw new IllegalArgumentException("Can only use phrase queries on text fields - not on [" + this.name + "] which is of type [" + this.typeName() + "]");
    }

    public Query multiPhraseQuery(TokenStream stream, int slop, boolean enablePositionIncrements) throws IOException {
        throw new IllegalArgumentException("Can only use phrase queries on text fields - not on [" + this.name + "] which is of type [" + this.typeName() + "]");
    }

    public Query phrasePrefixQuery(TokenStream stream, int slop, int maxExpansions) throws IOException {
        throw new IllegalArgumentException("Can only use phrase prefix queries on text fields - not on [" + this.name + "] which is of type [" + this.typeName() + "]");
    }

    public SpanQuery spanPrefixQuery(String value, SpanMultiTermQueryWrapper.SpanRewriteMethod method, QueryShardContext context) {
        throw new IllegalArgumentException("Can only use span prefix queries on text fields - not on [" + this.name + "] which is of type [" + this.typeName() + "]");
    }

    public Query distanceFeatureQuery(Object origin, String pivot, float boost, QueryShardContext context) {
        throw new IllegalArgumentException("Illegal data type of [" + this.typeName() + "]![distance_feature] query can only be run on a date, date_nanos or geo_point field type!");
    }
}

