/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.mapper;

import io.skylite.core.mapper.DynamicRuntimeFieldsBuilder;
import io.skylite.core.mapper.Mapper;
import io.skylite.core.mapper.MetadataFieldMapper;
import io.skylite.core.mapper.RuntimeFieldType;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;

public final class MapperRegistry {
    private final Map<String, Mapper.TypeParser> mapperParsers;
    private final Map<String, RuntimeFieldType.Parser> runtimeFieldTypeParsers;
    private final DynamicRuntimeFieldsBuilder dynamicRuntimeFieldsBuilder;
    private final Map<String, MetadataFieldMapper.TypeParser> metadataMapperParsers;
    private final Function<String, Predicate<String>> fieldFilter;

    public MapperRegistry(Map<String, Mapper.TypeParser> mapperParsers, Map<String, RuntimeFieldType.Parser> runtimeFieldTypeParsers, DynamicRuntimeFieldsBuilder dynamicRuntimeFieldsBuilder, Map<String, MetadataFieldMapper.TypeParser> metadataMapperParsers, Function<String, Predicate<String>> fieldFilter) {
        this.mapperParsers = Collections.unmodifiableMap(new LinkedHashMap<String, Mapper.TypeParser>(mapperParsers));
        this.runtimeFieldTypeParsers = runtimeFieldTypeParsers;
        this.dynamicRuntimeFieldsBuilder = dynamicRuntimeFieldsBuilder;
        this.metadataMapperParsers = Collections.unmodifiableMap(new LinkedHashMap<String, MetadataFieldMapper.TypeParser>(metadataMapperParsers));
        this.fieldFilter = fieldFilter;
    }

    public Map<String, RuntimeFieldType.Parser> getRuntimeFieldTypeParsers() {
        return this.runtimeFieldTypeParsers;
    }

    public Map<String, Mapper.TypeParser> getMapperParsers() {
        return this.mapperParsers;
    }

    public DynamicRuntimeFieldsBuilder getDynamicRuntimeFieldsBuilder() {
        return this.dynamicRuntimeFieldsBuilder;
    }

    public Map<String, MetadataFieldMapper.TypeParser> getMetadataMapperParsers() {
        return this.metadataMapperParsers;
    }

    public boolean isMetadataField(String field) {
        return this.getMetadataMapperParsers().containsKey(field);
    }

    public Function<String, Predicate<String>> getFieldFilter() {
        return this.fieldFilter;
    }
}

