/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.mapper;

import io.skylite.core.mapper.ContentPath;
import io.skylite.core.mapper.FieldAliasMapper;
import io.skylite.core.mapper.FieldMapper;
import io.skylite.core.mapper.Mapper;
import io.skylite.core.mapper.MappingLookup;
import io.skylite.core.mapper.MergeReason;
import io.skylite.core.mapper.MetadataFieldMapper;
import io.skylite.core.mapper.ObjectMapper;
import io.skylite.core.mapper.RootObjectMapper;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentFragment;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentHelper;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public final class Mapping
implements ToXContentFragment {
    public static final Mapping EMPTY = new Mapping(new RootObjectMapper.Builder("_doc").build(new ContentPath()), new MetadataFieldMapper[0], Collections.emptyMap());
    private final RootObjectMapper root;
    private final MetadataFieldMapper[] metadataMappers;
    private final Map<Class<? extends MetadataFieldMapper>, MetadataFieldMapper> metadataMappersMap;
    private final Map<String, MetadataFieldMapper> metadataMappersByName;
    private final Map<String, Object> meta;

    public Mapping(RootObjectMapper rootObjectMapper, MetadataFieldMapper[] metadataMappers, Map<String, Object> meta) {
        this.metadataMappers = metadataMappers;
        HashMap metadataMappersMap = new HashMap();
        HashMap<String, MetadataFieldMapper> metadataMappersByName = new HashMap<String, MetadataFieldMapper>();
        for (MetadataFieldMapper metadataMapper : metadataMappers) {
            metadataMappersMap.put(metadataMapper.getClass(), metadataMapper);
            metadataMappersByName.put(metadataMapper.name(), metadataMapper);
        }
        this.root = rootObjectMapper;
        Arrays.sort(metadataMappers, new Comparator<Mapper>(this){

            @Override
            public int compare(Mapper o1, Mapper o2) {
                return o1.name().compareTo(o2.name());
            }
        });
        this.metadataMappersMap = Collections.unmodifiableMap(metadataMappersMap);
        this.metadataMappersByName = Collections.unmodifiableMap(metadataMappersByName);
        this.meta = meta;
    }

    public static MappingLookup fromMapping(Mapping mapping) {
        ArrayList<ObjectMapper> newObjectMappers = new ArrayList<ObjectMapper>();
        ArrayList<FieldMapper> newFieldMappers = new ArrayList<FieldMapper>();
        ArrayList<FieldAliasMapper> newFieldAliasMappers = new ArrayList<FieldAliasMapper>();
        for (MetadataFieldMapper metadataMapper : mapping.metadataMappers) {
            if (metadataMapper == null) continue;
            newFieldMappers.add(metadataMapper);
        }
        Mapping.collect(mapping.root, newObjectMappers, newFieldMappers, newFieldAliasMappers);
        return new MappingLookup(mapping, newFieldMappers, newObjectMappers, newFieldAliasMappers);
    }

    private static void collect(Mapper mapper, Collection<ObjectMapper> objectMappers, Collection<FieldMapper> fieldMappers, Collection<FieldAliasMapper> fieldAliasMappers) {
        if (!(mapper instanceof RootObjectMapper)) {
            if (mapper instanceof ObjectMapper) {
                objectMappers.add((ObjectMapper)mapper);
            } else if (mapper instanceof FieldMapper) {
                fieldMappers.add((FieldMapper)mapper);
            } else if (mapper instanceof FieldAliasMapper) {
                fieldAliasMappers.add((FieldAliasMapper)mapper);
            } else {
                throw new IllegalStateException("Unrecognized mapper type [" + mapper.getClass().getSimpleName() + "].");
            }
        }
        for (Mapper child : mapper) {
            Mapping.collect(child, objectMappers, fieldMappers, fieldAliasMappers);
        }
    }

    public RootObjectMapper getRoot() {
        return this.root;
    }

    public Map<String, Object> getMeta() {
        return this.meta;
    }

    MetadataFieldMapper[] getSortedMetadataMappers() {
        return this.metadataMappers;
    }

    Map<Class<? extends MetadataFieldMapper>, MetadataFieldMapper> getMetadataMappersMap() {
        return this.metadataMappersMap;
    }

    public <T extends MetadataFieldMapper> T getMetadataMapperByClass(Class<T> clazz) {
        return (T)this.metadataMappersMap.get(clazz);
    }

    MetadataFieldMapper getMetadataMapperByName(String mapperName) {
        return this.metadataMappersByName.get(mapperName);
    }

    public void validate(MappingLookup mappers) {
        for (MetadataFieldMapper metadataFieldMapper : this.metadataMappers) {
            metadataFieldMapper.validate(mappers);
        }
        this.root.validate(mappers);
    }

    public Mapping mappingUpdate(RootObjectMapper rootObjectMapper) {
        return new Mapping(rootObjectMapper, this.metadataMappers, this.meta);
    }

    public Mapping merge(Mapping mergeWith, MergeReason reason) {
        Map<String, Object> mergedMeta;
        RootObjectMapper mergedRoot = this.root.merge(mergeWith.root, reason);
        HashMap<Class<? extends MetadataFieldMapper>, MetadataFieldMapper> mergedMetadataMappers = new HashMap<Class<? extends MetadataFieldMapper>, MetadataFieldMapper>(this.metadataMappersMap);
        for (MetadataFieldMapper metaMergeWith : mergeWith.metadataMappers) {
            MetadataFieldMapper mergeInto = (MetadataFieldMapper)mergedMetadataMappers.get(metaMergeWith.getClass());
            MetadataFieldMapper merged = mergeInto == null || reason == MergeReason.INDEX_TEMPLATE ? metaMergeWith : (MetadataFieldMapper)mergeInto.merge(metaMergeWith);
            mergedMetadataMappers.put(merged.getClass(), merged);
        }
        if (mergeWith.meta == null) {
            mergedMeta = this.meta;
        } else if (this.meta == null || reason != MergeReason.INDEX_TEMPLATE) {
            mergedMeta = mergeWith.meta;
        } else {
            mergedMeta = new HashMap<String, Object>(mergeWith.meta);
            XContentHelper.mergeDefaults(mergedMeta, this.meta);
        }
        return new Mapping(mergedRoot, mergedMetadataMappers.values().toArray(new MetadataFieldMapper[0]), mergedMeta);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        this.root.toXContent(builder, params, (builder1, params1) -> {
            if (this.meta != null) {
                builder1.field("_meta", this.meta);
            }
            for (MetadataFieldMapper mapper : this.metadataMappers) {
                mapper.toXContent(builder1, params1);
            }
            return builder1;
        });
        return builder;
    }

    public String toString() {
        try {
            XContentBuilder builder = MediaTypeRegistry.JSON.contentBuilder().startObject();
            this.toXContent(builder, new ToXContent.MapParams(Collections.emptyMap()));
            return builder.endObject().toString();
        }
        catch (IOException bogus) {
            throw new UncheckedIOException(bogus);
        }
    }
}

