/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.mapper;

import io.skylite.core.ParseField;
import io.skylite.core.analysis.NamedAnalyzer;
import io.skylite.core.index.IndexSettings;
import io.skylite.core.mapper.BaseMappedFieldType;
import io.skylite.core.mapper.DateFieldMapper;
import io.skylite.core.mapper.FieldAliasMapper;
import io.skylite.core.mapper.FieldMapper;
import io.skylite.core.mapper.FieldTypeLookup;
import io.skylite.core.mapper.MappedFieldType;
import io.skylite.core.mapper.Mapper;
import io.skylite.core.mapper.MapperParsingException;
import io.skylite.core.mapper.Mapping;
import io.skylite.core.mapper.ObjectMapper;
import io.skylite.core.mapper.SourceFieldMapper;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;

public final class MappingLookup {
    public static final MappingLookup EMPTY = new MappingLookup(Mapping.EMPTY, List.of(), List.of(), List.of());
    private final CacheKey cacheKey = new CacheKey();
    private final Map<String, Mapper> fieldMappers;
    private final Map<String, ObjectMapper> objectMappers;
    private final boolean hasNested;
    private final FieldTypeLookup fieldTypeLookup;
    private final Map<String, NamedAnalyzer> indexAnalyzersMap = new HashMap<String, NamedAnalyzer>();
    private final Mapping mapping;

    public MappingLookup(Mapping mapping, Collection<FieldMapper> mappers, Collection<ObjectMapper> objectMappers, Collection<FieldAliasMapper> aliasMappers) {
        this.mapping = mapping;
        HashMap<String, Mapper> fieldMappers = new HashMap<String, Mapper>();
        HashMap<String, ObjectMapper> objects = new HashMap<String, ObjectMapper>();
        boolean hasNested = false;
        for (ObjectMapper objectMapper : objectMappers) {
            if (objects.put(objectMapper.fullPath(), objectMapper) != null) {
                throw new MapperParsingException("Object mapper [" + objectMapper.fullPath() + "] is defined more than once");
            }
            if (!objectMapper.isNested()) continue;
            hasNested = true;
        }
        this.hasNested = hasNested;
        for (FieldMapper fieldMapper : mappers) {
            if (objects.containsKey(fieldMapper.name())) {
                throw new MapperParsingException("Field [" + fieldMapper.name() + "] is defined both as an object and a field");
            }
            if (fieldMappers.put(fieldMapper.name(), fieldMapper) != null) {
                throw new MapperParsingException("Field [" + fieldMapper.name() + "] is defined more than once");
            }
            this.indexAnalyzersMap.putAll(fieldMapper.indexAnalyzers());
        }
        for (FieldAliasMapper fieldAliasMapper : aliasMappers) {
            if (objects.containsKey(fieldAliasMapper.name())) {
                throw new MapperParsingException("Alias [" + fieldAliasMapper.name() + "] is defined both as an object and an alias");
            }
            if (fieldMappers.put(fieldAliasMapper.name(), fieldAliasMapper) == null) continue;
            throw new MapperParsingException("Alias [" + fieldAliasMapper.name() + "] is defined both as an alias and a concrete field");
        }
        this.fieldTypeLookup = new FieldTypeLookup(mappers, aliasMappers, mapping.getRoot().runtimeFieldTypes());
        this.fieldMappers = Collections.unmodifiableMap(fieldMappers);
        this.objectMappers = Collections.unmodifiableMap(objects);
    }

    public Mapper getMapper(String field) {
        return this.fieldMappers.get(field);
    }

    public FieldTypeLookup fieldTypesLookup() {
        return this.fieldTypeLookup;
    }

    public BaseMappedFieldType fieldTypeLookup(String field) {
        return this.fieldTypeLookup.get(field);
    }

    public NamedAnalyzer indexAnalyzer(String field, Function<String, NamedAnalyzer> unmappedFieldAnalyzer) {
        if (this.indexAnalyzersMap.containsKey(field)) {
            return this.indexAnalyzersMap.get(field);
        }
        return unmappedFieldAnalyzer.apply(field);
    }

    public Iterable<Mapper> fieldMappers() {
        return this.fieldMappers.values();
    }

    void checkLimits(IndexSettings settings) {
        this.checkFieldLimit(settings.getMappingTotalFieldsLimit());
        this.checkObjectDepthLimit(settings.getMappingDepthLimit());
        this.checkFieldNameLengthLimit(settings.getMappingFieldNameLengthLimit());
        this.checkNestedLimit(settings.getMappingNestedFieldsLimit());
    }

    private void checkFieldLimit(long limit) {
        this.checkFieldLimit(limit, 0);
    }

    void checkFieldLimit(long limit, int additionalFieldsToAdd) {
        if ((long)(this.fieldMappers.size() + this.objectMappers.size() + additionalFieldsToAdd - this.mapping.getSortedMetadataMappers().length) > limit) {
            throw new IllegalArgumentException("Limit of total fields [" + limit + "] has been exceeded" + (String)(additionalFieldsToAdd > 0 ? " while adding new fields [" + additionalFieldsToAdd + "]" : ""));
        }
    }

    private void checkObjectDepthLimit(long limit) {
        for (String objectPath : this.objectMappers.keySet()) {
            int numDots = 0;
            for (int i = 0; i < objectPath.length(); ++i) {
                if (objectPath.charAt(i) != '.') continue;
                ++numDots;
            }
            int depth = numDots + 2;
            if ((long)depth <= limit) continue;
            throw new IllegalArgumentException("Limit of mapping depth [" + limit + "] has been exceeded due to object field [" + objectPath + "]");
        }
    }

    private void checkFieldNameLengthLimit(long limit) {
        Stream.of(this.objectMappers.values().stream(), this.fieldMappers.values().stream()).reduce(Stream::concat).orElseGet(Stream::empty).forEach(mapper -> {
            String name = mapper.simpleName();
            if ((long)name.length() > limit) {
                throw new IllegalArgumentException("Field name [" + name + "] is longer than the limit of [" + limit + "] characters");
            }
        });
    }

    private void checkNestedLimit(long limit) {
        long actualNestedFields = 0L;
        for (ObjectMapper objectMapper : this.objectMappers.values()) {
            if (!objectMapper.isNested()) continue;
            ++actualNestedFields;
        }
        if (actualNestedFields > limit) {
            throw new IllegalArgumentException("Limit of nested fields [" + limit + "] has been exceeded");
        }
    }

    public boolean hasNested() {
        return this.hasNested;
    }

    public Map<String, ObjectMapper> objectMappers() {
        return this.objectMappers;
    }

    public boolean isMultiField(String field) {
        String sourceParent = MappingLookup.parentObject(field);
        return sourceParent != null && this.fieldMappers.containsKey(sourceParent);
    }

    public boolean isObjectField(String field) {
        return this.objectMappers.containsKey(field);
    }

    public String getNestedScope(String path) {
        String parentPath = MappingLookup.parentObject(path);
        while (parentPath != null) {
            ObjectMapper objectMapper = this.objectMappers.get(parentPath);
            if (objectMapper != null && objectMapper.isNested()) {
                return parentPath;
            }
            parentPath = MappingLookup.parentObject(parentPath);
        }
        return null;
    }

    public boolean containsTimeStampField() {
        MappedFieldType timeSeriesFieldType = this.fieldTypeLookup.get(ParseField.CommonFields.TIMESTAMP.getPreferredName());
        return timeSeriesFieldType != null && timeSeriesFieldType instanceof DateFieldMapper.DateFieldType;
    }

    private static String parentObject(String field) {
        int lastDot = field.lastIndexOf(46);
        if (lastDot == -1) {
            return null;
        }
        return field.substring(0, lastDot);
    }

    public Set<String> simpleMatchToFullName(String pattern) {
        return this.fieldTypesLookup().simpleMatchToFullName(pattern);
    }

    public MappedFieldType getFieldType(String field) {
        return this.fieldTypesLookup().get(field);
    }

    public Set<String> sourcePaths(String field) {
        return this.fieldTypesLookup().sourcePaths(field);
    }

    public boolean hasMappings() {
        return this != EMPTY;
    }

    public boolean isSourceEnabled() {
        return this.mapping.getMetadataMapperByClass(SourceFieldMapper.class).enabled();
    }

    public CacheKey cacheKey() {
        return this.cacheKey;
    }

    public Mapping getMapping() {
        return this.mapping;
    }

    public static class CacheKey {
        private CacheKey() {
        }
    }
}

