/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.mapper;

import io.skylite.common.Nullable;
import io.skylite.core.compress.CompressedXContent;
import io.skylite.core.mapper.ContentPath;
import io.skylite.core.mapper.MapperParsingException;
import io.skylite.core.mapper.Mapping;
import io.skylite.core.mapper.MappingParserContext;
import io.skylite.core.mapper.MetadataFieldMapper;
import io.skylite.core.mapper.RootObjectMapper;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.XContentHelper;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;

public class MappingParser {
    private final Supplier<MappingParserContext> parserContextSupplier;
    private final RootObjectMapper.TypeParser rootObjectTypeParser = new RootObjectMapper.TypeParser();
    private final Supplier<Map<Class<? extends MetadataFieldMapper>, MetadataFieldMapper>> metadataMappersSupplier;
    private final Map<String, MetadataFieldMapper.TypeParser> metadataMapperParsers;
    private final Function<String, String> documentTypeResolver;

    MappingParser(Supplier<MappingParserContext> parserContextSupplier, Map<String, MetadataFieldMapper.TypeParser> metadataMapperParsers, Supplier<Map<Class<? extends MetadataFieldMapper>, MetadataFieldMapper>> metadataMappersSupplier, Function<String, String> documentTypeResolver) {
        this.parserContextSupplier = parserContextSupplier;
        this.metadataMapperParsers = metadataMapperParsers;
        this.metadataMappersSupplier = metadataMappersSupplier;
        this.documentTypeResolver = documentTypeResolver;
    }

    public Mapping parse(@Nullable String type, CompressedXContent source) throws MapperParsingException {
        Map<String, Object> mapping = null;
        if (source != null) {
            mapping = (HashMap<String, Object>)XContentHelper.convertToMap(source.compressedReference(), true, MediaTypeRegistry.JSON).v2();
            if (mapping.isEmpty()) {
                if (type == null) {
                    throw new MapperParsingException("malformed mapping, no type name found");
                }
            } else {
                String rootName = (String)mapping.keySet().iterator().next();
                if (type == null || type.equals(rootName) || this.documentTypeResolver.apply(type).equals(rootName)) {
                    type = rootName;
                    mapping = (Map)mapping.get(rootName);
                }
            }
        }
        if (type == null) {
            throw new MapperParsingException("Failed to derive type");
        }
        if (mapping == null) {
            mapping = new HashMap<String, Object>();
        }
        return this.parse(type, mapping);
    }

    private Mapping parse(String type, Map<String, Object> mapping) throws MapperParsingException {
        ContentPath contentPath = new ContentPath(1);
        MappingParserContext parserContext = this.parserContextSupplier.get();
        RootObjectMapper rootObjectMapper = ((RootObjectMapper.Builder)this.rootObjectTypeParser.parse(type, (Map)mapping, parserContext)).build(contentPath);
        Map<Class<? extends MetadataFieldMapper>, MetadataFieldMapper> metadataMappers = this.metadataMappersSupplier.get();
        Map<String, Object> meta = null;
        Iterator<Map.Entry<String, Object>> iterator = mapping.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> entry = iterator.next();
            String fieldName = entry.getKey();
            Object fieldNode = entry.getValue();
            MetadataFieldMapper.TypeParser typeParser = this.metadataMapperParsers.get(fieldName);
            if (typeParser == null) continue;
            iterator.remove();
            if (!(fieldNode instanceof Map)) {
                throw new IllegalArgumentException("[_parent] must be an object containing [type]");
            }
            Map fieldNodeMap = (Map)fieldNode;
            MetadataFieldMapper metadataFieldMapper = ((MetadataFieldMapper.Builder)typeParser.parse(fieldName, fieldNodeMap, parserContext)).build(contentPath);
            metadataMappers.put(metadataFieldMapper.getClass(), metadataFieldMapper);
            fieldNodeMap.remove("type");
            MappingParser.checkNoRemainingFields(fieldName, fieldNodeMap);
        }
        Map removed = (Map)mapping.remove("_meta");
        if (removed != null) {
            meta = Collections.unmodifiableMap(new HashMap(removed));
        }
        MappingParser.checkNoRemainingFields(mapping, "Root mapping definition has unsupported parameters: ");
        return new Mapping(rootObjectMapper, metadataMappers.values().toArray(new MetadataFieldMapper[0]), meta);
    }

    public static void checkNoRemainingFields(String fieldName, Map<?, ?> fieldNodeMap) {
        MappingParser.checkNoRemainingFields(fieldNodeMap, "Mapping definition for [" + fieldName + "] has unsupported parameters: ");
    }

    public static void checkNoRemainingFields(Map<?, ?> fieldNodeMap, String message) {
        if (!fieldNodeMap.isEmpty()) {
            throw new MapperParsingException(message + MappingParser.getRemainingFields(fieldNodeMap));
        }
    }

    private static String getRemainingFields(Map<?, ?> map) {
        StringBuilder remainingFields = new StringBuilder();
        for (Object key : map.keySet()) {
            remainingFields.append(" [").append(key).append(" : ").append(map.get(key)).append("]");
        }
        return remainingFields.toString();
    }
}

