/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.mapper;

import io.skylite.OpenSearchVersion;
import io.skylite.Version;
import io.skylite.common.Explicit;
import io.skylite.core.mapper.ContentPath;
import io.skylite.core.mapper.Mapper;
import io.skylite.core.mapper.MapperException;
import io.skylite.core.mapper.MapperParsingException;
import io.skylite.core.mapper.MappingParserContext;
import io.skylite.core.mapper.MergeReason;
import io.skylite.core.mapper.NestedPathFieldMapper;
import io.skylite.core.mapper.ObjectMapper;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.util.XContentMapValuesUtil;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.apache.lucene.search.Query;

public class NestedObjectMapper
extends ObjectMapper {
    public static final String CONTENT_TYPE = "nested";
    private Explicit<Boolean> includeInRoot;
    private Explicit<Boolean> includeInParent;
    private final String nestedTypePath;
    private final Query nestedTypeFilter;

    NestedObjectMapper(String name, String fullPath, Map<String, Mapper> mappers, Builder builder) {
        super(name, fullPath, (Explicit<Boolean>)builder.enabled, builder.dynamic, mappers);
        this.nestedTypePath = builder.indexCreatedVersion.before(OpenSearchVersion.V_2_0_0) ? "__" + fullPath : fullPath;
        this.nestedTypeFilter = NestedPathFieldMapper.filter(builder.indexCreatedVersion, this.nestedTypePath);
        this.includeInParent = builder.includeInParent;
        this.includeInRoot = builder.includeInRoot;
    }

    public Query nestedTypeFilter() {
        return this.nestedTypeFilter;
    }

    public String nestedTypePath() {
        return this.nestedTypePath;
    }

    @Override
    public boolean isNested() {
        return true;
    }

    public boolean isIncludeInParent() {
        return (Boolean)this.includeInParent.value();
    }

    public void setIncludeInParent(boolean includeInParent) {
        this.includeInParent = new Explicit((Object)includeInParent, true);
    }

    public boolean isIncludeInRoot() {
        return (Boolean)this.includeInRoot.value();
    }

    public void setIncludeInRoot(boolean includeInRoot) {
        this.includeInRoot = new Explicit((Object)includeInRoot, true);
    }

    public Map<String, Mapper> getChildren() {
        return Collections.unmodifiableMap(this.mappers);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.simpleName());
        builder.field("type", CONTENT_TYPE);
        if (((Boolean)this.includeInParent.value()).booleanValue()) {
            builder.field("include_in_parent", (Boolean)this.includeInParent.value());
        }
        if (((Boolean)this.includeInRoot.value()).booleanValue()) {
            builder.field("include_in_root", (Boolean)this.includeInRoot.value());
        }
        if (this.dynamic != null) {
            builder.field("dynamic", this.dynamic.name().toLowerCase(Locale.ROOT));
        }
        if (!this.isEnabled()) {
            builder.field("enabled", (Boolean)this.enabled.value());
        }
        this.serializeMappers(builder, params);
        return builder.endObject();
    }

    @Override
    public ObjectMapper merge(Mapper mergeWith, MergeReason reason) {
        if (!(mergeWith instanceof NestedObjectMapper)) {
            throw new IllegalArgumentException("can't merge a non nested mapping [" + mergeWith.name() + "] with a nested mapping");
        }
        NestedObjectMapper mergeWithObject = (NestedObjectMapper)mergeWith;
        NestedObjectMapper toMerge = (NestedObjectMapper)this.clone();
        if (reason == MergeReason.INDEX_TEMPLATE) {
            if (mergeWithObject.includeInParent.explicit()) {
                toMerge.includeInParent = mergeWithObject.includeInParent;
            }
            if (mergeWithObject.includeInRoot.explicit()) {
                toMerge.includeInRoot = mergeWithObject.includeInRoot;
            }
        } else {
            if (this.includeInParent.value() != mergeWithObject.includeInParent.value()) {
                throw new MapperException("the [include_in_parent] parameter can't be updated on a nested object mapping");
            }
            if (this.includeInRoot.value() != mergeWithObject.includeInRoot.value()) {
                throw new MapperException("the [include_in_root] parameter can't be updated on a nested object mapping");
            }
        }
        toMerge.doMerge(mergeWithObject, reason);
        return toMerge;
    }

    public static class Builder
    extends ObjectMapper.Builder {
        private Explicit<Boolean> includeInRoot = new Explicit((Object)false, false);
        private Explicit<Boolean> includeInParent = new Explicit((Object)false, false);
        private final Version<?> indexCreatedVersion;

        public Builder(String name, Version<?> indexCreatedVersion) {
            super(name);
            this.indexCreatedVersion = indexCreatedVersion;
        }

        Builder includeInRoot(boolean includeInRoot) {
            this.includeInRoot = new Explicit((Object)includeInRoot, true);
            return this;
        }

        Builder includeInParent(boolean includeInParent) {
            this.includeInParent = new Explicit((Object)includeInParent, true);
            return this;
        }

        @Override
        public NestedObjectMapper build(ContentPath contentPath) {
            return new NestedObjectMapper(this.name, contentPath.pathAsText(this.name), this.buildMappers(contentPath), this);
        }
    }

    public static class TypeParser
    extends ObjectMapper.TypeParser {
        @Override
        public Mapper.Builder parse(String name, Map<String, Object> node, MappingParserContext parserContext) throws MapperParsingException {
            Builder builder = new Builder(name, parserContext.indexVersionCreated());
            TypeParser.parseNested(name, node, builder);
            Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
            while (iterator.hasNext()) {
                Object fieldNode;
                Map.Entry<String, Object> entry = iterator.next();
                String fieldName = entry.getKey();
                if (!TypeParser.parseObjectOrDocumentTypeProperties(fieldName, fieldNode = entry.getValue(), parserContext, builder)) continue;
                iterator.remove();
            }
            return builder;
        }

        protected static void parseNested(String name, Map<String, Object> node, Builder builder) {
            Object fieldNode = node.get("include_in_parent");
            if (fieldNode != null) {
                boolean includeInParent = XContentMapValuesUtil.nodeBooleanValue(fieldNode, name + ".include_in_parent");
                builder.includeInParent(includeInParent);
                node.remove("include_in_parent");
            }
            if ((fieldNode = node.get("include_in_root")) != null) {
                boolean includeInRoot = XContentMapValuesUtil.nodeBooleanValue(fieldNode, name + ".include_in_root");
                builder.includeInRoot(includeInRoot);
                node.remove("include_in_root");
            }
        }
    }
}

