/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.mapper;

import io.skylite.core.ParseField;
import io.skylite.core.common.bytes.BytesArray;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.mapper.LuceneDocument;
import io.skylite.core.mapper.MetadataFieldsUtil;
import io.skylite.core.mapper.SequenceIDFields;
import io.skylite.core.xcontent.MediaType;
import io.skylite.core.xcontent.MediaTypeRegistry;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.util.BytesRef;

public class ParsedDocument {
    private final Field version;
    private final String id;
    private final SequenceIDFields seqID;
    private final String routing;
    private final List<LuceneDocument> documents;
    private BytesReference source;
    private MediaType mediaType;

    public static ParsedDocument noopTombstone(String reason) {
        LuceneDocument document = new LuceneDocument();
        SequenceIDFields seqIdFields = SequenceIDFields.tombstone();
        seqIdFields.addFields(document);
        Field versionField = MetadataFieldsUtil.versionField();
        document.add((IndexableField)versionField);
        BytesRef byteRef = new BytesRef((CharSequence)reason);
        document.add((IndexableField)new StoredField(ParseField.CommonMetaFields.SOURCE_FIELD.getPreferredName(), byteRef.bytes, byteRef.offset, byteRef.length));
        return new ParsedDocument(versionField, seqIdFields, "", null, Collections.singletonList(document), new BytesArray("{}"), MediaTypeRegistry.JSON);
    }

    public static ParsedDocument deleteTombstone(String id) {
        LuceneDocument document = new LuceneDocument();
        SequenceIDFields seqIdFields = SequenceIDFields.tombstone();
        seqIdFields.addFields(document);
        Field versionField = MetadataFieldsUtil.versionField();
        document.add((IndexableField)versionField);
        document.add((IndexableField)MetadataFieldsUtil.idField(id));
        return new ParsedDocument(versionField, seqIdFields, id, null, Collections.singletonList(document), new BytesArray("{}"), MediaTypeRegistry.JSON);
    }

    public ParsedDocument(Field version, SequenceIDFields seqID, String id, String routing, List<LuceneDocument> documents, BytesReference source, MediaType mediaType) {
        this.version = version;
        this.seqID = seqID;
        this.id = id;
        this.routing = routing;
        this.documents = documents;
        this.source = source;
        this.mediaType = mediaType;
    }

    public String id() {
        return this.id;
    }

    public Field version() {
        return this.version;
    }

    public void updateSeqID(long sequenceNumber, long primaryTerm) {
        this.seqID.seqNo.setLongValue(sequenceNumber);
        this.seqID.seqNoDocValue.setLongValue(sequenceNumber);
        this.seqID.primaryTerm.setLongValue(primaryTerm);
    }

    public String routing() {
        return this.routing;
    }

    public LuceneDocument rootDoc() {
        return this.documents.get(this.documents.size() - 1);
    }

    public List<LuceneDocument> docs() {
        return this.documents;
    }

    public BytesReference source() {
        return this.source;
    }

    public MediaType getMediaType() {
        return this.mediaType;
    }

    public void setSource(BytesReference source, MediaType mediaType) {
        this.source = source;
        this.mediaType = mediaType;
    }

    public String toString() {
        return "Document id[" + this.id + "] doc [" + String.valueOf(this.documents) + "]";
    }
}

