/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.mapper;

import io.skylite.SkyliteException;
import io.skylite.Version;
import io.skylite.common.Explicit;
import io.skylite.common.collect.Tuple;
import io.skylite.common.network.InetAddresses;
import io.skylite.common.util.LocaleUtils;
import io.skylite.core.ParseField;
import io.skylite.core.aggregations.values.CoreValuesSourceType;
import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.common.time.DateFormatter;
import io.skylite.core.common.time.DateMathParser;
import io.skylite.core.common.time.DateResolution;
import io.skylite.core.geo.ShapeRelation;
import io.skylite.core.index.fielddata.BaseIndexFieldData;
import io.skylite.core.index.fielddata.DocValueDateFormatters;
import io.skylite.core.index.fielddata.DocValueFormat;
import io.skylite.core.index.fielddata.plain.BinaryIndexFieldData;
import io.skylite.core.index.query.QueryShardContext;
import io.skylite.core.mapper.ContentPath;
import io.skylite.core.mapper.CustomDocValuesField;
import io.skylite.core.mapper.FieldMapper;
import io.skylite.core.mapper.MappedFieldType;
import io.skylite.core.mapper.Mapper;
import io.skylite.core.mapper.MapperParsingException;
import io.skylite.core.mapper.ParseContext;
import io.skylite.core.mapper.RangeType;
import io.skylite.core.mapper.SourceValueFetcher;
import io.skylite.core.mapper.TextSearchInfo;
import io.skylite.core.mapper.ValueFetcher;
import io.skylite.core.search.lookup.SearchLookup;
import io.skylite.core.settings.Setting;
import io.skylite.core.settings.Settings;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.lucene.document.InvertableType;
import org.apache.lucene.document.StoredValue;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;

public class RangeFieldMapper
extends FieldMapper {
    public static final boolean DEFAULT_INCLUDE_UPPER = true;
    public static final boolean DEFAULT_INCLUDE_LOWER = true;
    static final Setting<Boolean> COERCE_SETTING = Setting.boolSetting("index.mapping.coerce", true, Setting.Property.IndexScope);
    private final RangeType type;
    private final boolean index;
    private final boolean hasDocValues;
    private final boolean store;
    private final Explicit<Boolean> coerce;
    private final String format;
    private final Locale locale;
    private final boolean coerceByDefault;
    private final Version indexCreatedVersion;
    private final boolean ignoreMalformed;
    private final boolean ignoreMalformedByDefault;

    private static RangeFieldMapper toType(FieldMapper in) {
        return (RangeFieldMapper)in;
    }

    private RangeFieldMapper(String simpleName, MappedFieldType mappedFieldType, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, RangeType type, Builder builder) {
        super(simpleName, mappedFieldType, multiFields, copyTo);
        this.type = type;
        this.index = builder.index.getValue();
        this.hasDocValues = builder.hasDocValues.getValue();
        this.store = builder.store.getValue();
        this.coerce = builder.coerce.getValue();
        this.format = builder.format.getValue();
        this.locale = builder.locale.getValue();
        this.coerceByDefault = (Boolean)builder.coerce.getDefaultValue().value();
        this.indexCreatedVersion = builder.indexCreatedVersion;
        this.ignoreMalformed = builder.ignoreMalformed.getValue();
        this.ignoreMalformedByDefault = builder.ignoreMalformedByDefault;
    }

    boolean coerce() {
        return (Boolean)this.coerce.value();
    }

    @Override
    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.simpleName(), this.type, this.coerceByDefault, this.ignoreMalformedByDefault, this.indexCreatedVersion).init(this);
    }

    @Override
    public RangeFieldType fieldType() {
        return (RangeFieldType)super.fieldType();
    }

    @Override
    protected String contentType() {
        return this.fieldType().typeName();
    }

    @Override
    protected void parseCreateField(ParseContext context) throws IOException {
        Range range;
        if (context.externalValueSet()) {
            range = context.parseExternalValue(Range.class);
        } else {
            XContentParser parser = context.parser();
            XContentParser.Token start = parser.currentToken();
            if (start == XContentParser.Token.VALUE_NULL) {
                return;
            }
            if (start == XContentParser.Token.START_OBJECT) {
                XContentParser.Token token;
                RangeFieldType fieldType = this.fieldType();
                RangeType rangeType = fieldType.rangeType;
                String fieldName = null;
                Object from = rangeType.minValue();
                Object to = rangeType.maxValue();
                boolean includeFrom = true;
                boolean includeTo = true;
                boolean rangeIsMalformed = false;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        fieldName = parser.currentName();
                        continue;
                    }
                    try {
                        if (fieldName.equals(ParseField.CommonFields.GT_FIELD.getPreferredName())) {
                            includeFrom = false;
                            if (parser.currentToken() == XContentParser.Token.VALUE_NULL) continue;
                            from = rangeType.parseFrom(fieldType, parser, (Boolean)this.coerce.value(), includeFrom);
                            continue;
                        }
                        if (fieldName.equals(ParseField.CommonFields.GTE_FIELD.getPreferredName())) {
                            includeFrom = true;
                            if (parser.currentToken() == XContentParser.Token.VALUE_NULL) continue;
                            from = rangeType.parseFrom(fieldType, parser, (Boolean)this.coerce.value(), includeFrom);
                            continue;
                        }
                        if (fieldName.equals(ParseField.CommonFields.LT_FIELD.getPreferredName())) {
                            includeTo = false;
                            if (parser.currentToken() == XContentParser.Token.VALUE_NULL) continue;
                            to = rangeType.parseTo(fieldType, parser, (Boolean)this.coerce.value(), includeTo);
                            continue;
                        }
                        if (fieldName.equals(ParseField.CommonFields.LTE_FIELD.getPreferredName())) {
                            includeTo = true;
                            if (parser.currentToken() == XContentParser.Token.VALUE_NULL) continue;
                            to = rangeType.parseTo(fieldType, parser, (Boolean)this.coerce.value(), includeTo);
                            continue;
                        }
                        throw new MapperParsingException("error parsing field [" + this.name() + "], with unknown parameter [" + fieldName + "]");
                    }
                    catch (IllegalArgumentException e) {
                        if (this.ignoreMalformed) {
                            rangeIsMalformed = true;
                            continue;
                        }
                        throw e;
                    }
                }
                if (rangeIsMalformed) {
                    context.addIgnoredField(this.fieldType().name());
                    return;
                }
                range = new Range(rangeType, from, to, includeFrom, includeTo);
            } else if (this.fieldType().rangeType == RangeType.IP && start == XContentParser.Token.VALUE_STRING) {
                try {
                    range = RangeFieldMapper.parseIpRangeFromCidr(parser);
                }
                catch (IllegalArgumentException e) {
                    if (this.ignoreMalformed) {
                        context.addIgnoredField(this.fieldType().name());
                        return;
                    }
                    throw e;
                }
            } else {
                throw new MapperParsingException("error parsing field [" + this.name() + "], expected an object but got " + parser.currentName());
            }
        }
        context.doc().addAll(this.fieldType().rangeType.createFields(context, this.name(), range, this.index, this.hasDocValues, this.store));
        if (!this.hasDocValues && (this.index || this.store)) {
            context.addFieldToFieldNamesField(this.fieldType().name());
        }
    }

    private static Range parseIpRangeFromCidr(XContentParser parser) throws IOException {
        Tuple cidr = InetAddresses.parseCidr((String)parser.text());
        byte[] lower = ((InetAddress)cidr.v1()).getAddress();
        byte[] upper = (byte[])lower.clone();
        for (int i = ((Integer)cidr.v2()).intValue(); i < 8 * lower.length; ++i) {
            int m = 1 << 7 - (i & 7);
            int n = i >> 3;
            lower[n] = (byte)(lower[n] & ~m);
            int n2 = i >> 3;
            upper[n2] = (byte)(upper[n2] | m);
        }
        try {
            return new Range(RangeType.IP, InetAddress.getByAddress(lower), InetAddress.getByAddress(upper), true, true);
        }
        catch (UnknownHostException bogus) {
            throw new AssertionError((Object)bogus);
        }
    }

    public static class Builder
    extends FieldMapper.Builder {
        private final FieldMapper.Parameter<Boolean> index = FieldMapper.Parameter.indexParam(m -> RangeFieldMapper.toType((FieldMapper)m).index, true);
        private final FieldMapper.Parameter<Boolean> hasDocValues = FieldMapper.Parameter.docValuesParam(m -> RangeFieldMapper.toType((FieldMapper)m).hasDocValues, true);
        private final FieldMapper.Parameter<Boolean> store = FieldMapper.Parameter.storeParam(m -> RangeFieldMapper.toType((FieldMapper)m).store, false);
        private final FieldMapper.Parameter<Explicit<Boolean>> coerce;
        private final FieldMapper.Parameter<String> format = FieldMapper.Parameter.stringParam("format", false, m -> RangeFieldMapper.toType((FieldMapper)m).format, Defaults.DATE_FORMATTER.pattern());
        private final FieldMapper.Parameter<Locale> locale = new FieldMapper.Parameter<Locale>("locale", false, () -> Locale.ROOT, (n, c, o) -> LocaleUtils.parse((String)o.toString()), m -> RangeFieldMapper.toType((FieldMapper)m).locale);
        private final FieldMapper.Parameter<Map<String, String>> meta = FieldMapper.Parameter.metaParam();
        private final RangeType type;
        private final Version indexCreatedVersion;
        private final boolean ignoreMalformedByDefault;
        private final FieldMapper.Parameter<Boolean> ignoreMalformed;

        public Builder(String name, RangeType type, Settings settings) {
            this(name, type, COERCE_SETTING.get(settings), FieldMapper.IGNORE_MALFORMED_SETTING.get(settings), Mapper.hasIndexCreated(settings) ? IndexMetadata.indexCreated(settings) : null);
        }

        public Builder(String name, RangeType type, boolean coerceByDefault, Version indexCreatedVersion) {
            this(name, type, coerceByDefault, false, indexCreatedVersion);
        }

        public Builder(String name, RangeType type, boolean coerceByDefault, boolean ignoreMalformedByDefault, Version indexCreatedVersion) {
            super(name);
            this.type = type;
            this.coerce = FieldMapper.Parameter.explicitBoolParam("coerce", true, m -> RangeFieldMapper.toType((FieldMapper)m).coerce, coerceByDefault);
            this.indexCreatedVersion = indexCreatedVersion;
            this.ignoreMalformedByDefault = ignoreMalformedByDefault;
            this.ignoreMalformed = FieldMapper.Parameter.boolParam("ignore_malformed", true, m -> RangeFieldMapper.toType((FieldMapper)m).ignoreMalformed, ignoreMalformedByDefault);
            if (this.type != RangeType.DATE) {
                this.format.neverSerialize();
                this.locale.neverSerialize();
            }
        }

        public void docValues(boolean hasDocValues) {
            this.hasDocValues.setValue(hasDocValues);
        }

        Builder format(String format) {
            this.format.setValue(format);
            return this;
        }

        @Override
        protected List<FieldMapper.Parameter<?>> getParameters() {
            return List.of(this.index, this.hasDocValues, this.store, this.coerce, this.format, this.locale, this.meta, this.ignoreMalformed);
        }

        protected RangeFieldType setupFieldType(ContentPath contentPath) {
            if (this.format.isConfigured()) {
                if (this.type != RangeType.DATE) {
                    throw new IllegalArgumentException("field [" + this.name() + "] of type [range] should not define a dateTimeFormatter unless it is a " + String.valueOf((Object)RangeType.DATE) + " type");
                }
                DateFormatter dateTimeFormatter = DateFormatter.forPattern(this.format.getValue()).withLocale(this.locale.getValue());
                return new RangeFieldType(this.buildFullName(contentPath), this.index.getValue(), (boolean)this.store.getValue(), (boolean)this.hasDocValues.getValue(), dateTimeFormatter, (boolean)((Boolean)this.coerce.getValue().value()), this.meta.getValue());
            }
            if (this.type == RangeType.DATE) {
                return new RangeFieldType(this.buildFullName(contentPath), this.index.getValue(), (boolean)this.store.getValue(), (boolean)this.hasDocValues.getValue(), Defaults.DATE_FORMATTER, (boolean)((Boolean)this.coerce.getValue().value()), this.meta.getValue());
            }
            return new RangeFieldType(this.buildFullName(contentPath), this.type, (boolean)this.index.getValue(), (boolean)this.store.getValue(), this.hasDocValues.getValue(), (boolean)((Boolean)this.coerce.getValue().value()), this.meta.getValue());
        }

        @Override
        public RangeFieldMapper build(ContentPath contentPath) {
            RangeFieldType ft = this.setupFieldType(contentPath);
            return new RangeFieldMapper(this.name, ft, this.multiFieldsBuilder.build(this, contentPath), this.copyTo.build(), this.type, this);
        }
    }

    public static final class RangeFieldType
    extends MappedFieldType {
        protected final RangeType rangeType;
        protected final DateFormatter dateTimeFormatter;
        protected final DateMathParser dateMathParser;
        protected final boolean coerce;

        public RangeFieldType(String name, RangeType type, boolean indexed, boolean stored, boolean hasDocValues, boolean coerce, Map<String, String> meta) {
            super(name, indexed, stored, hasDocValues, TextSearchInfo.SIMPLE_MATCH_WITHOUT_TERMS, meta);
            assert (type != RangeType.DATE);
            this.rangeType = Objects.requireNonNull(type);
            this.dateTimeFormatter = null;
            this.dateMathParser = null;
            this.coerce = coerce;
        }

        public RangeFieldType(String name, RangeType type) {
            this(name, type, true, false, true, false, Collections.emptyMap());
        }

        public RangeFieldType(String name, boolean indexed, boolean stored, boolean hasDocValues, DateFormatter formatter, boolean coerce, Map<String, String> meta) {
            super(name, indexed, stored, hasDocValues, TextSearchInfo.SIMPLE_MATCH_WITHOUT_TERMS, meta);
            this.rangeType = RangeType.DATE;
            this.dateTimeFormatter = Objects.requireNonNull(formatter);
            this.dateMathParser = this.dateTimeFormatter.toDateMathParser();
            this.coerce = coerce;
        }

        public RangeFieldType(String name, DateFormatter formatter) {
            this(name, true, false, true, formatter, false, Collections.emptyMap());
        }

        public RangeType rangeType() {
            return this.rangeType;
        }

        @Override
        public BaseIndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName, Supplier<SearchLookup> searchLookup) {
            this.failIfNoDocValues();
            return new BinaryIndexFieldData.Builder(this.name(), CoreValuesSourceType.RANGE);
        }

        @Override
        public ValueFetcher valueFetcher(QueryShardContext context, SearchLookup searchLookup, String format) {
            DateFormatter defaultFormatter = this.dateTimeFormatter();
            final DateFormatter formatter = format != null ? DateFormatter.forPattern(format).withLocale(defaultFormatter.locale()) : defaultFormatter;
            return new SourceValueFetcher(this.name(), context){

                @Override
                protected Object parseSourceValue(Object value) {
                    RangeType rangeType = this.rangeType();
                    if (!(value instanceof Map)) {
                        assert (rangeType == RangeType.IP);
                        Tuple ipRange = InetAddresses.parseCidr((String)value.toString());
                        return InetAddresses.toCidrString((InetAddress)((InetAddress)ipRange.v1()), (int)((Integer)ipRange.v2()));
                    }
                    Map range = (Map)value;
                    HashMap<String, Object> parsedRange = new HashMap<String, Object>();
                    for (Map.Entry entry : range.entrySet()) {
                        Object parsedValue = rangeType.parseValue(entry.getValue(), coerce, dateMathParser);
                        Object formattedValue = rangeType.formatValue(parsedValue, formatter);
                        parsedRange.put((String)entry.getKey(), formattedValue);
                    }
                    return parsedRange;
                }
            };
        }

        @Override
        public String typeName() {
            return this.rangeType.name;
        }

        public DateFormatter dateTimeFormatter() {
            return this.dateTimeFormatter;
        }

        protected DateMathParser dateMathParser() {
            return this.dateMathParser;
        }

        @Override
        public DocValueFormat docValueFormat(String format, ZoneId timeZone) {
            if (this.rangeType == RangeType.DATE) {
                DateFormatter dateTimeFormatter = this.dateTimeFormatter;
                if (format != null) {
                    dateTimeFormatter = DateFormatter.forPattern(format).withLocale(dateTimeFormatter.locale());
                }
                if (timeZone == null) {
                    timeZone = ZoneOffset.UTC;
                }
                return new DocValueDateFormatters.DateTime(dateTimeFormatter, timeZone, DateResolution.MILLISECONDS);
            }
            return super.docValueFormat(format, timeZone);
        }

        @Override
        public Query termQuery(Object value, QueryShardContext context) {
            return this.rangeQuery(value, value, true, true, ShapeRelation.INTERSECTS, null, null, context);
        }

        @Override
        public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, ShapeRelation relation, ZoneId timeZone, DateMathParser parser, QueryShardContext context) {
            this.failIfNotIndexed();
            if (parser == null) {
                parser = this.dateMathParser();
            }
            return this.rangeType.rangeQuery(this.name(), this.hasDocValues(), lowerTerm, upperTerm, includeLower, includeUpper, relation, timeZone, parser, context);
        }
    }

    public static class Range {
        RangeType type;
        Object from;
        Object to;
        private final boolean includeFrom;
        private final boolean includeTo;

        public Range(RangeType type, Object from, Object to, boolean includeFrom, boolean includeTo) {
            this.type = type;
            this.from = from;
            this.to = to;
            this.includeFrom = includeFrom;
            this.includeTo = includeTo;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Range range = (Range)o;
            return this.includeFrom == range.includeFrom && this.includeTo == range.includeTo && this.type == range.type && this.from.equals(range.from) && this.to.equals(range.to);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type, this.from, this.to, this.includeFrom, this.includeTo});
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.includeFrom ? (char)'[' : '(');
            Object f = this.includeFrom || this.from.equals(this.type.minValue()) ? this.from : this.type.nextDown(this.from);
            Object t = this.includeTo || this.to.equals(this.type.maxValue()) ? this.to : this.type.nextUp(this.to);
            sb.append(this.type == RangeType.IP ? InetAddresses.toAddrString((InetAddress)((InetAddress)f)) : f.toString());
            sb.append(" : ");
            sb.append(this.type == RangeType.IP ? InetAddresses.toAddrString((InetAddress)((InetAddress)t)) : t.toString());
            sb.append(this.includeTo ? (char)']' : ')');
            return sb.toString();
        }

        public Object getFrom() {
            return this.from;
        }

        public Object getTo() {
            return this.to;
        }
    }

    static class BinaryRangesDocValuesField
    extends CustomDocValuesField {
        private final Set<Range> ranges;
        private final RangeType rangeType;

        BinaryRangesDocValuesField(String name, Range range, RangeType rangeType) {
            super(name);
            this.rangeType = rangeType;
            this.ranges = new HashSet<Range>();
            this.add(range);
        }

        void add(Range range) {
            this.ranges.add(range);
        }

        public BytesRef binaryValue() {
            try {
                return this.rangeType.encodeRanges(this.ranges);
            }
            catch (IOException e) {
                throw new SkyliteException("failed to encode ranges", (Throwable)e, new Object[0]);
            }
        }

        public StoredValue storedValue() {
            return null;
        }

        public InvertableType invertableType() {
            return InvertableType.BINARY;
        }
    }

    public static class Defaults {
        public static final Explicit<Boolean> COERCE = new Explicit((Object)true, false);
        public static final DateFormatter DATE_FORMATTER = DateFormatter.getDefaultDateTimeFormatter();
    }
}

