/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.mapper;

import io.skylite.SkyliteParseException;
import io.skylite.common.Explicit;
import io.skylite.core.common.Strings;
import io.skylite.core.common.logging.DeprecationLogger;
import io.skylite.core.common.time.DateFormatter;
import io.skylite.core.mapper.BaseMappedFieldType;
import io.skylite.core.mapper.ContentPath;
import io.skylite.core.mapper.Mapper;
import io.skylite.core.mapper.MapperParsingException;
import io.skylite.core.mapper.MappingParserContext;
import io.skylite.core.mapper.MergeReason;
import io.skylite.core.mapper.NestedObjectMapper;
import io.skylite.core.mapper.ObjectMapper;
import io.skylite.core.mapper.RuntimeFieldType;
import io.skylite.core.mapper.dynamic.DynamicTemplate;
import io.skylite.core.mapper.dynamic.TemplateParser;
import io.skylite.core.mapper.dynamic.XContentFieldType;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.util.XContentMapValuesUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

public class RootObjectMapper
extends ObjectMapper {
    private static final DeprecationLogger DEPRECATION_LOGGER = DeprecationLogger.getLogger(RootObjectMapper.class);
    private Explicit<DateFormatter[]> dynamicDateTimeFormatters;
    private Explicit<Boolean> dateDetection;
    private Explicit<Boolean> numericDetection;
    private Explicit<DynamicTemplate[]> dynamicTemplates;
    private Map<String, RuntimeFieldType> runtimeFieldTypes;

    public void fixRedundantIncludes() {
        RootObjectMapper.fixRedundantIncludes(this, true);
    }

    private static void fixRedundantIncludes(ObjectMapper objectMapper, boolean parentIncluded) {
        for (Mapper mapper : objectMapper) {
            boolean includedInRoot;
            if (!(mapper instanceof NestedObjectMapper)) continue;
            NestedObjectMapper child = (NestedObjectMapper)mapper;
            boolean isNested = child.isNested();
            boolean includeInRootViaParent = parentIncluded && isNested && child.isIncludeInParent();
            boolean bl = includedInRoot = isNested && child.isIncludeInRoot();
            if (includeInRootViaParent && includedInRoot) {
                child.setIncludeInParent(true);
                child.setIncludeInRoot(false);
            }
            RootObjectMapper.fixRedundantIncludes(child, includeInRootViaParent || includedInRoot);
        }
    }

    RootObjectMapper(String name, Explicit<Boolean> enabled, ObjectMapper.Dynamic dynamic, Map<String, Mapper> mappers, Map<String, RuntimeFieldType> runtimeFieldTypes, Explicit<DateFormatter[]> dynamicDateTimeFormatters, Explicit<DynamicTemplate[]> dynamicTemplates, Explicit<Boolean> dateDetection, Explicit<Boolean> numericDetection) {
        super(name, name, enabled, dynamic, mappers);
        this.runtimeFieldTypes = runtimeFieldTypes;
        this.dynamicTemplates = dynamicTemplates;
        this.dynamicDateTimeFormatters = dynamicDateTimeFormatters;
        this.dateDetection = dateDetection;
        this.numericDetection = numericDetection;
    }

    @Override
    protected ObjectMapper clone() {
        ObjectMapper clone = super.clone();
        ((RootObjectMapper)clone).runtimeFieldTypes = new HashMap<String, RuntimeFieldType>(this.runtimeFieldTypes);
        return clone;
    }

    @Override
    RootObjectMapper copyAndReset() {
        RootObjectMapper copy = (RootObjectMapper)super.copyAndReset();
        copy.dynamicTemplates = new Explicit((Object)new DynamicTemplate[0], false);
        copy.dynamicDateTimeFormatters = new Explicit((Object)Defaults.DYNAMIC_DATE_TIME_FORMATTERS, false);
        copy.dateDetection = new Explicit((Object)true, false);
        copy.numericDetection = new Explicit((Object)false, false);
        copy.runtimeFieldTypes.clear();
        return copy;
    }

    boolean dateDetection() {
        return (Boolean)this.dateDetection.value();
    }

    boolean numericDetection() {
        return (Boolean)this.numericDetection.value();
    }

    DateFormatter[] dynamicDateTimeFormatters() {
        return (DateFormatter[])this.dynamicDateTimeFormatters.value();
    }

    DynamicTemplate[] dynamicTemplates() {
        return (DynamicTemplate[])this.dynamicTemplates.value();
    }

    Collection<RuntimeFieldType> runtimeFieldTypes() {
        return this.runtimeFieldTypes.values();
    }

    RuntimeFieldType getRuntimeFieldType(String name) {
        return this.runtimeFieldTypes.get(name);
    }

    public DynamicTemplate findTemplate(ContentPath path, String name, XContentFieldType matchType) {
        String pathAsString = path.pathAsText(name);
        for (DynamicTemplate dynamicTemplate : (DynamicTemplate[])this.dynamicTemplates.value()) {
            if (!dynamicTemplate.match(pathAsString, name, matchType)) continue;
            return dynamicTemplate;
        }
        return null;
    }

    @Override
    public RootObjectMapper merge(Mapper mergeWith, MergeReason reason) {
        return (RootObjectMapper)super.merge(mergeWith, reason);
    }

    @Override
    protected void doMerge(ObjectMapper mergeWith, MergeReason reason) {
        super.doMerge(mergeWith, reason);
        RootObjectMapper mergeWithObject = (RootObjectMapper)mergeWith;
        if (mergeWithObject.numericDetection.explicit()) {
            this.numericDetection = mergeWithObject.numericDetection;
        }
        if (mergeWithObject.dateDetection.explicit()) {
            this.dateDetection = mergeWithObject.dateDetection;
        }
        if (mergeWithObject.dynamicDateTimeFormatters.explicit()) {
            this.dynamicDateTimeFormatters = mergeWithObject.dynamicDateTimeFormatters;
        }
        if (mergeWithObject.dynamicTemplates.explicit()) {
            if (reason == MergeReason.INDEX_TEMPLATE) {
                LinkedHashMap<String, DynamicTemplate> templatesByKey = new LinkedHashMap<String, DynamicTemplate>();
                for (DynamicTemplate template : (DynamicTemplate[])this.dynamicTemplates.value()) {
                    templatesByKey.put(template.name(), template);
                }
                for (DynamicTemplate template : (DynamicTemplate[])mergeWithObject.dynamicTemplates.value()) {
                    templatesByKey.put(template.name(), template);
                }
                DynamicTemplate[] mergedTemplates = templatesByKey.values().toArray(new DynamicTemplate[0]);
                this.dynamicTemplates = new Explicit((Object)mergedTemplates, true);
            } else {
                this.dynamicTemplates = mergeWithObject.dynamicTemplates;
            }
        }
        assert (this.runtimeFieldTypes != mergeWithObject.runtimeFieldTypes);
        this.runtimeFieldTypes.putAll(mergeWithObject.runtimeFieldTypes);
    }

    void addRuntimeFields(Collection<RuntimeFieldType> runtimeFields) {
        for (RuntimeFieldType runtimeField : runtimeFields) {
            this.runtimeFieldTypes.put(runtimeField.name(), runtimeField);
        }
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        boolean includeDefaults = params.paramAsBoolean("include_defaults", false);
        if (this.dynamicDateTimeFormatters.explicit() || includeDefaults) {
            builder.startArray("dynamic_date_formats");
            for (DateFormatter dateTimeFormatter : (DateFormatter[])this.dynamicDateTimeFormatters.value()) {
                builder.value(dateTimeFormatter.pattern());
            }
            builder.endArray();
        }
        if (this.dynamicTemplates.explicit() || includeDefaults) {
            builder.startArray("dynamic_templates");
            for (DynamicTemplate dynamicTemplate : (DynamicTemplate[])this.dynamicTemplates.value()) {
                builder.startObject();
                builder.field(dynamicTemplate.name(), dynamicTemplate);
                builder.endObject();
            }
            builder.endArray();
        }
        if (this.dateDetection.explicit() || includeDefaults) {
            builder.field("date_detection", (Boolean)this.dateDetection.value());
        }
        if (this.numericDetection.explicit() || includeDefaults) {
            builder.field("numeric_detection", (Boolean)this.numericDetection.value());
        }
        if (this.runtimeFieldTypes.size() > 0) {
            builder.startObject("runtime");
            List sortedRuntimeFieldTypes = this.runtimeFieldTypes.values().stream().sorted(Comparator.comparing(BaseMappedFieldType::name)).collect(Collectors.toList());
            for (RuntimeFieldType fieldType : sortedRuntimeFieldTypes) {
                fieldType.toXContent(builder, params);
            }
            builder.endObject();
        }
    }

    private static void validateDynamicTemplate(MappingParserContext parserContext, DynamicTemplate dynamicTemplate) {
        if (RootObjectMapper.containsSnippet(dynamicTemplate.getMapping(), "{name}")) {
            return;
        }
        XContentFieldType[] types = dynamicTemplate.getXContentFieldType() != null ? new XContentFieldType[]{dynamicTemplate.getXContentFieldType()} : XContentFieldType.values();
        Exception lastError = null;
        boolean dynamicTemplateInvalid = true;
        for (XContentFieldType contentFieldType : types) {
            String defaultDynamicType = contentFieldType.getDefaultMappingType();
            String mappingType = dynamicTemplate.mappingType(defaultDynamicType);
            Mapper.TypeParser typeParser = parserContext.typeParser(mappingType);
            if (typeParser == null) {
                lastError = new IllegalArgumentException("No mapper found for type [" + mappingType + "]");
                continue;
            }
            String templateName = "__dynamic__" + dynamicTemplate.name();
            Map<String, Object> fieldTypeConfig = dynamicTemplate.mappingForName(templateName, defaultDynamicType);
            try {
                Mapper.Builder dummyBuilder = typeParser.parse(templateName, fieldTypeConfig, parserContext);
                fieldTypeConfig.remove("type");
                if (fieldTypeConfig.isEmpty()) {
                    dummyBuilder.build(new ContentPath(1));
                    dynamicTemplateInvalid = false;
                    break;
                }
                lastError = new IllegalArgumentException("Unused mapping attributes [" + String.valueOf(fieldTypeConfig) + "]");
            }
            catch (Exception e) {
                lastError = e;
            }
        }
        if (dynamicTemplateInvalid) {
            String message = String.format(Locale.ROOT, "dynamic template [%s] has invalid content [%s]", dynamicTemplate.getName(), Strings.toString(MediaTypeRegistry.JSON, dynamicTemplate));
            String deprecationMessage = lastError != null ? String.format(Locale.ROOT, "%s, caused by [%s]", message, lastError.getMessage()) : message;
            DEPRECATION_LOGGER.deprecate("invalid_dynamic_template_" + dynamicTemplate.getName(), deprecationMessage, new Object[0]);
        }
    }

    private static boolean containsSnippet(Map<?, ?> map, String snippet) {
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            String valueString;
            String key = entry.getKey().toString();
            if (key.contains(snippet)) {
                return true;
            }
            Object value = entry.getValue();
            if (!(value instanceof Map ? RootObjectMapper.containsSnippet((Map)value, snippet) : (value instanceof List ? RootObjectMapper.containsSnippet((List)value, snippet) : value instanceof String && (valueString = (String)value).contains(snippet)))) continue;
            return true;
        }
        return false;
    }

    private static boolean containsSnippet(List<?> list, String snippet) {
        for (Object value : list) {
            String valueString;
            if (!(value instanceof Map ? RootObjectMapper.containsSnippet((Map)value, snippet) : (value instanceof List ? RootObjectMapper.containsSnippet((List)value, snippet) : value instanceof String && (valueString = (String)value).contains(snippet)))) continue;
            return true;
        }
        return false;
    }

    public static class Defaults {
        public static final DateFormatter[] DYNAMIC_DATE_TIME_FORMATTERS = new DateFormatter[]{DateFormatter.getDefaultDateTimeFormatter(), DateFormatter.forPattern("yyyy/MM/dd HH:mm:ss||yyyy/MM/dd||epoch_millis")};
        public static final boolean DATE_DETECTION = true;
        public static final boolean NUMERIC_DETECTION = false;
    }

    static final class TypeParser
    extends ObjectMapper.TypeParser {
        TypeParser() {
        }

        @Override
        public Builder parse(String name, Map<String, Object> node, MappingParserContext parserContext) throws MapperParsingException {
            Builder builder = new Builder(name);
            Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
            while (iterator.hasNext()) {
                Object fieldNode;
                Map.Entry<String, Object> entry = iterator.next();
                String fieldName = entry.getKey();
                if (!TypeParser.parseObjectOrDocumentTypeProperties(fieldName, fieldNode = entry.getValue(), parserContext, builder) && !this.processField(builder, fieldName, fieldNode, parserContext)) continue;
                iterator.remove();
            }
            return builder;
        }

        private boolean processField(Builder builder, String fieldName, Object fieldNode, MappingParserContext parserContext) {
            if (fieldName.equals("date_formats") || fieldName.equals("dynamic_date_formats")) {
                if (fieldNode instanceof List) {
                    ArrayList<DateFormatter> formatters = new ArrayList<DateFormatter>();
                    for (Object formatter : (List)fieldNode) {
                        if (formatter.toString().startsWith("epoch_")) {
                            throw new MapperParsingException("Epoch [" + String.valueOf(formatter) + "] is not supported as dynamic date format");
                        }
                        formatters.add(DateFormatter.parseDateTimeFormatter(formatter));
                    }
                    builder.dynamicDateTimeFormatter(formatters);
                } else if ("none".equals(fieldNode.toString())) {
                    builder.dynamicDateTimeFormatter(Collections.emptyList());
                } else {
                    builder.dynamicDateTimeFormatter(Collections.singleton(DateFormatter.parseDateTimeFormatter(fieldNode)));
                }
                return true;
            }
            if (fieldName.equals("dynamic_templates")) {
                if (!(fieldNode instanceof List)) {
                    throw new MapperParsingException("Dynamic template syntax error. An array of named objects is expected.");
                }
                List tmplNodes = (List)fieldNode;
                ArrayList<DynamicTemplate> templates = new ArrayList<DynamicTemplate>();
                for (Object tmplNode : tmplNodes) {
                    Map tmpl = (Map)tmplNode;
                    if (tmpl.size() != 1) {
                        throw new MapperParsingException("A dynamic template must be defined with a name");
                    }
                    Map.Entry entry = tmpl.entrySet().iterator().next();
                    String templateName = (String)entry.getKey();
                    Map templateParams = (Map)entry.getValue();
                    DynamicTemplate template = TemplateParser.parse(templateName, templateParams);
                    RootObjectMapper.validateDynamicTemplate(parserContext, template);
                    templates.add(template);
                }
                builder.dynamicTemplates(templates);
                return true;
            }
            if (fieldName.equals("date_detection")) {
                builder.dateDetection = new Explicit((Object)XContentMapValuesUtil.nodeBooleanValue(fieldNode, "date_detection"), true);
                return true;
            }
            if (fieldName.equals("numeric_detection")) {
                builder.numericDetection = new Explicit((Object)XContentMapValuesUtil.nodeBooleanValue(fieldNode, "numeric_detection"), true);
                return true;
            }
            if (fieldName.equals("runtime")) {
                if (fieldNode instanceof Map) {
                    RuntimeFieldType.parseRuntimeFields((Map)fieldNode, parserContext, builder::addRuntime);
                    return true;
                }
                throw new SkyliteParseException("runtime must be a map type", new Object[0]);
            }
            return false;
        }
    }

    public static class Builder
    extends ObjectMapper.Builder {
        protected Explicit<DynamicTemplate[]> dynamicTemplates = new Explicit((Object)new DynamicTemplate[0], false);
        protected Explicit<DateFormatter[]> dynamicDateTimeFormatters = new Explicit((Object)Defaults.DYNAMIC_DATE_TIME_FORMATTERS, false);
        protected Explicit<Boolean> dateDetection = new Explicit((Object)true, false);
        protected Explicit<Boolean> numericDetection = new Explicit((Object)false, false);
        protected final Map<String, RuntimeFieldType> runtimeFieldTypes = new HashMap<String, RuntimeFieldType>();

        public Builder(String name) {
            super(name);
        }

        public Builder dynamicDateTimeFormatter(Collection<DateFormatter> dateTimeFormatters) {
            this.dynamicDateTimeFormatters = new Explicit((Object)dateTimeFormatters.toArray(new DateFormatter[0]), true);
            return this;
        }

        public Builder dynamicTemplates(Collection<DynamicTemplate> templates) {
            this.dynamicTemplates = new Explicit((Object)templates.toArray(new DynamicTemplate[0]), true);
            return this;
        }

        @Override
        public Builder add(Mapper.Builder builder) {
            super.add(builder);
            return this;
        }

        public Builder addRuntime(RuntimeFieldType runtimeFieldType) {
            this.runtimeFieldTypes.put(runtimeFieldType.name(), runtimeFieldType);
            return this;
        }

        @Override
        public RootObjectMapper build(ContentPath contentPath) {
            return new RootObjectMapper(this.name, (Explicit<Boolean>)this.enabled, this.dynamic, this.buildMappers(contentPath), this.runtimeFieldTypes, this.dynamicDateTimeFormatters, this.dynamicTemplates, this.dateDetection, this.numericDetection);
        }
    }
}

