/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.mapper;

import io.skylite.core.mapper.MappedFieldType;
import io.skylite.core.mapper.MapperParsingException;
import io.skylite.core.mapper.MappingParser;
import io.skylite.core.mapper.MappingParserContext;
import io.skylite.core.mapper.TextSearchInfo;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentFragment;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Consumer;

public abstract class RuntimeFieldType
extends MappedFieldType
implements ToXContentFragment {
    protected RuntimeFieldType(String name, Map<String, String> meta) {
        super(name, false, false, false, TextSearchInfo.SIMPLE_MATCH_WITHOUT_TERMS, meta);
    }

    @Override
    public final XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.name());
        builder.field("type", this.typeName());
        boolean includeDefaults = params.paramAsBoolean("include_defaults", false);
        this.doXContentBody(builder, includeDefaults);
        builder.endObject();
        return builder;
    }

    protected abstract void doXContentBody(XContentBuilder var1, boolean var2) throws IOException;

    public static void parseRuntimeFields(Map<String, Object> node, MappingParserContext parserContext, Consumer<RuntimeFieldType> runtimeFieldTypeConsumer) {
        Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> entry = iterator.next();
            String fieldName = entry.getKey();
            if (entry.getValue() instanceof Map) {
                HashMap<String, Object> propNode = new HashMap<String, Object>((Map)entry.getValue());
                Object typeNode = propNode.get("type");
                if (typeNode == null) {
                    throw new MapperParsingException("No type specified for runtime field [" + fieldName + "]");
                }
                String type = typeNode.toString();
                Parser typeParser = parserContext.runtimeTypeParsers().apply(type);
                if (typeParser == null) {
                    throw new MapperParsingException("No handler for type [" + type + "] declared on runtime field [" + fieldName + "]");
                }
                runtimeFieldTypeConsumer.accept(typeParser.parse(fieldName, propNode, parserContext));
                propNode.remove("type");
                MappingParser.checkNoRemainingFields(fieldName, propNode);
                iterator.remove();
                continue;
            }
            throw new MapperParsingException("Expected map for runtime field [" + fieldName + "] definition but got a " + fieldName.getClass().getName());
        }
    }

    public static interface Parser {
        public RuntimeFieldType parse(String var1, Map<String, Object> var2, MappingParserContext var3) throws MapperParsingException;
    }
}

