/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.mapper;

import io.skylite.common.Nullable;
import io.skylite.core.ParseField;
import io.skylite.core.index.fielddata.BaseIndexFieldData;
import io.skylite.core.index.fielddata.IndexNumericFieldData;
import io.skylite.core.index.fielddata.plain.SortedNumericIndexFieldData;
import io.skylite.core.index.query.QueryShardContext;
import io.skylite.core.mapper.LuceneDocument;
import io.skylite.core.mapper.MetadataFieldMapper;
import io.skylite.core.mapper.ParseContext;
import io.skylite.core.mapper.SequenceIDFields;
import io.skylite.core.mapper.SimpleMappedFieldType;
import io.skylite.core.mapper.TextSearchInfo;
import io.skylite.core.mapper.ValueFetcher;
import io.skylite.core.search.lookup.SearchLookup;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;

public class SeqNoFieldMapper
extends MetadataFieldMapper {
    public static final String NAME;
    public static final String CONTENT_TYPE;
    public static final String PRIMARY_TERM_NAME;
    public static final String TOMBSTONE_NAME;
    public static final SeqNoFieldMapper INSTANCE;
    public static final MetadataFieldMapper.TypeParser PARSER;

    public SeqNoFieldMapper() {
        super(SeqNoFieldType.INSTANCE);
    }

    @Override
    public void preParse(ParseContext context) throws IOException {
        SequenceIDFields seqID = SequenceIDFields.emptySeqID();
        context.seqID(seqID);
        seqID.addFields(context.doc());
    }

    @Override
    public void postParse(ParseContext context) throws IOException {
        SequenceIDFields seqID = context.seqID();
        assert (seqID != null);
        for (LuceneDocument doc : context.nonRootDocuments()) {
            doc.add((IndexableField)seqID.seqNo);
            doc.add((IndexableField)seqID.seqNoDocValue);
        }
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    static {
        CONTENT_TYPE = NAME = ParseField.CommonMetaFields.SEQ_NO_FIELD.getPreferredName();
        PRIMARY_TERM_NAME = ParseField.CommonMetaFields.PRIMARY_TERM_FIELD.getPreferredName();
        TOMBSTONE_NAME = ParseField.CommonMetaFields.TOMBSTONE_FIELD.getPreferredName();
        INSTANCE = new SeqNoFieldMapper();
        PARSER = new MetadataFieldMapper.FixedTypeParser(c -> new SeqNoFieldMapper());
    }

    static final class SeqNoFieldType
    extends SimpleMappedFieldType {
        private static final SeqNoFieldType INSTANCE = new SeqNoFieldType();

        private SeqNoFieldType() {
            super(NAME, true, false, true, TextSearchInfo.SIMPLE_MATCH_WITHOUT_TERMS, Collections.emptyMap());
        }

        @Override
        public String typeName() {
            return CONTENT_TYPE;
        }

        private long parse(Object value) {
            if (value instanceof Number) {
                double doubleValue = ((Number)value).doubleValue();
                if (doubleValue < -9.223372036854776E18 || doubleValue > 9.223372036854776E18) {
                    throw new IllegalArgumentException("Value [" + String.valueOf(value) + "] is out of range for a long");
                }
                if (doubleValue % 1.0 != 0.0) {
                    throw new IllegalArgumentException("Value [" + String.valueOf(value) + "] has a decimal part");
                }
                return ((Number)value).longValue();
            }
            if (value instanceof BytesRef) {
                value = ((BytesRef)value).utf8ToString();
            }
            return Long.parseLong(value.toString());
        }

        @Override
        public ValueFetcher valueFetcher(QueryShardContext context, SearchLookup lookup, String format) {
            throw new UnsupportedOperationException("Cannot fetch values for internal field [" + this.name() + "].");
        }

        @Override
        public Query termQuery(Object value, @Nullable QueryShardContext context) {
            long v = this.parse(value);
            return LongPoint.newExactQuery((String)this.name(), (long)v);
        }

        @Override
        public Query termsQuery(List<?> values, @Nullable QueryShardContext context) {
            long[] v = new long[values.size()];
            for (int i = 0; i < values.size(); ++i) {
                v[i] = this.parse(values.get(i));
            }
            return LongPoint.newSetQuery((String)this.name(), (long[])v);
        }

        @Override
        public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, QueryShardContext context) {
            long l = Long.MIN_VALUE;
            long u = Long.MAX_VALUE;
            if (lowerTerm != null) {
                l = this.parse(lowerTerm);
                if (!includeLower) {
                    if (l == Long.MAX_VALUE) {
                        return new MatchNoDocsQuery();
                    }
                    ++l;
                }
            }
            if (upperTerm != null) {
                u = this.parse(upperTerm);
                if (!includeUpper) {
                    if (u == Long.MIN_VALUE) {
                        return new MatchNoDocsQuery();
                    }
                    --u;
                }
            }
            return LongPoint.newRangeQuery((String)this.name(), (long)l, (long)u);
        }

        @Override
        public BaseIndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName, Supplier<SearchLookup> searchLookup) {
            this.failIfNoDocValues();
            return new SortedNumericIndexFieldData.Builder(this.name(), IndexNumericFieldData.NumericType.LONG);
        }
    }
}

