/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.mapper.dynamic;

import io.skylite.core.mapper.dynamic.MatchType;
import io.skylite.core.mapper.dynamic.XContentFieldType;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class DynamicTemplate
implements ToXContentObject {
    private final String name;
    private final String pathMatch;
    private final String pathUnmatch;
    private final String match;
    private final String unmatch;
    private final MatchType matchType;
    private final XContentFieldType xcontentFieldTypeDynamic;
    private final Map<String, Object> mapping;

    DynamicTemplate(String name, String pathMatch, String pathUnmatch, String match, String unmatch, XContentFieldType xcontentFieldTypeDynamic, MatchType matchType, Map<String, Object> mapping) {
        this.name = name;
        this.pathMatch = pathMatch;
        this.pathUnmatch = pathUnmatch;
        this.match = match;
        this.unmatch = unmatch;
        this.matchType = matchType;
        this.xcontentFieldTypeDynamic = xcontentFieldTypeDynamic;
        this.mapping = mapping;
    }

    public String name() {
        return this.name;
    }

    public String pathMatch() {
        return this.pathMatch;
    }

    public boolean match(String path, String name, XContentFieldType xcontentFieldTypeDynamic) {
        if (this.pathMatch != null && !this.matchType.matches(this.pathMatch, path)) {
            return false;
        }
        if (this.match != null && !this.matchType.matches(this.match, name)) {
            return false;
        }
        if (this.pathUnmatch != null && this.matchType.matches(this.pathUnmatch, path)) {
            return false;
        }
        if (this.unmatch != null && this.matchType.matches(this.unmatch, name)) {
            return false;
        }
        return this.xcontentFieldTypeDynamic == null || this.xcontentFieldTypeDynamic == xcontentFieldTypeDynamic;
    }

    public String mappingType(String dynamicType) {
        Object index;
        String type;
        if (this.mapping.containsKey("type")) {
            type = this.mapping.get("type").toString();
            type = type.replace("{dynamic_type}", dynamicType);
            type = type.replace("{dynamicType}", dynamicType);
        } else {
            type = dynamicType;
        }
        if (!type.equals(this.mapping.get("type")) && "text".equals(type) && ("not_analyzed".equals(index = this.mapping.get("index")) || "no".equals(index))) {
            type = "keyword";
        }
        return type;
    }

    public Map<String, Object> mappingForName(String name, String dynamicType) {
        return this.processMap(this.mapping, name, dynamicType);
    }

    private Map<String, Object> processMap(Map<String, Object> map, String name, String dynamicType) {
        HashMap<String, Object> processedMap = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey().replace("{name}", name).replace("{dynamic_type}", dynamicType).replace("{dynamicType}", dynamicType);
            Map<String, Object> value = entry.getValue();
            if (value instanceof Map) {
                value = this.processMap(value, name, dynamicType);
            } else if (value instanceof List) {
                value = this.processList((List)((Object)value), name, dynamicType);
            } else if (value instanceof String) {
                value = value.toString().replace("{name}", name).replace("{dynamic_type}", dynamicType).replace("{dynamicType}", dynamicType);
            }
            processedMap.put(key, value);
        }
        return processedMap;
    }

    private List processList(List list, String name, String dynamicType) {
        ArrayList<Object> processedList = new ArrayList<Object>(list.size());
        for (Object value : list) {
            if (value instanceof Map) {
                value = this.processMap((Map)value, name, dynamicType);
            } else if (value instanceof List) {
                value = this.processList((List)value, name, dynamicType);
            } else if (value instanceof String) {
                value = value.toString().replace("{name}", name).replace("{dynamic_type}", dynamicType).replace("{dynamicType}", dynamicType);
            }
            processedList.add(value);
        }
        return processedList;
    }

    public String getName() {
        return this.name;
    }

    public XContentFieldType getXContentFieldType() {
        return this.xcontentFieldTypeDynamic;
    }

    public Map<String, Object> getMapping() {
        return this.mapping;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.match != null) {
            builder.field("match", this.match);
        }
        if (this.pathMatch != null) {
            builder.field("path_match", this.pathMatch);
        }
        if (this.unmatch != null) {
            builder.field("unmatch", this.unmatch);
        }
        if (this.pathUnmatch != null) {
            builder.field("path_unmatch", this.pathUnmatch);
        }
        if (this.xcontentFieldTypeDynamic != null) {
            builder.field("match_mapping_type", (Object)this.xcontentFieldTypeDynamic);
        } else if (this.match == null && this.pathMatch == null) {
            builder.field("match_mapping_type", "*");
        }
        if (this.matchType != MatchType.SIMPLE) {
            builder.field("match_pattern", (Object)this.matchType);
        }
        builder.field("mapping", new TreeMap<String, Object>(this.mapping));
        builder.endObject();
        return builder;
    }
}

