/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.mapper.dynamic;

import io.skylite.core.common.regex.Regex;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public enum MatchType {
    SIMPLE(Strategy.simple()),
    REGEX(Strategy.regex());

    private final Strategy strategy;
    private static final Map<String, MatchType> NAME_TO_TYPE_MAP;

    private MatchType(Strategy strategy) {
        this.strategy = strategy;
    }

    public boolean matches(String pattern, String value) {
        return this.strategy.matches(pattern, value);
    }

    public String toString() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public static MatchType fromString(String value) {
        MatchType type = NAME_TO_TYPE_MAP.get(value);
        if (type == null) {
            throw new IllegalArgumentException("No matching pattern matched on [" + value + "]");
        }
        return type;
    }

    static {
        NAME_TO_TYPE_MAP = new HashMap<String, MatchType>();
        for (MatchType type : MatchType.values()) {
            NAME_TO_TYPE_MAP.put(type.toString(), type);
        }
    }

    private static interface Strategy {
        public boolean matches(String var1, String var2);

        public static Strategy simple() {
            return Regex::simpleMatch;
        }

        public static Strategy regex() {
            return (pattern, value) -> value.matches(pattern);
        }
    }
}

