/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.plugins;

import io.skylite.core.analysis.AnalysisProvider;
import io.skylite.core.analysis.AnalyzerProvider;
import io.skylite.core.analysis.CharFilterFactory;
import io.skylite.core.analysis.PreBuiltAnalyzerProviderFactory;
import io.skylite.core.analysis.PreConfiguredCharFilter;
import io.skylite.core.analysis.PreConfiguredTokenFilter;
import io.skylite.core.analysis.PreConfiguredTokenizer;
import io.skylite.core.analysis.TokenFilterFactory;
import io.skylite.core.analysis.TokenizerFactory;
import io.skylite.core.env.Environment;
import io.skylite.core.index.IndexSettings;
import io.skylite.core.settings.Settings;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.hunspell.Dictionary;

public interface AnalysisPlugin {
    default public Map<String, AnalysisProvider<CharFilterFactory>> getCharFilters() {
        return Collections.emptyMap();
    }

    default public Map<String, AnalysisProvider<TokenFilterFactory>> getTokenFilters() {
        return Collections.emptyMap();
    }

    default public Map<String, AnalysisProvider<TokenizerFactory>> getTokenizers() {
        return Collections.emptyMap();
    }

    default public Map<String, AnalysisProvider<AnalyzerProvider<? extends Analyzer>>> getAnalyzers() {
        return Collections.emptyMap();
    }

    default public List<PreBuiltAnalyzerProviderFactory> getPreBuiltAnalyzerProviderFactories() {
        return Collections.emptyList();
    }

    default public List<PreConfiguredCharFilter> getPreConfiguredCharFilters() {
        return Collections.emptyList();
    }

    default public List<PreConfiguredTokenFilter> getPreConfiguredTokenFilters() {
        return Collections.emptyList();
    }

    default public List<PreConfiguredTokenizer> getPreConfiguredTokenizers() {
        return Collections.emptyList();
    }

    default public Map<String, Dictionary> getHunspellDictionaries() {
        return Collections.emptyMap();
    }

    public static <T> AnalysisProvider<T> requiresAnalysisSettings(final AnalysisProvider<T> provider) {
        return new AnalysisProvider<T>(){

            @Override
            public T get(IndexSettings indexSettings, Environment environment, String name, Settings settings) throws IOException {
                return provider.get(indexSettings, environment, name, settings);
            }

            @Override
            public boolean requiresAnalysisSettings() {
                return true;
            }
        };
    }
}

