/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.repositories;

import io.skylite.Version;
import io.skylite.common.Nullable;
import io.skylite.common.action.ActionListener;
import io.skylite.common.lifecycle.LifecycleComponent;
import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.cluster.metadata.Metadata;
import io.skylite.core.cluster.metadata.RepositoryMetadata;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.cluster.state.ClusterStateUpdateTask;
import io.skylite.core.index.shard.ShardId;
import io.skylite.core.index.snapshots.IndexShardSnapshotStatus;
import io.skylite.core.index.snapshots.blobstore.RemoteStoreShardShallowCopySnapshot;
import io.skylite.core.index.store.Store;
import io.skylite.core.index.store.remote.lockmanager.RemoteStoreLockManagerFactory;
import io.skylite.core.indices.recovery.RecoveryState;
import io.skylite.core.mapper.MapperService;
import io.skylite.core.repositories.IndexId;
import io.skylite.core.repositories.RepositoryData;
import io.skylite.core.repositories.RepositoryShardId;
import io.skylite.core.repositories.RepositoryStats;
import io.skylite.core.repositories.ShardGenerations;
import io.skylite.core.settings.Setting;
import io.skylite.core.snapshots.SnapshotId;
import io.skylite.core.snapshots.SnapshotInfo;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.lucene.index.IndexCommit;

public interface Repository
extends LifecycleComponent {
    public RepositoryMetadata getMetadata();

    public SnapshotInfo getSnapshotInfo(SnapshotId var1);

    public Metadata getSnapshotGlobalMetadata(SnapshotId var1);

    public IndexMetadata getSnapshotIndexMetaData(RepositoryData var1, SnapshotId var2, IndexId var3) throws IOException;

    public void getRepositoryData(ActionListener<RepositoryData> var1);

    public void finalizeSnapshot(ShardGenerations var1, long var2, Metadata var4, SnapshotInfo var5, Version<?> var6, Function<ClusterState, ClusterState> var7, ActionListener<RepositoryData> var8);

    public void deleteSnapshots(Collection<SnapshotId> var1, long var2, Version<?> var4, ActionListener<RepositoryData> var5);

    default public void deleteSnapshotsAndReleaseLockFiles(Collection<SnapshotId> snapshotIds, long repositoryStateId, Version repositoryMetaVersion, RemoteStoreLockManagerFactory remoteStoreLockManagerFactory, ActionListener<RepositoryData> listener) {
        throw new UnsupportedOperationException();
    }

    public long getSnapshotThrottleTimeInNanos();

    public long getRestoreThrottleTimeInNanos();

    public long getRemoteUploadThrottleTimeInNanos();

    public long getRemoteDownloadThrottleTimeInNanos();

    default public RepositoryStats stats() {
        return RepositoryStats.EMPTY_STATS;
    }

    public String startVerification();

    public void endVerification(String var1);

    public void verify(String var1, DiscoveryNode var2);

    public boolean isReadOnly();

    public boolean isSystemRepository();

    public void snapshotShard(Store var1, MapperService var2, SnapshotId var3, IndexId var4, IndexCommit var5, @Nullable String var6, IndexShardSnapshotStatus var7, Version var8, Map<String, Object> var9, ActionListener<String> var10);

    default public void snapshotRemoteStoreIndexShard(Store store, SnapshotId snapshotId, IndexId indexId, IndexCommit snapshotIndexCommit, @Nullable String shardStateIdentifier, IndexShardSnapshotStatus snapshotStatus, long primaryTerm, long startTime, ActionListener<String> listener) {
        throw new UnsupportedOperationException();
    }

    public void restoreShard(Store var1, SnapshotId var2, IndexId var3, ShardId var4, RecoveryState var5, ActionListener<Void> var6);

    default public List<Setting<?>> getRestrictedSystemRepositorySettings() {
        return Collections.emptyList();
    }

    default public RemoteStoreShardShallowCopySnapshot getRemoteStoreShallowCopyShardMetadata(SnapshotId snapshotId, IndexId indexId, ShardId snapshotShardId) {
        throw new UnsupportedOperationException();
    }

    public IndexShardSnapshotStatus getShardSnapshotStatus(SnapshotId var1, IndexId var2, ShardId var3);

    public void updateState(ClusterState var1);

    public void executeConsistentStateUpdate(Function<RepositoryData, ClusterStateUpdateTask> var1, String var2, Consumer<Exception> var3);

    public void cloneShardSnapshot(SnapshotId var1, SnapshotId var2, RepositoryShardId var3, @Nullable String var4, ActionListener<String> var5);

    default public void cloneRemoteStoreIndexShardSnapshot(SnapshotId source, SnapshotId target, RepositoryShardId shardId, @Nullable String shardGeneration, RemoteStoreLockManagerFactory remoteStoreLockManagerFactory, ActionListener<String> listener) {
        throw new UnsupportedOperationException();
    }

    default public Map<String, Object> adaptUserMetadata(Map<String, Object> userMetadata) {
        return userMetadata;
    }

    default public boolean isReloadable() {
        return false;
    }

    default public void reload(RepositoryMetadata repositoryMetadata) {
    }

    default public void validateMetadata(RepositoryMetadata repositoryMetadata) {
    }

    public static interface Factory {
        public Repository create(RepositoryMetadata var1) throws Exception;

        default public Repository create(RepositoryMetadata metadata, Function<String, Factory> typeLookup) throws Exception {
            return this.create(metadata);
        }
    }
}

