/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.repositories;

import io.skylite.common.blobstore.DeleteResult;
import io.skylite.core.ParseField;
import io.skylite.core.common.Strings;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.ObjectParser;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;

public final class RepositoryCleanupResult
implements Writeable,
ToXContentObject {
    public static final ObjectParser<RepositoryCleanupResult, Void> PARSER = new ObjectParser(RepositoryCleanupResult.class.getName(), true, RepositoryCleanupResult::new);
    private static final String DELETED_BLOBS = "deleted_blobs";
    private static final String DELETED_BYTES = "deleted_bytes";
    private long bytes;
    private long blobs;

    private RepositoryCleanupResult() {
        this(DeleteResult.ZERO);
    }

    public RepositoryCleanupResult(DeleteResult result) {
        this.blobs = result.blobsDeleted();
        this.bytes = result.bytesDeleted();
    }

    public RepositoryCleanupResult(StreamInput in) throws IOException {
        this.bytes = in.readLong();
        this.blobs = in.readLong();
    }

    public long bytes() {
        return this.bytes;
    }

    public long blobs() {
        return this.blobs;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeLong(this.bytes);
        out.writeLong(this.blobs);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.startObject().field(DELETED_BYTES, this.bytes).field(DELETED_BLOBS, this.blobs).endObject();
    }

    public String toString() {
        return Strings.toString(MediaTypeRegistry.JSON, this);
    }

    static {
        PARSER.declareLong((result, bytes) -> {
            result.bytes = bytes;
        }, new ParseField(DELETED_BYTES, new String[0]));
        PARSER.declareLong((result, blobs) -> {
            result.blobs = blobs;
        }, new ParseField(DELETED_BLOBS, new String[0]));
    }
}

