/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.repositories;

import io.skylite.core.common.Strings;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentFragment;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;

public final class RepositoryInfo
implements Writeable,
ToXContentFragment {
    public final String name;
    public final String type;
    public final Map<String, String> location;

    public RepositoryInfo(String name, String type, Map<String, String> location) {
        this.name = name;
        this.type = type;
        this.location = location;
    }

    public RepositoryInfo(StreamInput in) throws IOException {
        this.name = in.readString();
        this.type = in.readString();
        this.location = in.readMap(StreamInput::readString, StreamInput::readString);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeString(this.type);
        out.writeMap(this.location, StreamOutput::writeString, StreamOutput::writeString);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("repository_name", this.name);
        builder.field("repository_type", this.type);
        builder.field("repository_location", (Object)this.location);
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RepositoryInfo that = (RepositoryInfo)o;
        return this.name.equals(that.name) && this.type.equals(that.type) && this.location.equals(that.location);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type, this.location);
    }

    public String toString() {
        return Strings.toString(MediaTypeRegistry.JSON, this);
    }
}

