/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.repositories;

import io.skylite.core.common.Strings;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.repositories.RepositoryInfo;
import io.skylite.core.repositories.RepositoryStats;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;
import java.util.Objects;

public final class RepositoryStatsSnapshot
implements Writeable,
ToXContentObject {
    public static final long UNKNOWN_CLUSTER_VERSION = -1L;
    private final RepositoryInfo repositoryInfo;
    private final RepositoryStats repositoryStats;
    private final long clusterVersion;

    public RepositoryStatsSnapshot(RepositoryInfo repositoryInfo, RepositoryStats repositoryStats, long clusterVersion) {
        this.repositoryInfo = repositoryInfo;
        this.repositoryStats = repositoryStats;
        this.clusterVersion = clusterVersion;
    }

    public RepositoryStatsSnapshot(StreamInput in) throws IOException {
        this.repositoryInfo = new RepositoryInfo(in);
        this.repositoryStats = new RepositoryStats(in);
        this.clusterVersion = in.readLong();
    }

    public RepositoryInfo getRepositoryInfo() {
        return this.repositoryInfo;
    }

    public RepositoryStats getRepositoryStats() {
        return this.repositoryStats;
    }

    public long getClusterVersion() {
        return this.clusterVersion;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.repositoryInfo.writeTo(out);
        this.repositoryStats.writeTo(out);
        out.writeLong(this.clusterVersion);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.repositoryInfo.toXContent(builder, params);
        this.repositoryStats.toXContent(builder, params);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RepositoryStatsSnapshot that = (RepositoryStatsSnapshot)o;
        return this.repositoryInfo.equals(that.repositoryInfo) && this.repositoryStats.equals(that.repositoryStats) && this.clusterVersion == that.clusterVersion;
    }

    public int hashCode() {
        return Objects.hash(this.repositoryInfo, this.repositoryStats, this.clusterVersion);
    }

    public String toString() {
        return Strings.toString(MediaTypeRegistry.JSON, this);
    }
}

