/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.repositories.blobstore;

import io.skylite.SkyliteExceptionsHelper;
import io.skylite.Version;
import io.skylite.common.ExceptionsHelper;
import io.skylite.common.Nullable;
import io.skylite.common.Numbers;
import io.skylite.common.SetOnce;
import io.skylite.common.UUIDs;
import io.skylite.common.action.ActionListener;
import io.skylite.common.action.ActionRunnable;
import io.skylite.common.blobstore.BlobContainer;
import io.skylite.common.blobstore.BlobMetadata;
import io.skylite.common.blobstore.BlobPath;
import io.skylite.common.blobstore.DeleteResult;
import io.skylite.common.collect.Tuple;
import io.skylite.common.lease.Releasable;
import io.skylite.common.lifecycle.AbstractLifecycleComponent;
import io.skylite.common.metrics.CounterMetric;
import io.skylite.common.unit.TimeValue;
import io.skylite.common.util.concurrent.AbstractRunnable;
import io.skylite.common.util.concurrent.ConcurrentCollections;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.GroupedActionListener;
import io.skylite.core.action.StepListener;
import io.skylite.core.blobstore.BlobStore;
import io.skylite.core.blobstore.EncryptedBlobStore;
import io.skylite.core.blobstore.fs.FsBlobContainer;
import io.skylite.core.blobstore.transfer.stream.OffsetRangeInputStream;
import io.skylite.core.blobstore.transfer.stream.RateLimitingOffsetRangeInputStream;
import io.skylite.core.cluster.RepositoryCleanupInProgress;
import io.skylite.core.cluster.SnapshotDeletionsInProgress;
import io.skylite.core.cluster.SnapshotsInProgress;
import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.cluster.metadata.Metadata;
import io.skylite.core.cluster.metadata.RepositoriesMetadata;
import io.skylite.core.cluster.metadata.RepositoryMetadata;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.cluster.service.ClusterManagerTaskThrottler;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.cluster.state.ClusterStateUpdateTask;
import io.skylite.core.common.Strings;
import io.skylite.core.common.bytes.BytesArray;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.common.io.Streams;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.unit.ByteSizeUnit;
import io.skylite.core.common.unit.ByteSizeValue;
import io.skylite.core.common.util.CollectionUtils;
import io.skylite.core.compress.Compressor;
import io.skylite.core.compress.CompressorRegistry;
import io.skylite.core.compress.DeflateCompressor;
import io.skylite.core.compress.NotXContentException;
import io.skylite.core.index.remote.RemoteStorePathStrategy;
import io.skylite.core.index.shard.ShardId;
import io.skylite.core.index.snapshots.IndexShardRestoreFailedException;
import io.skylite.core.index.snapshots.IndexShardSnapshotFailedException;
import io.skylite.core.index.snapshots.IndexShardSnapshotStatus;
import io.skylite.core.index.snapshots.blobstore.BlobStoreIndexShardSnapshot;
import io.skylite.core.index.snapshots.blobstore.BlobStoreIndexShardSnapshots;
import io.skylite.core.index.snapshots.blobstore.IndexShardSnapshot;
import io.skylite.core.index.snapshots.blobstore.RateLimitingInputStream;
import io.skylite.core.index.snapshots.blobstore.RemoteStoreShardShallowCopySnapshot;
import io.skylite.core.index.snapshots.blobstore.SlicedInputStream;
import io.skylite.core.index.snapshots.blobstore.SnapshotFiles;
import io.skylite.core.index.store.Store;
import io.skylite.core.index.store.StoreFileMetadata;
import io.skylite.core.index.store.remote.RemoteSegmentStoreDirectory;
import io.skylite.core.index.store.remote.RemoteSegmentStoreDirectoryFactory;
import io.skylite.core.index.store.remote.lockmanager.FileLockInfo;
import io.skylite.core.index.store.remote.lockmanager.RemoteStoreLockManager;
import io.skylite.core.index.store.remote.lockmanager.RemoteStoreLockManagerFactory;
import io.skylite.core.indices.recovery.RecoverySettings;
import io.skylite.core.indices.recovery.RecoveryState;
import io.skylite.core.lucene.Lucene;
import io.skylite.core.lucene.store.InputStreamIndexInput;
import io.skylite.core.mapper.MapperService;
import io.skylite.core.repositories.IndexId;
import io.skylite.core.repositories.IndexMetadataGenerations;
import io.skylite.core.repositories.Repository;
import io.skylite.core.repositories.RepositoryCleanupResult;
import io.skylite.core.repositories.RepositoryData;
import io.skylite.core.repositories.RepositoryException;
import io.skylite.core.repositories.RepositoryOperation;
import io.skylite.core.repositories.RepositoryShardId;
import io.skylite.core.repositories.RepositoryStats;
import io.skylite.core.repositories.RepositoryVerificationException;
import io.skylite.core.repositories.ShardGenerations;
import io.skylite.core.repositories.blobstore.BlobStoreRepositorySettings;
import io.skylite.core.repositories.blobstore.ChecksumBlobStoreFormat;
import io.skylite.core.repositories.blobstore.FileRestoreContext;
import io.skylite.core.repositories.blobstore.RemoteStoreShardCleanupTask;
import io.skylite.core.settings.Setting;
import io.skylite.core.settings.Settings;
import io.skylite.core.snapshots.AbortedSnapshotException;
import io.skylite.core.snapshots.SnapshotException;
import io.skylite.core.snapshots.SnapshotId;
import io.skylite.core.snapshots.SnapshotInfo;
import io.skylite.core.snapshots.SnapshotMissingException;
import io.skylite.core.snapshots.SnapshotsService;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.util.BytesRefUtils;
import io.skylite.core.xcontent.DeprecationHandler;
import io.skylite.core.xcontent.LoggingDeprecationHandler;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.XContentParser;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexFormatTooNewException;
import org.apache.lucene.index.IndexFormatTooOldException;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.RateLimiter;
import org.apache.lucene.util.BytesRef;

public abstract class BlobStoreRepository
extends AbstractLifecycleComponent
implements Repository {
    private static final Logger logger = LogManager.getLogger(BlobStoreRepository.class);
    protected volatile RepositoryMetadata metadata;
    protected final ThreadPool threadPool;
    public static final String SNAPSHOT_PREFIX = "snap-";
    public static final String SHALLOW_SNAPSHOT_PREFIX = "shallow-snap-";
    public static final String INDEX_FILE_PREFIX = "index-";
    public static final String INDEX_LATEST_BLOB = "index.latest";
    private static final String TESTS_FILE = "tests-";
    public static final String METADATA_PREFIX = "meta-";
    public static final String METADATA_NAME_FORMAT = "meta-%s.dat";
    public static final String SNAPSHOT_NAME_FORMAT = "snap-%s.dat";
    public static final String SHALLOW_SNAPSHOT_NAME_FORMAT = "shallow-snap-%s.dat";
    private static final String SNAPSHOT_INDEX_PREFIX = "index-";
    private static final String SNAPSHOT_INDEX_NAME_FORMAT = "index-%s";
    private static final String UPLOADED_DATA_BLOB_PREFIX = "__";
    public static final String VIRTUAL_DATA_BLOB_PREFIX = "v__";
    public static final Setting<Compressor> COMPRESSION_TYPE_SETTING = new Setting<Compressor>("compression_type", DeflateCompressor.NAME.toLowerCase(Locale.ROOT), s -> CompressorRegistry.getCompressor(s.toUpperCase(Locale.ROOT)), Setting.Property.NodeScope);
    protected volatile boolean supportURLRepo;
    private volatile int maxShardBlobDeleteBatch;
    private volatile Compressor compressor;
    private volatile boolean cacheRepositoryData;
    private volatile RateLimiter snapshotRateLimiter;
    private volatile RateLimiter restoreRateLimiter;
    private volatile RateLimiter remoteUploadRateLimiter;
    private volatile RateLimiter remoteDownloadRateLimiter;
    private final CounterMetric snapshotRateLimitingTimeInNanos = new CounterMetric();
    private final CounterMetric restoreRateLimitingTimeInNanos = new CounterMetric();
    private final CounterMetric remoteDownloadRateLimitingTimeInNanos = new CounterMetric();
    private final CounterMetric remoteUploadRateLimitingTimeInNanos = new CounterMetric();
    public static final ChecksumBlobStoreFormat<Metadata> GLOBAL_METADATA_FORMAT = new ChecksumBlobStoreFormat("metadata", "meta-%s.dat", Metadata::fromXContent);
    public static final ChecksumBlobStoreFormat<IndexMetadata> INDEX_METADATA_FORMAT = new ChecksumBlobStoreFormat("index-metadata", "meta-%s.dat", IndexMetadata::fromXContent);
    private static final String SNAPSHOT_CODEC = "snapshot";
    public static final ChecksumBlobStoreFormat<SnapshotInfo> SNAPSHOT_FORMAT = new ChecksumBlobStoreFormat("snapshot", "snap-%s.dat", SnapshotInfo::fromXContentInternal);
    public static final ChecksumBlobStoreFormat<BlobStoreIndexShardSnapshot> INDEX_SHARD_SNAPSHOT_FORMAT = new ChecksumBlobStoreFormat("snapshot", "snap-%s.dat", BlobStoreIndexShardSnapshot::fromXContent);
    public static final ChecksumBlobStoreFormat<RemoteStoreShardShallowCopySnapshot> REMOTE_STORE_SHARD_SHALLOW_COPY_SNAPSHOT_FORMAT = new ChecksumBlobStoreFormat("snapshot", "shallow-snap-%s.dat", RemoteStoreShardShallowCopySnapshot::fromXContent);
    public static final ChecksumBlobStoreFormat<BlobStoreIndexShardSnapshots> INDEX_SHARD_SNAPSHOTS_FORMAT = new ChecksumBlobStoreFormat("snapshots", "index-%s", BlobStoreIndexShardSnapshots::fromXContent);
    private volatile boolean readOnly;
    private final boolean isSystemRepository;
    private final Object lock = new Object();
    private final SetOnce<BlobContainer> blobContainer = new SetOnce();
    private final SetOnce<BlobStore> blobStore = new SetOnce();
    protected final ClusterService clusterService;
    private final RecoverySettings recoverySettings;
    private final NamedXContentRegistry namedXContentRegistry;
    private boolean uncleanStart;
    private volatile boolean bestEffortConsistency;
    protected volatile int bufferSize;
    private final AtomicLong latestKnownRepoGen = new AtomicLong(-2L);
    private final AtomicReference<Tuple<Long, BytesReference>> latestKnownRepositoryData = new AtomicReference();

    protected BlobStoreRepository(RepositoryMetadata repositoryMetadata, NamedXContentRegistry namedXContentRegistry, ClusterService clusterService, RecoverySettings recoverySettings) {
        this.readRepositoryMetadata(repositoryMetadata);
        this.isSystemRepository = BlobStoreRepositorySettings.SYSTEM_REPOSITORY_SETTING.get(this.metadata.settings());
        this.namedXContentRegistry = namedXContentRegistry;
        this.threadPool = clusterService.getClusterApplierService().threadPool();
        this.clusterService = clusterService;
        this.recoverySettings = recoverySettings;
    }

    @Override
    public void reload(RepositoryMetadata repositoryMetadata) {
        this.readRepositoryMetadata(repositoryMetadata);
    }

    private void readRepositoryMetadata(RepositoryMetadata repositoryMetadata) {
        this.metadata = repositoryMetadata;
        this.supportURLRepo = BlobStoreRepositorySettings.SUPPORT_URL_REPO.get(this.metadata.settings());
        this.snapshotRateLimiter = this.getRateLimiter(this.metadata.settings(), "max_snapshot_bytes_per_sec", new ByteSizeValue(40L, ByteSizeUnit.MB));
        this.restoreRateLimiter = this.getRateLimiter(this.metadata.settings(), "max_restore_bytes_per_sec", ByteSizeValue.ZERO);
        this.remoteUploadRateLimiter = this.getRateLimiter(this.metadata.settings(), "max_remote_upload_bytes_per_sec", ByteSizeValue.ZERO);
        this.remoteDownloadRateLimiter = this.getRateLimiter(this.metadata.settings(), "max_remote_download_bytes_per_sec", ByteSizeValue.ZERO);
        this.readOnly = BlobStoreRepositorySettings.READONLY_SETTING.get(this.metadata.settings());
        this.cacheRepositoryData = BlobStoreRepositorySettings.CACHE_REPOSITORY_DATA.get(this.metadata.settings());
        this.bufferSize = Math.toIntExact(BlobStoreRepositorySettings.BUFFER_SIZE_SETTING.get(this.metadata.settings()).getBytes());
        this.maxShardBlobDeleteBatch = BlobStoreRepositorySettings.MAX_SNAPSHOT_SHARD_BLOB_DELETE_BATCH_SIZE.get(this.metadata.settings());
        this.compressor = BlobStoreRepositorySettings.COMPRESS_SETTING.get(this.metadata.settings()) != false ? COMPRESSION_TYPE_SETTING.get(this.metadata.settings()) : CompressorRegistry.none();
    }

    protected void doStart() {
        this.uncleanStart = this.metadata.pendingGeneration() > -1L && this.metadata.generation() != this.metadata.pendingGeneration();
        ByteSizeValue chunkSize = this.chunkSize();
        if (chunkSize != null && chunkSize.getBytes() <= 0L) {
            throw new IllegalArgumentException("the chunk size cannot be negative: [" + String.valueOf(chunkSize) + "]");
        }
    }

    protected void doStop() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doClose() {
        BlobStore store;
        Object object = this.lock;
        synchronized (object) {
            store = (BlobStore)this.blobStore.get();
        }
        if (store != null) {
            try {
                store.close();
            }
            catch (Exception t) {
                logger.warn("cannot close blob store", (Throwable)t);
            }
        }
    }

    @Override
    public void executeConsistentStateUpdate(final Function<RepositoryData, ClusterStateUpdateTask> createUpdateTask, String source, final Consumer<Exception> onFailure) {
        final RepositoryMetadata repositoryMetadataStart = this.metadata;
        this.getRepositoryData(ActionListenerHelper.wrap(repositoryData -> {
            final ClusterStateUpdateTask updateTask = (ClusterStateUpdateTask)createUpdateTask.apply((RepositoryData)repositoryData);
            this.clusterService.submitStateUpdateTask(source, new ClusterStateUpdateTask(updateTask.priority()){
                private boolean executedTask;
                {
                    super(priority);
                    this.executedTask = false;
                }

                @Override
                public ClusterState execute(ClusterState currentState) throws Exception {
                    if (repositoryMetadataStart.equals(BlobStoreRepository.this.getRepoMetadata(currentState))) {
                        this.executedTask = true;
                        return updateTask.execute(currentState);
                    }
                    return currentState;
                }

                @Override
                public void onFailure(String source, Exception e) {
                    if (this.executedTask) {
                        updateTask.onFailure(source, e);
                    } else {
                        onFailure.accept(e);
                    }
                }

                @Override
                public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                    if (this.executedTask) {
                        updateTask.clusterStateProcessed(source, oldState, newState);
                    } else {
                        BlobStoreRepository.this.executeConsistentStateUpdate(createUpdateTask, source, onFailure);
                    }
                }

                @Override
                public TimeValue timeout() {
                    return updateTask.timeout();
                }

                @Override
                public ClusterManagerTaskThrottler.ThrottlingKey getClusterManagerThrottlingKey() {
                    return updateTask.getClusterManagerThrottlingKey();
                }
            });
        }, onFailure));
    }

    @Override
    public void cloneShardSnapshot(SnapshotId source, SnapshotId target, RepositoryShardId shardId, @Nullable String shardGeneration, ActionListener<String> listener) {
        if (this.isReadOnly()) {
            listener.onFailure((Exception)new RepositoryException(this.metadata.name(), "cannot clone shard snapshot on a readonly repository"));
            return;
        }
        IndexId index = shardId.index();
        int shardNum = shardId.shardId();
        ExecutorService executor = this.threadPool.executor(SNAPSHOT_CODEC);
        executor.execute((Runnable)ActionRunnable.supply(listener, () -> {
            BlobStoreIndexShardSnapshots existingSnapshots;
            String newGen;
            String existingShardGen;
            long startTime = this.threadPool.absoluteTimeInMillis();
            BlobContainer shardContainer = this.shardContainer(index, shardNum);
            if (shardGeneration == null) {
                Tuple<BlobStoreIndexShardSnapshots, Long> tuple = this.buildBlobStoreIndexShardSnapshots(shardContainer.listBlobsByPrefix("index-").keySet(), shardContainer);
                existingShardGen = String.valueOf(tuple.v2());
                newGen = String.valueOf((Long)tuple.v2() + 1L);
                existingSnapshots = (BlobStoreIndexShardSnapshots)tuple.v1();
            } else {
                newGen = UUIDs.randomBase64UUID();
                existingSnapshots = (BlobStoreIndexShardSnapshots)this.buildBlobStoreIndexShardSnapshots(Collections.emptySet(), shardContainer, shardGeneration).v1();
                existingShardGen = shardGeneration;
            }
            SnapshotFiles existingTargetFiles = null;
            SnapshotFiles sourceFiles = null;
            for (SnapshotFiles existingSnapshot : existingSnapshots) {
                String snapshotName = existingSnapshot.snapshot();
                if (snapshotName.equals(target.getName())) {
                    existingTargetFiles = existingSnapshot;
                } else if (snapshotName.equals(source.getName())) {
                    sourceFiles = existingSnapshot;
                }
                if (sourceFiles == null || existingTargetFiles == null) continue;
                break;
            }
            if (sourceFiles == null) {
                throw new RepositoryException(this.metadata.name(), "Can't create clone of [" + String.valueOf(shardId) + "] for snapshot [" + String.valueOf(target) + "]. The source snapshot [" + String.valueOf(source) + "] was not found in the shard metadata.");
            }
            if (existingTargetFiles != null) {
                if (existingTargetFiles.isSame(sourceFiles)) {
                    return existingShardGen;
                }
                throw new RepositoryException(this.metadata.name(), "Can't create clone of [" + String.valueOf(shardId) + "] for snapshot [" + String.valueOf(target) + "]. A snapshot by that name already exists for this shard.");
            }
            IndexShardSnapshot indexShardSnapshot = this.loadShardSnapshot(shardContainer, source);
            assert (indexShardSnapshot instanceof BlobStoreIndexShardSnapshot) : "indexShardSnapshot should be an instance of BlobStoreIndexShardSnapshot";
            BlobStoreIndexShardSnapshot sourceMeta = (BlobStoreIndexShardSnapshot)indexShardSnapshot;
            logger.trace("[{}] [{}] writing shard snapshot file for clone", (Object)shardId, (Object)target);
            INDEX_SHARD_SNAPSHOT_FORMAT.write(sourceMeta.asClone(target.getName(), startTime, this.threadPool.absoluteTimeInMillis() - startTime), shardContainer, target.getUUID(), this.compressor);
            INDEX_SHARD_SNAPSHOTS_FORMAT.write(existingSnapshots.withClone(source.getName(), target.getName()), shardContainer, newGen, this.compressor);
            return newGen;
        }));
    }

    @Override
    public void cloneRemoteStoreIndexShardSnapshot(SnapshotId source, SnapshotId target, RepositoryShardId shardId, @Nullable String shardGeneration, RemoteStoreLockManagerFactory remoteStoreLockManagerFactory, ActionListener<String> listener) {
        if (this.isReadOnly()) {
            listener.onFailure((Exception)new RepositoryException(this.metadata.name(), "cannot clone shard snapshot on a readonly repository"));
            return;
        }
        IndexId index = shardId.index();
        int shardNum = shardId.shardId();
        ExecutorService executor = this.threadPool.executor(SNAPSHOT_CODEC);
        executor.execute((Runnable)ActionRunnable.supply(listener, () -> {
            long startTime = this.threadPool.relativeTimeInMillis();
            BlobContainer shardContainer = this.shardContainer(index, shardNum);
            IndexShardSnapshot indexShardSnapshot = this.loadShardSnapshot(shardContainer, source);
            assert (indexShardSnapshot instanceof RemoteStoreShardShallowCopySnapshot) : "indexShardSnapshot should be an instance of RemoteStoreShardShallowCopySnapshot";
            RemoteStoreShardShallowCopySnapshot remStoreBasedShardMetadata = (RemoteStoreShardShallowCopySnapshot)indexShardSnapshot;
            String indexUUID = remStoreBasedShardMetadata.getIndexUUID();
            String remoteStoreRepository = remStoreBasedShardMetadata.getRemoteStoreRepository();
            RemoteStoreLockManager remoteStoreMetadataLockManger = remoteStoreLockManagerFactory.newLockManager(remoteStoreRepository, indexUUID, String.valueOf(shardId.shardId()), remStoreBasedShardMetadata.getRemoteStorePathStrategy());
            remoteStoreMetadataLockManger.cloneLock(FileLockInfo.getLockInfoBuilder().withAcquirerId(source.getUUID()).build(), FileLockInfo.getLockInfoBuilder().withAcquirerId(target.getUUID()).build());
            REMOTE_STORE_SHARD_SHALLOW_COPY_SNAPSHOT_FORMAT.write(remStoreBasedShardMetadata.asClone(target.getName(), startTime, this.threadPool.absoluteTimeInMillis() - startTime), shardContainer, target.getUUID(), this.compressor);
            return shardGeneration;
        }));
    }

    @Override
    public void updateState(ClusterState state) {
        this.metadata = this.getRepoMetadata(state);
        this.uncleanStart = this.uncleanStart && this.metadata.generation() != this.metadata.pendingGeneration();
        boolean wasBestEffortConsistency = this.bestEffortConsistency;
        boolean bl = this.bestEffortConsistency = this.uncleanStart || this.isReadOnly() || this.metadata.generation() == -2L || BlobStoreRepositorySettings.ALLOW_CONCURRENT_MODIFICATION.get(this.metadata.settings()) != false;
        if (this.isReadOnly()) {
            return;
        }
        if (this.bestEffortConsistency) {
            SnapshotsInProgress snapshotsInProgress = state.custom("snapshots", SnapshotsInProgress.EMPTY);
            long bestGenerationFromCS = this.bestGeneration(snapshotsInProgress.entries());
            if (bestGenerationFromCS == -1L) {
                bestGenerationFromCS = this.bestGeneration(state.custom("snapshot_deletions", SnapshotDeletionsInProgress.EMPTY).getEntries());
            }
            if (bestGenerationFromCS == -1L) {
                bestGenerationFromCS = this.bestGeneration(state.custom("repository_cleanup", RepositoryCleanupInProgress.EMPTY).entries());
            }
            long finalBestGen = Math.max(bestGenerationFromCS, this.metadata.generation());
            this.latestKnownRepoGen.updateAndGet(known -> Math.max(known, finalBestGen));
        } else {
            long previousBest = this.latestKnownRepoGen.getAndSet(this.metadata.generation());
            if (previousBest != this.metadata.generation()) {
                assert (wasBestEffortConsistency || this.metadata.generation() == -3L || previousBest < this.metadata.generation()) : "Illegal move from repository generation [" + previousBest + "] to generation [" + this.metadata.generation() + "]";
                logger.debug("Updated repository generation from [{}] to [{}]", (Object)previousBest, (Object)this.metadata.generation());
            }
        }
    }

    private long bestGeneration(Collection<? extends RepositoryOperation> operations) {
        String repoName = this.metadata.name();
        return operations.stream().filter(e -> e.repository().equals(repoName)).mapToLong(RepositoryOperation::repositoryStateId).max().orElse(-1L);
    }

    public ThreadPool threadPool() {
        return this.threadPool;
    }

    public BlobContainer getBlobContainer() {
        return (BlobContainer)this.blobContainer.get();
    }

    public BlobStore getBlobStore() {
        return (BlobStore)this.blobStore.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlobContainer blobContainer() {
        this.assertSnapshotOrGenericThread();
        BlobContainer blobContainer = (BlobContainer)this.blobContainer.get();
        if (blobContainer == null) {
            Object object = this.lock;
            synchronized (object) {
                blobContainer = (BlobContainer)this.blobContainer.get();
                if (blobContainer == null) {
                    blobContainer = this.blobStore().blobContainer(this.basePath());
                    this.blobContainer.set((Object)blobContainer);
                }
            }
        }
        return blobContainer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlobStore blobStore() {
        BlobStore store = (BlobStore)this.blobStore.get();
        if (store == null) {
            Object object = this.lock;
            synchronized (object) {
                store = (BlobStore)this.blobStore.get();
                if (store == null) {
                    if (!this.lifecycle.started()) {
                        throw new RepositoryException(this.metadata.name(), "repository is not in started state");
                    }
                    try {
                        store = this.createBlobStore();
                        if (this.metadata.cryptoMetadata() != null) {
                            store = new EncryptedBlobStore(store, this.metadata.cryptoMetadata());
                        }
                    }
                    catch (RepositoryException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new RepositoryException(this.metadata.name(), "cannot create blob store", e);
                    }
                    this.blobStore.set((Object)store);
                }
            }
        }
        return store;
    }

    protected abstract BlobStore createBlobStore() throws Exception;

    public abstract BlobPath basePath();

    protected final boolean isCompress() {
        return this.compressor != CompressorRegistry.none();
    }

    protected ByteSizeValue chunkSize() {
        return null;
    }

    @Override
    public RepositoryMetadata getMetadata() {
        return this.metadata;
    }

    public NamedXContentRegistry getNamedXContentRegistry() {
        return this.namedXContentRegistry;
    }

    public Compressor getCompressor() {
        return this.compressor;
    }

    @Override
    public RepositoryStats stats() {
        BlobStore store = (BlobStore)this.blobStore.get();
        if (store == null) {
            return RepositoryStats.EMPTY_STATS;
        }
        if (store.extendedStats() != null && !store.extendedStats().isEmpty()) {
            return new RepositoryStats(store.extendedStats(), true);
        }
        return new RepositoryStats(store.stats());
    }

    @Override
    public void deleteSnapshotsAndReleaseLockFiles(final Collection<SnapshotId> snapshotIds, final long repositoryStateId, final Version repositoryMetaVersion, final RemoteStoreLockManagerFactory remoteStoreLockManagerFactory, final ActionListener<RepositoryData> listener) {
        if (this.isReadOnly()) {
            listener.onFailure((Exception)new RepositoryException(this.metadata.name(), "cannot delete snapshot from a readonly repository"));
        } else {
            this.threadPool.executor(SNAPSHOT_CODEC).execute((Runnable)new AbstractRunnable(){

                public void doRun() throws Exception {
                    Map rootBlobs = BlobStoreRepository.this.blobContainer().listBlobs();
                    RepositoryData repositoryData = BlobStoreRepository.this.safeRepositoryData(repositoryStateId, rootBlobs);
                    Map foundIndices = BlobStoreRepository.this.blobStore().blobContainer(BlobStoreRepository.this.indicesPath()).children();
                    BlobStoreRepository.this.doDeleteShardSnapshots(snapshotIds, repositoryStateId, foundIndices, rootBlobs, repositoryData, repositoryMetaVersion, remoteStoreLockManagerFactory, (ActionListener<RepositoryData>)listener);
                }

                public void onFailure(Exception e) {
                    listener.onFailure((Exception)new RepositoryException(BlobStoreRepository.this.metadata.name(), "failed to delete snapshots " + String.valueOf(snapshotIds), e));
                }
            });
        }
    }

    @Override
    public void deleteSnapshots(Collection<SnapshotId> snapshotIds, long repositoryStateId, Version<?> repositoryMetaVersion, ActionListener<RepositoryData> listener) {
        this.deleteSnapshotsAndReleaseLockFiles(snapshotIds, repositoryStateId, repositoryMetaVersion, null, listener);
    }

    private RepositoryData safeRepositoryData(long repositoryStateId, Map<String, BlobMetadata> rootBlobs) throws IOException {
        Tuple<Long, BytesReference> cached;
        long genToLoad;
        long generation = this.latestGeneration(rootBlobs.keySet());
        if (this.bestEffortConsistency) {
            genToLoad = this.latestKnownRepoGen.updateAndGet(known -> Math.max(known, repositoryStateId));
            cached = null;
        } else {
            genToLoad = this.latestKnownRepoGen.get();
            cached = this.latestKnownRepositoryData.get();
        }
        if (genToLoad > generation) {
            logger.debug("Determined repository's generation from its contents to [" + generation + "] but current generation is at least [" + genToLoad + "]");
        }
        if (genToLoad != repositoryStateId) {
            throw new RepositoryException(this.metadata.name(), "concurrent modification of the index-N file, expected current generation [" + repositoryStateId + "], actual current generation [" + genToLoad + "]");
        }
        if (cached != null && (Long)cached.v1() == genToLoad) {
            return this.repositoryDataFromCachedEntry(cached);
        }
        return this.getRepositoryData(genToLoad);
    }

    private void doDeleteShardSnapshots(Collection<SnapshotId> snapshotIds, long repositoryStateId, Map<String, BlobContainer> foundIndices, Map<String, BlobMetadata> rootBlobs, RepositoryData repositoryData, Version repoMetaVersion, RemoteStoreLockManagerFactory remoteStoreLockManagerFactory, ActionListener<RepositoryData> listener) {
        StepListener writeShardMetaDataAndComputeDeletesStep = new StepListener();
        this.writeUpdatedShardMetaDataAndComputeDeletes(snapshotIds, repositoryData, true, remoteStoreLockManagerFactory, (ActionListener<Collection<ShardSnapshotMetaDeleteResult>>)writeShardMetaDataAndComputeDeletesStep);
        StepListener writeUpdatedRepoDataStep = new StepListener();
        writeShardMetaDataAndComputeDeletesStep.whenComplete(deleteResults -> {
            ShardGenerations.Builder builder = ShardGenerations.builder();
            for (ShardSnapshotMetaDeleteResult newGen : deleteResults) {
                builder.put(newGen.indexId, newGen.shardId, newGen.newGeneration);
            }
            RepositoryData updatedRepoData = repositoryData.removeSnapshots(snapshotIds, builder.build());
            this.writeIndexGen(updatedRepoData, repositoryStateId, repoMetaVersion, Function.identity(), ActionListenerHelper.wrap(arg_0 -> ((StepListener)writeUpdatedRepoDataStep).onResponse(arg_0), arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
        }, arg_0 -> listener.onFailure(arg_0));
        writeUpdatedRepoDataStep.whenComplete(updatedRepoData -> {
            GroupedActionListener<Void> afterCleanupsListener = new GroupedActionListener<Void>(ActionListenerHelper.wrap(() -> listener.onResponse(updatedRepoData)), 2);
            this.cleanupUnlinkedRootAndIndicesBlobs(snapshotIds, foundIndices, rootBlobs, (RepositoryData)updatedRepoData, remoteStoreLockManagerFactory, (ActionListener<Void>)afterCleanupsListener);
            this.asyncCleanupUnlinkedShardLevelBlobs(repositoryData, snapshotIds, (Collection)writeShardMetaDataAndComputeDeletesStep.result(), remoteStoreLockManagerFactory, afterCleanupsListener);
        }, arg_0 -> listener.onFailure(arg_0));
    }

    private void cleanupUnlinkedRootAndIndicesBlobs(Collection<SnapshotId> deletedSnapshots, Map<String, BlobContainer> foundIndices, Map<String, BlobMetadata> rootBlobs, RepositoryData updatedRepoData, RemoteStoreLockManagerFactory remoteStoreLockManagerFactory, ActionListener<Void> listener) {
        this.cleanupStaleBlobs(deletedSnapshots, foundIndices, rootBlobs, updatedRepoData, remoteStoreLockManagerFactory, ActionListenerHelper.map(listener, ignored -> null));
    }

    private void asyncCleanupUnlinkedShardLevelBlobs(RepositoryData oldRepositoryData, Collection<SnapshotId> snapshotIds, Collection<ShardSnapshotMetaDeleteResult> deleteResults, RemoteStoreLockManagerFactory remoteStoreLockManagerFactory, ActionListener<Void> listener) {
        List<String> filesToDelete = this.resolveFilesToDelete(oldRepositoryData, snapshotIds, deleteResults);
        if (filesToDelete.isEmpty()) {
            listener.onResponse(null);
            return;
        }
        try {
            AtomicInteger counter = new AtomicInteger();
            Collection<List<String>> subList = filesToDelete.stream().collect(Collectors.groupingBy(it -> counter.getAndIncrement() / this.maxShardBlobDeleteBatch)).values();
            LinkedBlockingQueue<List<String>> staleFilesToDeleteInBatch = new LinkedBlockingQueue<List<String>>(subList);
            GroupedActionListener<Void> groupedListener = new GroupedActionListener<Void>(ActionListenerHelper.wrap(r -> listener.onResponse(null), arg_0 -> listener.onFailure(arg_0)), staleFilesToDeleteInBatch.size());
            int workers = Math.min(this.threadPool.info(SNAPSHOT_CODEC).getMax(), staleFilesToDeleteInBatch.size());
            for (int i = 0; i < workers; ++i) {
                this.executeStaleShardDelete(staleFilesToDeleteInBatch, remoteStoreLockManagerFactory, groupedListener);
            }
        }
        catch (Exception e) {
            assert (false) : e;
            logger.warn((Message)new ParameterizedMessage("[{}] Exception during cleanup of stale shard blobs", snapshotIds), (Throwable)e);
            listener.onFailure(e);
        }
    }

    public static void remoteDirectoryCleanupAsync(RemoteSegmentStoreDirectoryFactory remoteDirectoryFactory, ThreadPool threadpool, String remoteStoreRepoForIndex, String indexUUID, ShardId shardId, String threadPoolName, RemoteStorePathStrategy pathStrategy) {
        threadpool.executor(threadPoolName).execute(new RemoteStoreShardCleanupTask(() -> RemoteSegmentStoreDirectory.remoteDirectoryCleanup(remoteDirectoryFactory, remoteStoreRepoForIndex, indexUUID, shardId, pathStrategy), indexUUID, shardId));
    }

    protected void releaseRemoteStoreLockAndCleanup(String shardId, String shallowSnapshotUUID, BlobContainer shardContainer, RemoteStoreLockManagerFactory remoteStoreLockManagerFactory) throws IOException {
        if (remoteStoreLockManagerFactory == null) {
            return;
        }
        RemoteStoreShardShallowCopySnapshot remoteStoreShardShallowCopySnapshot = REMOTE_STORE_SHARD_SHALLOW_COPY_SNAPSHOT_FORMAT.read(shardContainer, shallowSnapshotUUID, this.namedXContentRegistry);
        String indexUUID = remoteStoreShardShallowCopySnapshot.getIndexUUID();
        String remoteStoreRepoForIndex = remoteStoreShardShallowCopySnapshot.getRemoteStoreRepository();
        RemoteStoreLockManager remoteStoreMetadataLockManager = remoteStoreLockManagerFactory.newLockManager(remoteStoreRepoForIndex, indexUUID, shardId, remoteStoreShardShallowCopySnapshot.getRemoteStorePathStrategy());
        remoteStoreMetadataLockManager.release(FileLockInfo.getLockInfoBuilder().withAcquirerId(shallowSnapshotUUID).build());
        logger.debug("Successfully released lock for shard {} of index with uuid {}", (Object)shardId, (Object)indexUUID);
        if (!BlobStoreRepository.isIndexPresent(this.clusterService, indexUUID)) {
            RemoteSegmentStoreDirectoryFactory remoteDirectoryFactory = new RemoteSegmentStoreDirectoryFactory(remoteStoreLockManagerFactory.getRepositoriesService(), this.threadPool);
            BlobStoreRepository.remoteDirectoryCleanupAsync(remoteDirectoryFactory, this.threadPool, remoteStoreRepoForIndex, indexUUID, new ShardId("_unknown_", indexUUID, Integer.parseInt(shardId)), "remote_purge", remoteStoreShardShallowCopySnapshot.getRemoteStorePathStrategy());
        }
    }

    private void executeStaleShardDelete(BlockingQueue<List<String>> staleFilesToDeleteInBatch, RemoteStoreLockManagerFactory remoteStoreLockManagerFactory, GroupedActionListener<Void> listener) throws InterruptedException {
        List<String> filesToDelete = staleFilesToDeleteInBatch.poll(0L, TimeUnit.MILLISECONDS);
        if (filesToDelete != null) {
            this.threadPool.executor(SNAPSHOT_CODEC).execute((Runnable)ActionRunnable.wrap(listener, l -> {
                try {
                    ArrayList<String> eligibleFilesToDelete = new ArrayList<String>();
                    for (String fileToDelete : filesToDelete) {
                        if (fileToDelete.contains(SHALLOW_SNAPSHOT_PREFIX)) {
                            String[] fileToDeletePath = fileToDelete.split("/");
                            String indexId = fileToDeletePath[1];
                            String shardId = fileToDeletePath[2];
                            String shallowSnapBlob = fileToDeletePath[3];
                            String snapshotUUID = BlobStoreRepository.extractShallowSnapshotUUID(shallowSnapBlob).orElseThrow();
                            BlobContainer shardContainer = this.blobStore().blobContainer(this.indicesPath().add(indexId).add(shardId));
                            try {
                                this.releaseRemoteStoreLockAndCleanup(shardId, snapshotUUID, shardContainer, remoteStoreLockManagerFactory);
                                eligibleFilesToDelete.add(fileToDelete);
                            }
                            catch (Exception e) {
                                logger.error("Failed to release lock or cleanup shard for indexID {}, shardID {} and snapshot {}", (Object)indexId, (Object)shardId, (Object)snapshotUUID);
                            }
                            continue;
                        }
                        eligibleFilesToDelete.add(fileToDelete);
                    }
                    this.deleteFromContainer(this.blobContainer(), eligibleFilesToDelete);
                    l.onResponse(null);
                }
                catch (Exception e) {
                    logger.warn(() -> new ParameterizedMessage("[{}] Failed to delete following blobs during snapshot delete : {}", (Object)this.metadata.name(), (Object)filesToDelete), (Throwable)e);
                    l.onFailure(e);
                }
                this.executeStaleShardDelete(staleFilesToDeleteInBatch, remoteStoreLockManagerFactory, listener);
            }));
        }
    }

    private void writeUpdatedShardMetaDataAndComputeDeletes(final Collection<SnapshotId> snapshotIds, final RepositoryData oldRepositoryData, final boolean useUUIDs, final RemoteStoreLockManagerFactory remoteStoreLockManagerFactory, ActionListener<Collection<ShardSnapshotMetaDeleteResult>> onAllShardsCompleted) {
        ExecutorService executor = this.threadPool.executor(SNAPSHOT_CODEC);
        List<IndexId> indices = oldRepositoryData.indicesToUpdateAfterRemovingSnapshot(snapshotIds);
        if (indices.isEmpty()) {
            onAllShardsCompleted.onResponse(Collections.emptyList());
            return;
        }
        GroupedActionListener deleteIndexMetadataListener = new GroupedActionListener(ActionListenerHelper.map(onAllShardsCompleted, res -> res.stream().flatMap(Collection::stream).collect(Collectors.toList())), indices.size());
        for (final IndexId indexId : indices) {
            final Set survivingSnapshots = oldRepositoryData.getSnapshots(indexId).stream().filter(id -> !snapshotIds.contains(id)).collect(Collectors.toSet());
            StepListener shardCountListener = new StepListener();
            Collection indexMetaGenerations = snapshotIds.stream().map(id -> oldRepositoryData.indexMetaDataGenerations().indexMetaBlobId((SnapshotId)id, indexId)).collect(Collectors.toSet());
            GroupedActionListener allShardCountsListener = new GroupedActionListener(shardCountListener, indexMetaGenerations.size());
            BlobContainer indexContainer = this.indexContainer(indexId);
            for (String indexMetaGeneration : indexMetaGenerations) {
                executor.execute((Runnable)ActionRunnable.supply(allShardCountsListener, () -> {
                    try {
                        return INDEX_METADATA_FORMAT.read(indexContainer, indexMetaGeneration, this.namedXContentRegistry).getNumberOfShards();
                    }
                    catch (Exception ex) {
                        logger.warn(() -> new ParameterizedMessage("[{}] [{}] failed to read metadata for index", (Object)indexMetaGeneration, (Object)indexId.getName()), (Throwable)ex);
                        return null;
                    }
                }));
            }
            shardCountListener.whenComplete(counts -> {
                int shardCount = counts.stream().mapToInt(i -> i).max().orElse(0);
                if (shardCount == 0) {
                    deleteIndexMetadataListener.onResponse(null);
                    return;
                }
                final GroupedActionListener allShardsListener = new GroupedActionListener(deleteIndexMetadataListener, shardCount);
                int shardId = 0;
                while (shardId < shardCount) {
                    final int finalShardId = shardId++;
                    executor.execute((Runnable)new AbstractRunnable(){

                        public void doRun() throws Exception {
                            BlobStoreIndexShardSnapshots blobStoreIndexShardSnapshots;
                            long newGen;
                            BlobContainer shardContainer = BlobStoreRepository.this.shardContainer(indexId, finalShardId);
                            Set<String> blobs = shardContainer.listBlobs().keySet();
                            if (blobs.stream().filter(blob -> blob.startsWith("index-")).collect(Collectors.toSet()).size() > 0) {
                                if (useUUIDs) {
                                    newGen = -1L;
                                    blobStoreIndexShardSnapshots = (BlobStoreIndexShardSnapshots)BlobStoreRepository.this.buildBlobStoreIndexShardSnapshots(blobs, shardContainer, oldRepositoryData.shardGenerations().getShardGen(indexId, finalShardId)).v1();
                                } else {
                                    Tuple<BlobStoreIndexShardSnapshots, Long> tuple = BlobStoreRepository.this.buildBlobStoreIndexShardSnapshots(blobs, shardContainer);
                                    newGen = (Long)tuple.v2() + 1L;
                                    blobStoreIndexShardSnapshots = (BlobStoreIndexShardSnapshots)tuple.v1();
                                }
                            } else {
                                newGen = -1L;
                                blobStoreIndexShardSnapshots = BlobStoreIndexShardSnapshots.EMPTY;
                            }
                            allShardsListener.onResponse((Object)BlobStoreRepository.this.deleteFromShardSnapshotMeta(survivingSnapshots, indexId, finalShardId, snapshotIds, shardContainer, blobs, blobStoreIndexShardSnapshots, newGen, remoteStoreLockManagerFactory));
                        }

                        public void onFailure(Exception ex) {
                            logger.warn(() -> new ParameterizedMessage("{} failed to delete shard data for shard [{}][{}]", new Object[]{snapshotIds, indexId.getName(), finalShardId}), (Throwable)ex);
                            allShardsListener.onResponse(null);
                        }
                    });
                }
            }, arg_0 -> deleteIndexMetadataListener.onFailure(arg_0));
        }
    }

    private List<String> resolveFilesToDelete(RepositoryData oldRepositoryData, Collection<SnapshotId> snapshotIds, Collection<ShardSnapshotMetaDeleteResult> deleteResults) {
        String basePath = this.basePath().buildAsString();
        int basePathLen = basePath.length();
        Map<IndexId, Collection<String>> indexMetaGenerations = oldRepositoryData.indexMetaDataToRemoveAfterRemovingSnapshots(snapshotIds);
        return Stream.concat(deleteResults.stream().flatMap(shardResult -> {
            String shardPath = this.shardContainer(shardResult.indexId, shardResult.shardId).path().buildAsString();
            return shardResult.blobsToDelete.stream().map(blob -> shardPath + blob);
        }), indexMetaGenerations.entrySet().stream().flatMap(entry -> {
            String indexContainerPath = this.indexContainer((IndexId)entry.getKey()).path().buildAsString();
            return ((Collection)entry.getValue()).stream().map(id -> indexContainerPath + INDEX_METADATA_FORMAT.blobName((String)id));
        })).map(absolutePath -> {
            assert (absolutePath.startsWith(basePath));
            return absolutePath.substring(basePathLen);
        }).collect(Collectors.toList());
    }

    private void cleanupStaleBlobs(Collection<SnapshotId> deletedSnapshots, Map<String, BlobContainer> foundIndices, Map<String, BlobMetadata> rootBlobs, RepositoryData newRepoData, RemoteStoreLockManagerFactory remoteStoreLockManagerFactory, ActionListener<DeleteResult> listener) {
        GroupedActionListener<DeleteResult> groupedListener = new GroupedActionListener<DeleteResult>(ActionListenerHelper.wrap(deleteResults -> {
            DeleteResult deleteResult = DeleteResult.ZERO;
            for (DeleteResult result : deleteResults) {
                deleteResult = deleteResult.add(result);
            }
            listener.onResponse((Object)deleteResult);
        }, arg_0 -> listener.onFailure(arg_0)), 2);
        ExecutorService executor = this.threadPool.executor(SNAPSHOT_CODEC);
        List<String> staleRootBlobs = BlobStoreRepository.staleRootBlobs(newRepoData, rootBlobs.keySet());
        if (staleRootBlobs.isEmpty()) {
            groupedListener.onResponse(DeleteResult.ZERO);
        } else {
            executor.execute((Runnable)ActionRunnable.supply(groupedListener, () -> {
                List<String> deletedBlobs = this.cleanupStaleRootFiles(newRepoData.getGenId() - 1L, deletedSnapshots, staleRootBlobs);
                return new DeleteResult((long)deletedBlobs.size(), deletedBlobs.stream().mapToLong(name -> ((BlobMetadata)rootBlobs.get(name)).length()).sum());
            }));
        }
        Set<String> survivingIndexIds = newRepoData.getIndices().values().stream().map(IndexId::getId).collect(Collectors.toSet());
        if (foundIndices.keySet().equals(survivingIndexIds)) {
            groupedListener.onResponse(DeleteResult.ZERO);
        } else {
            this.cleanupStaleIndices(foundIndices, survivingIndexIds, remoteStoreLockManagerFactory, groupedListener);
        }
    }

    public void cleanup(long repositoryStateId, Version repositoryMetaVersion, RemoteStoreLockManagerFactory remoteStoreLockManagerFactory, ActionListener<RepositoryCleanupResult> listener) {
        try {
            if (this.isReadOnly()) {
                throw new RepositoryException(this.metadata.name(), "cannot run cleanup on readonly repository");
            }
            Map rootBlobs = this.blobContainer().listBlobs();
            RepositoryData repositoryData = this.safeRepositoryData(repositoryStateId, rootBlobs);
            Map foundIndices = this.blobStore().blobContainer(this.indicesPath()).children();
            Set survivingIndexIds = repositoryData.getIndices().values().stream().map(IndexId::getId).collect(Collectors.toSet());
            List<String> staleRootBlobs = BlobStoreRepository.staleRootBlobs(repositoryData, rootBlobs.keySet());
            if (survivingIndexIds.equals(foundIndices.keySet()) && staleRootBlobs.isEmpty()) {
                listener.onResponse((Object)new RepositoryCleanupResult(DeleteResult.ZERO));
            } else {
                this.writeIndexGen(repositoryData, repositoryStateId, repositoryMetaVersion, Function.identity(), ActionListenerHelper.wrap(v -> this.cleanupStaleBlobs(Collections.emptyList(), foundIndices, rootBlobs, repositoryData, remoteStoreLockManagerFactory, ActionListenerHelper.map(listener, RepositoryCleanupResult::new)), arg_0 -> listener.onFailure(arg_0)));
            }
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    private static List<String> staleRootBlobs(RepositoryData repositoryData, Set<String> rootBlobNames) {
        Set allSnapshotIds = repositoryData.getSnapshotIds().stream().map(SnapshotId::getUUID).collect(Collectors.toSet());
        return rootBlobNames.stream().filter(blob -> {
            if (FsBlobContainer.isTempBlobName(blob)) {
                return true;
            }
            if (blob.endsWith(".dat")) {
                String foundUUID;
                if (blob.startsWith(SNAPSHOT_PREFIX)) {
                    foundUUID = blob.substring(SNAPSHOT_PREFIX.length(), blob.length() - ".dat".length());
                    assert (SNAPSHOT_FORMAT.blobName(foundUUID).equals(blob));
                } else if (blob.startsWith(METADATA_PREFIX)) {
                    foundUUID = blob.substring(METADATA_PREFIX.length(), blob.length() - ".dat".length());
                    assert (GLOBAL_METADATA_FORMAT.blobName(foundUUID).equals(blob));
                } else {
                    return false;
                }
                return !allSnapshotIds.contains(foundUUID);
            }
            if (blob.startsWith("index-")) {
                return repositoryData.getGenId() > Long.parseLong(blob.substring("index-".length()));
            }
            return false;
        }).collect(Collectors.toList());
    }

    private List<String> cleanupStaleRootFiles(long previousGeneration, Collection<SnapshotId> deletedSnapshots, List<String> blobsToDelete) {
        if (blobsToDelete.isEmpty()) {
            return blobsToDelete;
        }
        try {
            if (logger.isInfoEnabled()) {
                Set blobNamesToIgnore = deletedSnapshots.stream().flatMap(snapshotId -> Stream.of(GLOBAL_METADATA_FORMAT.blobName(snapshotId.getUUID()), SNAPSHOT_FORMAT.blobName(snapshotId.getUUID()), "index-" + previousGeneration)).collect(Collectors.toSet());
                List blobsToLog = blobsToDelete.stream().filter(b -> !blobNamesToIgnore.contains(b)).collect(Collectors.toList());
                if (!blobsToLog.isEmpty()) {
                    logger.info("[{}] Found stale root level blobs {}. Cleaning them up", (Object)this.metadata.name(), blobsToLog);
                }
            }
            this.deleteFromContainer(this.blobContainer(), blobsToDelete);
            return blobsToDelete;
        }
        catch (IOException e) {
            logger.warn(() -> new ParameterizedMessage("[{}] The following blobs are no longer part of any snapshot [{}] but failed to remove them", (Object)this.metadata.name(), (Object)blobsToDelete), (Throwable)e);
        }
        catch (Exception e) {
            assert (false) : e;
            logger.warn((Message)new ParameterizedMessage("[{}] Exception during cleanup of root level blobs", (Object)this.metadata.name()), (Throwable)e);
        }
        return Collections.emptyList();
    }

    private void cleanupStaleIndices(Map<String, BlobContainer> foundIndices, Set<String> survivingIndexIds, RemoteStoreLockManagerFactory remoteStoreLockManagerFactory, GroupedActionListener<DeleteResult> listener) {
        GroupedActionListener<DeleteResult> groupedListener = new GroupedActionListener<DeleteResult>(ActionListenerHelper.wrap(deleteResults -> {
            DeleteResult deleteResult = DeleteResult.ZERO;
            for (DeleteResult result : deleteResults) {
                deleteResult = deleteResult.add(result);
            }
            listener.onResponse(deleteResult);
        }, listener::onFailure), foundIndices.size() - survivingIndexIds.size());
        try {
            LinkedBlockingQueue<Map.Entry<String, BlobContainer>> staleIndicesToDelete = new LinkedBlockingQueue<Map.Entry<String, BlobContainer>>();
            for (Map.Entry<String, BlobContainer> indexEntry : foundIndices.entrySet()) {
                if (survivingIndexIds.contains(indexEntry.getKey())) continue;
                staleIndicesToDelete.put(indexEntry);
            }
            int workers = Math.min(this.threadPool.info(SNAPSHOT_CODEC).getMax(), foundIndices.size() - survivingIndexIds.size());
            for (int i = 0; i < workers; ++i) {
                this.executeOneStaleIndexDelete(staleIndicesToDelete, remoteStoreLockManagerFactory, groupedListener);
            }
        }
        catch (Exception e) {
            assert (false) : e;
            logger.warn((Message)new ParameterizedMessage("[{}] Exception during cleanup of stale indices", (Object)this.metadata.name()), (Throwable)e);
        }
    }

    private static boolean isIndexPresent(ClusterService clusterService, String indexUUID) {
        for (IndexMetadata indexMetadata : clusterService.state().metadata().getIndices().values()) {
            if (!indexUUID.equals(indexMetadata.getIndexUUID())) continue;
            return true;
        }
        return false;
    }

    private void executeOneStaleIndexDelete(BlockingQueue<Map.Entry<String, BlobContainer>> staleIndicesToDelete, RemoteStoreLockManagerFactory remoteStoreLockManagerFactory, GroupedActionListener<DeleteResult> listener) throws InterruptedException {
        Map.Entry<String, BlobContainer> indexEntry = staleIndicesToDelete.poll(0L, TimeUnit.MILLISECONDS);
        if (indexEntry != null) {
            String indexSnId = indexEntry.getKey();
            this.threadPool.executor(SNAPSHOT_CODEC).execute((Runnable)ActionRunnable.supply(listener, () -> {
                DeleteResult deleteResult = DeleteResult.ZERO;
                try {
                    logger.debug("[{}] Found stale index [{}]. Cleaning it up", (Object)this.metadata.name(), (Object)indexSnId);
                    if (remoteStoreLockManagerFactory != null) {
                        Map shardBlobs = ((BlobContainer)indexEntry.getValue()).children();
                        for (Map.Entry shardBlob : shardBlobs.entrySet()) {
                            for (String blob : ((BlobContainer)shardBlob.getValue()).listBlobs().keySet()) {
                                Optional<String> snapshotUUID = BlobStoreRepository.extractShallowSnapshotUUID(blob);
                                if (!snapshotUUID.isPresent()) continue;
                                this.releaseRemoteStoreLockAndCleanup((String)shardBlob.getKey(), snapshotUUID.get(), (BlobContainer)shardBlob.getValue(), remoteStoreLockManagerFactory);
                            }
                        }
                    }
                    deleteResult = ((BlobContainer)indexEntry.getValue()).delete();
                    logger.debug("[{}] Cleaned up stale index [{}]", (Object)this.metadata.name(), (Object)indexSnId);
                }
                catch (IOException e) {
                    logger.warn(() -> new ParameterizedMessage("[{}] index {} is no longer part of any snapshots in the repository, but failed to clean up their index folders", (Object)this.metadata.name(), (Object)indexSnId), (Throwable)e);
                }
                catch (Exception e) {
                    assert (false) : e;
                    logger.warn((Message)new ParameterizedMessage("[{}] Exception during single stale index delete", (Object)this.metadata.name()), (Throwable)e);
                }
                this.executeOneStaleIndexDelete(staleIndicesToDelete, remoteStoreLockManagerFactory, listener);
                return deleteResult;
            }));
        }
    }

    @Override
    public void finalizeSnapshot(ShardGenerations shardGenerations, long repositoryStateId, Metadata clusterMetadata, SnapshotInfo snapshotInfo, Version<?> repositoryMetaVersion, Function<ClusterState, ClusterState> stateTransformer, ActionListener<RepositoryData> listener) {
        assert (repositoryStateId > -2L) : "Must finalize based on a valid repository generation but received [" + repositoryStateId + "]";
        Collection<IndexId> indices = shardGenerations.indices();
        SnapshotId snapshotId = snapshotInfo.snapshotId();
        Consumer<Exception> onUpdateFailure = e -> listener.onFailure((Exception)new SnapshotException(this.metadata.name(), snapshotId, "failed to update snapshot in repository", (Throwable)e));
        ExecutorService executor = this.threadPool.executor(SNAPSHOT_CODEC);
        StepListener repoDataListener = new StepListener();
        this.getRepositoryData((ActionListener<RepositoryData>)repoDataListener);
        repoDataListener.whenComplete(existingRepositoryData -> {
            ConcurrentMap indexMetas = ConcurrentCollections.newConcurrentMap();
            ConcurrentMap indexMetaIdentifiers = ConcurrentCollections.newConcurrentMap();
            GroupedActionListener allMetaListener = new GroupedActionListener(ActionListenerHelper.wrap(v -> {
                RepositoryData updatedRepositoryData = existingRepositoryData.addSnapshot(snapshotId, snapshotInfo.state(), Version.CURRENT, shardGenerations, indexMetas, indexMetaIdentifiers);
                this.writeIndexGen(updatedRepositoryData, repositoryStateId, repositoryMetaVersion, stateTransformer, ActionListenerHelper.wrap(newRepoData -> {
                    this.cleanupOldShardGens((RepositoryData)existingRepositoryData, updatedRepositoryData);
                    listener.onResponse(newRepoData);
                }, onUpdateFailure));
            }, onUpdateFailure), 2 + indices.size());
            executor.execute((Runnable)ActionRunnable.run(allMetaListener, () -> GLOBAL_METADATA_FORMAT.write(clusterMetadata, this.blobContainer(), snapshotId.getUUID(), this.compressor)));
            for (IndexId index : indices) {
                executor.execute((Runnable)ActionRunnable.run(allMetaListener, () -> {
                    IndexMetadata indexMetaData = clusterMetadata.index(index.getName());
                    String identifiers = IndexMetadataGenerations.buildUniqueIdentifier(indexMetaData);
                    String metaUUID = existingRepositoryData.indexMetaDataGenerations().getIndexMetaBlobId(identifiers);
                    if (metaUUID == null) {
                        metaUUID = UUIDs.base64UUID();
                        INDEX_METADATA_FORMAT.write(indexMetaData, this.indexContainer(index), metaUUID, this.compressor);
                        indexMetaIdentifiers.put(identifiers, metaUUID);
                    }
                    indexMetas.put(index, identifiers);
                }));
            }
            executor.execute((Runnable)ActionRunnable.run(allMetaListener, () -> SNAPSHOT_FORMAT.write(snapshotInfo, this.blobContainer(), snapshotId.getUUID(), this.compressor)));
        }, onUpdateFailure);
    }

    private void cleanupOldShardGens(RepositoryData existingRepositoryData, RepositoryData updatedRepositoryData) {
        ArrayList<String> toDelete = new ArrayList<String>();
        int prefixPathLen = this.basePath().buildAsString().length();
        updatedRepositoryData.shardGenerations().obsoleteShardGenerations(existingRepositoryData.shardGenerations()).forEach((indexId, gens) -> gens.forEach((shardId, oldGen) -> toDelete.add(this.shardContainer((IndexId)indexId, (int)shardId).path().buildAsString().substring(prefixPathLen) + "index-" + oldGen)));
        try {
            this.deleteFromContainer(this.blobContainer(), toDelete);
        }
        catch (Exception e) {
            logger.warn("Failed to clean up old shard generation blobs", (Throwable)e);
        }
    }

    @Override
    public SnapshotInfo getSnapshotInfo(SnapshotId snapshotId) {
        try {
            return SNAPSHOT_FORMAT.read(this.blobContainer(), snapshotId.getUUID(), this.namedXContentRegistry);
        }
        catch (NoSuchFileException ex) {
            throw new SnapshotMissingException(this.metadata.name(), snapshotId, (Throwable)ex);
        }
        catch (NotXContentException | IOException ex) {
            throw new SnapshotException(this.metadata.name(), snapshotId, "failed to get snapshots", (Throwable)ex);
        }
    }

    @Override
    public Metadata getSnapshotGlobalMetadata(SnapshotId snapshotId) {
        try {
            return GLOBAL_METADATA_FORMAT.read(this.blobContainer(), snapshotId.getUUID(), this.namedXContentRegistry);
        }
        catch (NoSuchFileException ex) {
            throw new SnapshotMissingException(this.metadata.name(), snapshotId, (Throwable)ex);
        }
        catch (IOException ex) {
            throw new SnapshotException(this.metadata.name(), snapshotId, "failed to read global metadata", (Throwable)ex);
        }
    }

    @Override
    public IndexMetadata getSnapshotIndexMetaData(RepositoryData repositoryData, SnapshotId snapshotId, IndexId index) throws IOException {
        try {
            return INDEX_METADATA_FORMAT.read(this.indexContainer(index), repositoryData.indexMetaDataGenerations().indexMetaBlobId(snapshotId, index), this.namedXContentRegistry);
        }
        catch (NoSuchFileException e) {
            throw new SnapshotMissingException(this.metadata.name(), snapshotId, (Throwable)e);
        }
    }

    private void deleteFromContainer(BlobContainer container, List<String> blobs) throws IOException {
        logger.trace(() -> new ParameterizedMessage("[{}] Deleting {} from [{}]", new Object[]{this.metadata.name(), blobs, container.path()}));
        container.deleteBlobsIgnoringIfNotExists(blobs);
    }

    private BlobPath indicesPath() {
        return this.basePath().add("indices");
    }

    private BlobContainer indexContainer(IndexId indexId) {
        return this.blobStore().blobContainer(this.indicesPath().add(indexId.getId()));
    }

    private BlobContainer shardContainer(IndexId indexId, ShardId shardId) {
        return this.shardContainer(indexId, shardId.getId());
    }

    public BlobContainer shardContainer(IndexId indexId, int shardId) {
        return this.blobStore().blobContainer(this.indicesPath().add(indexId.getId()).add(Integer.toString(shardId)));
    }

    private RateLimiter getRateLimiter(Settings repositorySettings, String setting, ByteSizeValue defaultRate) {
        ByteSizeValue maxSnapshotBytesPerSec = repositorySettings.getAsBytesSize(setting, defaultRate);
        if (maxSnapshotBytesPerSec.getBytes() <= 0L) {
            return null;
        }
        return new RateLimiter.SimpleRateLimiter(maxSnapshotBytesPerSec.getMbFrac());
    }

    @Override
    public long getSnapshotThrottleTimeInNanos() {
        return this.snapshotRateLimitingTimeInNanos.count();
    }

    @Override
    public long getRestoreThrottleTimeInNanos() {
        return this.restoreRateLimitingTimeInNanos.count();
    }

    @Override
    public long getRemoteUploadThrottleTimeInNanos() {
        return this.remoteUploadRateLimitingTimeInNanos.count();
    }

    @Override
    public long getRemoteDownloadThrottleTimeInNanos() {
        return this.remoteDownloadRateLimitingTimeInNanos.count();
    }

    protected void assertSnapshotOrGenericThread() {
        assert (Thread.currentThread().getName().contains("[snapshot]") || Thread.currentThread().getName().contains("[generic]")) : "Expected current thread [" + String.valueOf(Thread.currentThread()) + "] to be the snapshot or generic thread.";
    }

    @Override
    public String startVerification() {
        try {
            if (this.isReadOnly()) {
                this.latestIndexBlobId();
                return "read-only";
            }
            String seed = UUIDs.randomBase64UUID();
            byte[] testBytes = Strings.toUTF8Bytes(seed);
            BlobContainer testContainer = this.blobStore().blobContainer(this.basePath().add(BlobStoreRepository.testBlobPrefix(seed)));
            BytesArray bytes = new BytesArray(testBytes);
            if (!this.isSystemRepository) {
                try (StreamInput stream = bytes.streamInput();){
                    testContainer.writeBlobAtomic("master.dat", (InputStream)stream, (long)bytes.length(), true);
                }
            }
            return seed;
        }
        catch (Exception exp) {
            throw new RepositoryVerificationException(this.metadata.name(), "path " + String.valueOf(this.basePath()) + " is not accessible on cluster-manager node", exp);
        }
    }

    @Override
    public void endVerification(String seed) {
        if (!this.isReadOnly()) {
            try {
                String testPrefix = BlobStoreRepository.testBlobPrefix(seed);
                this.blobStore().blobContainer(this.basePath().add(testPrefix)).delete();
            }
            catch (Exception exp) {
                throw new RepositoryVerificationException(this.metadata.name(), "cannot delete test data at " + String.valueOf(this.basePath()), exp);
            }
        }
    }

    @Override
    public void getRepositoryData(ActionListener<RepositoryData> listener) {
        if (this.latestKnownRepoGen.get() == -3L) {
            listener.onFailure((Exception)this.corruptedStateException(null));
            return;
        }
        Tuple<Long, BytesReference> cached = this.latestKnownRepositoryData.get();
        if (!this.bestEffortConsistency && cached != null && ((Long)cached.v1()).longValue() == this.latestKnownRepoGen.get()) {
            try {
                listener.onResponse((Object)this.repositoryDataFromCachedEntry(cached));
            }
            catch (Exception e) {
                listener.onFailure(e);
            }
            return;
        }
        this.threadPool.generic().execute((Runnable)ActionRunnable.wrap(listener, this::doGetRepositoryData));
    }

    private void doGetRepositoryData(ActionListener<RepositoryData> listener) {
        long lastFailedGeneration = -2L;
        while (true) {
            long genToLoad;
            if (this.bestEffortConsistency) {
                long generation;
                try {
                    generation = this.latestIndexBlobId();
                }
                catch (IOException ioe) {
                    listener.onFailure((Exception)new RepositoryException(this.metadata.name(), "Could not determine repository generation from root blobs", ioe));
                    return;
                }
                genToLoad = this.latestKnownRepoGen.updateAndGet(known -> Math.max(known, generation));
                if (genToLoad > generation) {
                    logger.info("Determined repository generation [" + generation + "] from repository contents but correct generation must be at least [" + genToLoad + "]");
                }
            } else {
                genToLoad = this.latestKnownRepoGen.get();
            }
            try {
                RepositoryData loaded;
                Tuple<Long, BytesReference> cached = this.latestKnownRepositoryData.get();
                if (!this.bestEffortConsistency && cached != null && (Long)cached.v1() == genToLoad) {
                    loaded = this.repositoryDataFromCachedEntry(cached);
                } else {
                    loaded = this.getRepositoryData(genToLoad);
                    this.cacheRepositoryData(BytesReference.bytes(loaded.snapshotsToXContent(MediaTypeRegistry.JSON.contentBuilder(), Version.CURRENT)), genToLoad);
                }
                listener.onResponse((Object)loaded);
                return;
            }
            catch (RepositoryException e) {
                if (genToLoad != this.latestKnownRepoGen.get() && genToLoad != lastFailedGeneration) {
                    lastFailedGeneration = genToLoad;
                    logger.warn("Failed to load repository data generation [" + genToLoad + "] because a concurrent operation moved the current generation to [" + this.latestKnownRepoGen.get() + "]", (Throwable)e);
                    continue;
                }
                if (!this.bestEffortConsistency && SkyliteExceptionsHelper.unwrap(e, NoSuchFileException.class) != null) {
                    this.markRepoCorrupted(genToLoad, e, ActionListenerHelper.wrap(v -> listener.onFailure((Exception)this.corruptedStateException(e)), arg_0 -> listener.onFailure(arg_0)));
                } else {
                    listener.onFailure((Exception)e);
                }
                return;
            }
            catch (Exception e) {
                listener.onFailure((Exception)new RepositoryException(this.metadata.name(), "Unexpected exception when loading repository data", e));
                return;
            }
            break;
        }
    }

    private void cacheRepositoryData(BytesReference updated, long generation) {
        if (this.cacheRepositoryData && !this.bestEffortConsistency) {
            BytesReference serialized;
            try {
                serialized = CompressorRegistry.defaultCompressor().compress(updated);
                int len = serialized.length();
                if ((long)len > ByteSizeUnit.KB.toBytes(500L)) {
                    logger.debug("Not caching repository data of size [{}] for repository [{}] because it is larger than 500KB in serialized size", (Object)len, (Object)this.metadata.name());
                    if ((long)len > ByteSizeUnit.MB.toBytes(5L)) {
                        logger.warn("Your repository metadata blob for repository [{}] is larger than 5MB. Consider moving to a fresh repository for new snapshots or deleting unneeded snapshots from your repository to ensure stable repository behavior going forward.", (Object)this.metadata.name());
                    }
                    this.latestKnownRepositoryData.set(null);
                    return;
                }
            }
            catch (IOException e) {
                assert (false) : new AssertionError("Impossible, no IO happens here", e);
                logger.warn("Failed to serialize repository data", (Throwable)e);
                return;
            }
            this.latestKnownRepositoryData.updateAndGet(known -> {
                if (known != null && (Long)known.v1() > generation) {
                    return known;
                }
                return new Tuple((Object)generation, (Object)serialized);
            });
        }
    }

    private RepositoryData repositoryDataFromCachedEntry(Tuple<Long, BytesReference> cacheEntry) throws IOException {
        try (InputStream input = CompressorRegistry.defaultCompressor().threadLocalInputStream(((BytesReference)cacheEntry.v2()).streamInput());){
            RepositoryData repositoryData = RepositoryData.snapshotsFromXContent(MediaTypeRegistry.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, input), (Long)cacheEntry.v1());
            return repositoryData;
        }
    }

    private RepositoryException corruptedStateException(@Nullable Exception cause) {
        return new RepositoryException(this.metadata.name(), "Could not read repository data because the contents of the repository do not match its expected state. This is likely the result of either concurrently modifying the contents of the repository by a process other than this cluster or an issue with the repository's underlying storage. The repository has been disabled to prevent corrupting its contents. To re-enable it and continue using it please remove the repository from the cluster and add it again to make the cluster recover the known state of the repository from its physical contents.", cause);
    }

    private void markRepoCorrupted(final long corruptedGeneration, final Exception originalException, final ActionListener<Void> listener) {
        assert (corruptedGeneration != -2L);
        assert (!this.bestEffortConsistency);
        this.clusterService.submitStateUpdateTask("mark repository corrupted [" + this.metadata.name() + "][" + corruptedGeneration + "]", new ClusterStateUpdateTask(){

            @Override
            public ClusterState execute(ClusterState currentState) {
                RepositoriesMetadata state = (RepositoriesMetadata)currentState.metadata().custom("repositories");
                RepositoryMetadata repoState = state.repository(BlobStoreRepository.this.metadata.name());
                if (repoState.generation() != corruptedGeneration) {
                    throw new IllegalStateException("Tried to mark repo generation [" + corruptedGeneration + "] as corrupted but its state concurrently changed to [" + String.valueOf(repoState) + "]");
                }
                return ClusterState.builder(currentState).metadata(Metadata.builder(currentState.metadata()).putCustom("repositories", state.withUpdatedGeneration(BlobStoreRepository.this.metadata.name(), -3L, repoState.pendingGeneration())).build()).build();
            }

            @Override
            public void onFailure(String source, Exception e) {
                listener.onFailure((Exception)new RepositoryException(BlobStoreRepository.this.metadata.name(), "Failed marking repository state as corrupted", ExceptionsHelper.useOrSuppress((Throwable)e, (Throwable)originalException)));
            }

            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                listener.onResponse(null);
            }
        });
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private RepositoryData getRepositoryData(long indexGen) {
        if (indexGen == -1L) {
            return RepositoryData.EMPTY;
        }
        try {
            String snapshotsIndexBlobName = "index-" + indexGen;
            try (InputStream blob = this.blobContainer().readBlob(snapshotsIndexBlobName);){
                RepositoryData repositoryData;
                block16: {
                    XContentParser parser = MediaTypeRegistry.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, blob);
                    try {
                        repositoryData = RepositoryData.snapshotsFromXContent(parser, indexGen);
                        if (parser == null) break block16;
                    }
                    catch (Throwable throwable) {
                        if (parser != null) {
                            try {
                                parser.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    parser.close();
                }
                return repositoryData;
            }
        }
        catch (IOException ioe) {
            if (this.bestEffortConsistency && this.latestKnownRepoGen.compareAndSet(indexGen, -1L)) {
                logger.warn("Resetting repository generation tracker because we failed to read generation [" + indexGen + "]", (Throwable)ioe);
            }
            throw new RepositoryException(this.metadata.name(), "could not read repository data from index blob", ioe);
        }
    }

    private static String testBlobPrefix(String seed) {
        return TESTS_FILE + seed;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public boolean isSystemRepository() {
        return this.isSystemRepository;
    }

    protected void writeIndexGen(RepositoryData repositoryData, final long expectedGen, Version version, final Function<ClusterState, ClusterState> stateFilter, final ActionListener<RepositoryData> listener) {
        assert (!this.isReadOnly());
        long currentGen = repositoryData.getGenId();
        if (currentGen != expectedGen) {
            listener.onFailure((Exception)new RepositoryException(this.metadata.name(), "concurrent modification of the index-N file, expected current generation [" + expectedGen + "], actual current generation [" + currentGen + "]"));
            return;
        }
        final StepListener setPendingStep = new StepListener();
        this.clusterService.submitStateUpdateTask("set pending repository generation [" + this.metadata.name() + "][" + expectedGen + "]", new ClusterStateUpdateTask(){
            private long newGen;

            @Override
            public ClusterState execute(ClusterState currentState) {
                boolean uninitializedMeta;
                RepositoryMetadata meta = BlobStoreRepository.this.getRepoMetadata(currentState);
                String repoName = BlobStoreRepository.this.metadata.name();
                long genInState = meta.generation();
                boolean bl = uninitializedMeta = meta.generation() == -2L || BlobStoreRepository.this.bestEffortConsistency;
                if (!uninitializedMeta && meta.pendingGeneration() != genInState) {
                    logger.info("Trying to write new repository data over unfinished write, repo [{}] is at safe generation [{}] and pending generation [{}]", (Object)meta.name(), (Object)genInState, (Object)meta.pendingGeneration());
                }
                assert (expectedGen == -1L || uninitializedMeta || expectedGen == meta.generation()) : "Expected non-empty generation [" + expectedGen + "] does not match generation tracked in [" + String.valueOf(meta) + "]";
                long safeGeneration = expectedGen == -1L ? -1L : (uninitializedMeta ? expectedGen : genInState);
                long nextPendingGen = BlobStoreRepository.this.metadata.pendingGeneration() + 1L;
                long l = this.newGen = uninitializedMeta ? Math.max(expectedGen + 1L, nextPendingGen) : nextPendingGen;
                assert (this.newGen > BlobStoreRepository.this.latestKnownRepoGen.get()) : "Attempted new generation [" + this.newGen + "] must be larger than latest known generation [" + BlobStoreRepository.this.latestKnownRepoGen.get() + "]";
                return ClusterState.builder(currentState).metadata(Metadata.builder(currentState.getMetadata()).putCustom("repositories", ((RepositoriesMetadata)currentState.metadata().custom("repositories")).withUpdatedGeneration(repoName, safeGeneration, this.newGen)).build()).build();
            }

            @Override
            public void onFailure(String source, Exception e) {
                listener.onFailure((Exception)new RepositoryException(BlobStoreRepository.this.metadata.name(), "Failed to execute cluster state update [" + source + "]", e));
            }

            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                setPendingStep.onResponse(this.newGen);
            }
        });
        StepListener filterRepositoryDataStep = new StepListener();
        setPendingStep.whenComplete(newGen -> this.threadPool().executor(SNAPSHOT_CODEC).execute((Runnable)ActionRunnable.wrap((ActionListener)listener, l -> {
            final List snapshotIdsWithoutVersion = repositoryData.getSnapshotIds().stream().filter(snapshotId -> repositoryData.getVersion((SnapshotId)snapshotId) == null).collect(Collectors.toList());
            if (!snapshotIdsWithoutVersion.isEmpty()) {
                ConcurrentHashMap updatedVersionMap = new ConcurrentHashMap();
                GroupedActionListener<Void> loadAllVersionsListener = new GroupedActionListener<Void>(ActionListenerHelper.runAfter(new ActionListener<Collection<Void>>(){

                    public void onResponse(Collection<Void> voids) {
                        logger.info("Successfully loaded all snapshot's version information for {} from snapshot metadata", (Object)CollectionUtils.firstListElementsToCommaDelimitedString(snapshotIdsWithoutVersion, SnapshotId::toString, logger.isDebugEnabled()));
                    }

                    public void onFailure(Exception e) {
                        logger.warn("Failure when trying to load missing version information from snapshot metadata", (Throwable)e);
                    }
                }, () -> filterRepositoryDataStep.onResponse(repositoryData.withVersions(updatedVersionMap))), snapshotIdsWithoutVersion.size());
                for (SnapshotId snapshotId2 : snapshotIdsWithoutVersion) {
                    this.threadPool().executor(SNAPSHOT_CODEC).execute((Runnable)ActionRunnable.run(loadAllVersionsListener, () -> updatedVersionMap.put(snapshotId2, this.getSnapshotInfo(snapshotId2).version())));
                }
            } else {
                filterRepositoryDataStep.onResponse(repositoryData);
            }
        })), arg_0 -> listener.onFailure(arg_0));
        filterRepositoryDataStep.whenComplete(filteredRepositoryData -> {
            final long newGen = (Long)setPendingStep.result();
            final RepositoryData newRepositoryData = filteredRepositoryData.withGenId(newGen);
            if (this.latestKnownRepoGen.get() >= newGen) {
                throw new IllegalArgumentException("Tried writing generation [" + newGen + "] but repository is at least at generation [" + this.latestKnownRepoGen.get() + "] already");
            }
            if (!this.ensureSafeGenerationExists(expectedGen, arg_0 -> ((ActionListener)listener).onFailure(arg_0))) {
                return;
            }
            String indexBlob = "index-" + Long.toString(newGen);
            logger.debug("Repository [{}] writing new index generational blob [{}]", (Object)this.metadata.name(), (Object)indexBlob);
            final BytesReference serializedRepoData = BytesReference.bytes(newRepositoryData.snapshotsToXContent(MediaTypeRegistry.JSON.contentBuilder(), version));
            this.writeAtomic(this.blobContainer(), indexBlob, serializedRepoData, true);
            this.maybeWriteIndexLatest(newGen);
            this.clusterService.submitStateUpdateTask("set safe repository generation [" + this.metadata.name() + "][" + newGen + "]", new ClusterStateUpdateTask(){

                @Override
                public ClusterState execute(ClusterState currentState) {
                    RepositoryMetadata meta = BlobStoreRepository.this.getRepoMetadata(currentState);
                    if (meta.generation() != expectedGen) {
                        throw new IllegalStateException("Tried to update repo generation to [" + newGen + "] but saw unexpected generation in state [" + String.valueOf(meta) + "]");
                    }
                    if (meta.pendingGeneration() != newGen) {
                        throw new IllegalStateException("Tried to update from unexpected pending repo generation [" + meta.pendingGeneration() + "] after write to generation [" + newGen + "]");
                    }
                    return BlobStoreRepository.this.updateRepositoryGenerationsIfNecessary((ClusterState)stateFilter.apply(ClusterState.builder(currentState).metadata(Metadata.builder(currentState.getMetadata()).putCustom("repositories", ((RepositoriesMetadata)currentState.metadata().custom("repositories")).withUpdatedGeneration(BlobStoreRepository.this.metadata.name(), newGen, newGen))).build()), expectedGen, newGen);
                }

                @Override
                public void onFailure(String source, Exception e) {
                    listener.onFailure((Exception)new RepositoryException(BlobStoreRepository.this.metadata.name(), "Failed to execute cluster state update [" + source + "]", e));
                }

                @Override
                public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                    BlobStoreRepository.this.cacheRepositoryData(serializedRepoData, newGen);
                    BlobStoreRepository.this.threadPool.executor(BlobStoreRepository.SNAPSHOT_CODEC).execute((Runnable)ActionRunnable.supply((ActionListener)listener, () -> {
                        List<String> oldIndexN = LongStream.range(Math.max(Math.max(expectedGen - 1L, 0L), newGen - 1000L), newGen).mapToObj(gen -> "index-" + gen).collect(Collectors.toList());
                        try {
                            BlobStoreRepository.this.deleteFromContainer(BlobStoreRepository.this.blobContainer(), oldIndexN);
                        }
                        catch (IOException e) {
                            logger.warn(() -> new ParameterizedMessage("Failed to clean up old index blobs {}", (Object)oldIndexN), (Throwable)e);
                        }
                        return newRepositoryData;
                    }));
                }
            });
        }, arg_0 -> listener.onFailure(arg_0));
    }

    private void maybeWriteIndexLatest(long newGen) {
        if (this.supportURLRepo) {
            logger.debug("Repository [{}] updating index.latest with generation [{}]", (Object)this.metadata.name(), (Object)newGen);
            try {
                this.writeAtomic(this.blobContainer(), INDEX_LATEST_BLOB, new BytesArray(Numbers.longToBytes((long)newGen)), false);
            }
            catch (Exception e) {
                logger.warn(() -> new ParameterizedMessage("Failed to write index.latest blob. If you do not intend to use this repository as the basis for a URL repository you may turn off attempting to write the index.latest blob by setting repository setting [{}] to [false]", (Object)BlobStoreRepositorySettings.SUPPORT_URL_REPO.getKey()), (Throwable)e);
            }
        }
    }

    private boolean ensureSafeGenerationExists(long safeGeneration, final Consumer<Exception> onFailure) throws IOException {
        logger.debug("Ensure generation [{}] that is the basis for this write exists in [{}]", (Object)safeGeneration, (Object)this.metadata.name());
        if (safeGeneration != -1L && !this.blobContainer().blobExists("index-" + safeGeneration)) {
            final RepositoryException exception = new RepositoryException(this.metadata.name(), "concurrent modification of the index-N file, expected current generation [" + safeGeneration + "] but it was not found in the repository");
            this.markRepoCorrupted(safeGeneration, exception, new ActionListener<Void>(){

                public void onResponse(Void aVoid) {
                    onFailure.accept(exception);
                }

                public void onFailure(Exception e) {
                    onFailure.accept(e);
                }
            });
            return false;
        }
        return true;
    }

    private ClusterState updateRepositoryGenerationsIfNecessary(ClusterState state, long oldGen, long newGen) {
        String repoName = this.metadata.name();
        boolean changedSnapshots = false;
        ArrayList<SnapshotsInProgress.Entry> snapshotEntries = new ArrayList<SnapshotsInProgress.Entry>();
        for (SnapshotsInProgress.Entry entry : state.custom("snapshots", SnapshotsInProgress.EMPTY).entries()) {
            if (entry.repository().equals(repoName) && entry.repositoryStateId() == oldGen) {
                snapshotEntries.add(entry.withRepoGen(newGen));
                changedSnapshots = true;
                continue;
            }
            snapshotEntries.add(entry);
        }
        SnapshotsInProgress updatedSnapshotsInProgress = changedSnapshots ? SnapshotsInProgress.of(snapshotEntries) : null;
        boolean changedDeletions = false;
        ArrayList<SnapshotDeletionsInProgress.Entry> deletionEntries = new ArrayList<SnapshotDeletionsInProgress.Entry>();
        for (SnapshotDeletionsInProgress.Entry entry : state.custom("snapshot_deletions", SnapshotDeletionsInProgress.EMPTY).getEntries()) {
            if (entry.repository().equals(repoName) && entry.repositoryStateId() == oldGen) {
                deletionEntries.add(entry.withRepoGen(newGen));
                changedDeletions = true;
                continue;
            }
            deletionEntries.add(entry);
        }
        SnapshotDeletionsInProgress updatedDeletionsInProgress = changedDeletions ? SnapshotDeletionsInProgress.of(deletionEntries) : null;
        return SnapshotsService.updateWithSnapshots(state, updatedSnapshotsInProgress, updatedDeletionsInProgress);
    }

    private RepositoryMetadata getRepoMetadata(ClusterState state) {
        RepositoryMetadata repositoryMetadata = ((RepositoriesMetadata)state.getMetadata().custom("repositories")).repository(this.metadata.name());
        assert (repositoryMetadata != null);
        return repositoryMetadata;
    }

    long latestIndexBlobId() throws IOException {
        try {
            return this.listBlobsToGetLatestIndexId();
        }
        catch (UnsupportedOperationException e) {
            try {
                return this.readSnapshotIndexLatestBlob();
            }
            catch (NoSuchFileException nsfe) {
                return -1L;
            }
        }
    }

    long readSnapshotIndexLatestBlob() throws IOException {
        return BytesRefUtils.bytesToLong(Streams.readFully(this.blobContainer().readBlob(INDEX_LATEST_BLOB)).toBytesRef());
    }

    private long listBlobsToGetLatestIndexId() throws IOException {
        return this.latestGeneration(this.blobContainer().listBlobsByPrefix("index-").keySet());
    }

    private long latestGeneration(Collection<String> rootBlobs) {
        long latest = -1L;
        for (String blobName : rootBlobs) {
            if (!blobName.startsWith("index-")) continue;
            try {
                long curr = Long.parseLong(blobName.substring("index-".length()));
                latest = Math.max(latest, curr);
            }
            catch (NumberFormatException nfe) {
                logger.warn("[{}] Unknown blob in the repository: {}", (Object)this.metadata.name(), (Object)blobName);
            }
        }
        return latest;
    }

    private void writeAtomic(BlobContainer container, String blobName, BytesReference bytesRef, boolean failIfAlreadyExists) throws IOException {
        try (StreamInput stream = bytesRef.streamInput();){
            logger.trace(() -> new ParameterizedMessage("[{}] Writing [{}] to {} atomically", new Object[]{this.metadata.name(), blobName, container.path()}));
            container.writeBlobAtomic(blobName, (InputStream)stream, (long)bytesRef.length(), failIfAlreadyExists);
        }
    }

    @Override
    public void snapshotRemoteStoreIndexShard(Store store, SnapshotId snapshotId, IndexId indexId, IndexCommit snapshotIndexCommit, String shardStateIdentifier, IndexShardSnapshotStatus snapshotStatus, long primaryTerm, long startTime, ActionListener<String> listener) {
        if (this.isReadOnly()) {
            listener.onFailure((Exception)new RepositoryException(this.metadata.name(), "cannot snapshot shard on a readonly repository"));
            return;
        }
        ShardId shardId = store.shardId();
        try {
            String generation = snapshotStatus.generation();
            logger.info("[{}] [{}] snapshot to [{}] [{}] ...", (Object)shardId, (Object)snapshotId, (Object)this.metadata.name(), (Object)generation);
            BlobContainer shardContainer = this.shardContainer(indexId, shardId);
            long indexTotalFileSize = 0L;
            ArrayList<String> fileNames = new ArrayList<String>(snapshotIndexCommit.getFileNames());
            Store.MetadataSnapshot commitSnapshotMetadata = store.getMetadata(snapshotIndexCommit);
            for (String fileName : fileNames) {
                indexTotalFileSize += commitSnapshotMetadata.get(fileName).length();
            }
            int indexTotalNumberOfFiles = fileNames.size();
            snapshotStatus.moveToStarted(startTime, 0, indexTotalNumberOfFiles, 0L, indexTotalFileSize);
            IndexShardSnapshotStatus.Copy lastSnapshotStatus = snapshotStatus.moveToFinalize(snapshotIndexCommit.getGeneration());
            logger.trace("[{}] [{}] writing shard snapshot file", (Object)shardId, (Object)snapshotId);
            try {
                RemoteStorePathStrategy pathStrategy = store.indexSettings().getRemoteStorePathStrategy();
                REMOTE_STORE_SHARD_SHALLOW_COPY_SNAPSHOT_FORMAT.write(new RemoteStoreShardShallowCopySnapshot(snapshotId.getName(), lastSnapshotStatus.getIndexVersion(), primaryTerm, snapshotIndexCommit.getGeneration(), lastSnapshotStatus.getStartTime(), this.threadPool.absoluteTimeInMillis() - lastSnapshotStatus.getStartTime(), indexTotalNumberOfFiles, indexTotalFileSize, store.indexSettings().getUUID(), store.indexSettings().getRemoteStoreRepository(), this.basePath().toString(), fileNames, pathStrategy.getType(), pathStrategy.getHashAlgorithm()), shardContainer, snapshotId.getUUID(), this.compressor);
            }
            catch (IOException e) {
                throw new IndexShardSnapshotFailedException(shardId, "Failed to write commit point for snapshot " + snapshotId.getName() + "(" + snapshotId.getUUID() + ")", e);
            }
            snapshotStatus.moveToDone(this.threadPool.absoluteTimeInMillis(), generation);
            listener.onResponse((Object)generation);
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    @Override
    public void snapshotShard(Store store, MapperService mapperService, SnapshotId snapshotId, IndexId indexId, IndexCommit snapshotIndexCommit, String shardStateIdentifier, IndexShardSnapshotStatus snapshotStatus, Version repositoryMetaVersion, Map<String, Object> userMetadata, ActionListener<String> listener) {
        if (this.isReadOnly()) {
            listener.onFailure((Exception)new RepositoryException(this.metadata.name(), "cannot snapshot shard on a readonly repository"));
            return;
        }
        ShardId shardId = store.shardId();
        long startTime = this.threadPool.absoluteTimeInMillis();
        try {
            ArrayList<BlobStoreIndexShardSnapshot.FileInfo> indexCommitPointFiles;
            Set<CallSite> blobs;
            String generation = snapshotStatus.generation();
            logger.debug("[{}] [{}] snapshot to [{}] [{}] ...", (Object)shardId, (Object)snapshotId, (Object)this.metadata.name(), (Object)generation);
            BlobContainer shardContainer = this.shardContainer(indexId, shardId);
            if (generation == null) {
                try {
                    blobs = shardContainer.listBlobsByPrefix("index-").keySet();
                }
                catch (IOException e) {
                    throw new IndexShardSnapshotFailedException(shardId, "failed to list blobs", e);
                }
            } else {
                blobs = Collections.singleton("index-" + generation);
            }
            Tuple<BlobStoreIndexShardSnapshots, String> tuple = this.buildBlobStoreIndexShardSnapshots(blobs, shardContainer, generation);
            BlobStoreIndexShardSnapshots snapshots = (BlobStoreIndexShardSnapshots)tuple.v1();
            String fileListGeneration = (String)tuple.v2();
            if (snapshots.snapshots().stream().anyMatch(sf -> sf.snapshot().equals(snapshotId.getName()))) {
                throw new IndexShardSnapshotFailedException(shardId, "Duplicate snapshot name [" + snapshotId.getName() + "] detected, aborting");
            }
            List filesFromSegmentInfos = Optional.ofNullable(shardStateIdentifier).map(id -> {
                for (SnapshotFiles snapshotFileSet : snapshots.snapshots()) {
                    if (!id.equals(snapshotFileSet.shardStateIdentifier())) continue;
                    return snapshotFileSet.indexFiles();
                }
                return null;
            }).orElse(null);
            int indexIncrementalFileCount = 0;
            int indexTotalNumberOfFiles = 0;
            long indexIncrementalSize = 0L;
            long indexTotalFileSize = 0L;
            LinkedBlockingQueue<BlobStoreIndexShardSnapshot.FileInfo> filesToSnapshot = new LinkedBlockingQueue<BlobStoreIndexShardSnapshot.FileInfo>();
            if (filesFromSegmentInfos == null) {
                Collection fileNames;
                Store.MetadataSnapshot metadataFromStore;
                indexCommitPointFiles = new ArrayList();
                try (Object ignored = BlobStoreRepository.incrementStoreRef(store, snapshotStatus, shardId);){
                    try {
                        logger.trace("[{}] [{}] Loading store metadata using index commit [{}]", (Object)shardId, (Object)snapshotId, (Object)snapshotIndexCommit);
                        metadataFromStore = store.getMetadata(snapshotIndexCommit);
                        fileNames = snapshotIndexCommit.getFileNames();
                    }
                    catch (IOException e) {
                        throw new IndexShardSnapshotFailedException(shardId, "Failed to get store file metadata", e);
                    }
                }
                ignored = fileNames.iterator();
                while (ignored.hasNext()) {
                    String fileName = (String)ignored.next();
                    if (snapshotStatus.isAborted()) {
                        logger.debug("[{}] [{}] Aborted on the file [{}], exiting", (Object)shardId, (Object)snapshotId, (Object)fileName);
                        throw new AbortedSnapshotException();
                    }
                    logger.trace("[{}] [{}] Processing [{}]", (Object)shardId, (Object)snapshotId, (Object)fileName);
                    StoreFileMetadata md = metadataFromStore.get(fileName);
                    BlobStoreIndexShardSnapshot.FileInfo existingFileInfo = null;
                    List<BlobStoreIndexShardSnapshot.FileInfo> filesInfo = snapshots.findPhysicalIndexFiles(fileName);
                    if (filesInfo != null) {
                        for (BlobStoreIndexShardSnapshot.FileInfo fileInfo : filesInfo) {
                            if (!fileInfo.isSame(md)) continue;
                            existingFileInfo = fileInfo;
                            break;
                        }
                    }
                    boolean needsWrite = !md.hashEqualsContents();
                    indexTotalFileSize += md.length();
                    ++indexTotalNumberOfFiles;
                    if (existingFileInfo == null) {
                        ++indexIncrementalFileCount;
                        indexIncrementalSize += md.length();
                        BlobStoreIndexShardSnapshot.FileInfo snapshotFileInfo = new BlobStoreIndexShardSnapshot.FileInfo((needsWrite ? UPLOADED_DATA_BLOB_PREFIX : VIRTUAL_DATA_BLOB_PREFIX) + UUIDs.randomBase64UUID(), md, this.chunkSize());
                        indexCommitPointFiles.add(snapshotFileInfo);
                        if (needsWrite) {
                            filesToSnapshot.add(snapshotFileInfo);
                        }
                        assert (needsWrite || BlobStoreRepository.assertFileContentsMatchHash(snapshotFileInfo, store));
                        continue;
                    }
                    indexCommitPointFiles.add(existingFileInfo);
                }
            } else {
                for (BlobStoreIndexShardSnapshot.FileInfo fileInfo : filesFromSegmentInfos) {
                    ++indexTotalNumberOfFiles;
                    indexTotalFileSize += fileInfo.length();
                }
                indexCommitPointFiles = filesFromSegmentInfos;
            }
            snapshotStatus.moveToStarted(startTime, indexIncrementalFileCount, indexTotalNumberOfFiles, indexIncrementalSize, indexTotalFileSize);
            ArrayList<SnapshotFiles> newSnapshotsList = new ArrayList<SnapshotFiles>();
            newSnapshotsList.add(new SnapshotFiles(snapshotId.getName(), indexCommitPointFiles, shardStateIdentifier));
            for (SnapshotFiles point : snapshots) {
                newSnapshotsList.add(point);
            }
            BlobStoreIndexShardSnapshots updatedBlobStoreIndexShardSnapshots = new BlobStoreIndexShardSnapshots(newSnapshotsList);
            String indexGeneration = UUIDs.randomBase64UUID();
            try {
                INDEX_SHARD_SNAPSHOTS_FORMAT.write(updatedBlobStoreIndexShardSnapshots, shardContainer, indexGeneration, this.compressor);
            }
            catch (IOException e) {
                throw new IndexShardSnapshotFailedException(shardId, "Failed to write shard level snapshot metadata for [" + String.valueOf(snapshotId) + "] to [" + INDEX_SHARD_SNAPSHOTS_FORMAT.blobName(indexGeneration) + "]", e);
            }
            StepListener allFilesUploadedListener = new StepListener();
            allFilesUploadedListener.whenComplete(v -> {
                IndexShardSnapshotStatus.Copy lastSnapshotStatus = snapshotStatus.moveToFinalize(snapshotIndexCommit.getGeneration());
                logger.trace("[{}] [{}] writing shard snapshot file", (Object)shardId, (Object)snapshotId);
                try {
                    INDEX_SHARD_SNAPSHOT_FORMAT.write(new BlobStoreIndexShardSnapshot(snapshotId.getName(), lastSnapshotStatus.getIndexVersion(), indexCommitPointFiles, lastSnapshotStatus.getStartTime(), this.threadPool.absoluteTimeInMillis() - lastSnapshotStatus.getStartTime(), lastSnapshotStatus.getIncrementalFileCount(), lastSnapshotStatus.getIncrementalSize()), shardContainer, snapshotId.getUUID(), this.compressor);
                }
                catch (IOException e) {
                    throw new IndexShardSnapshotFailedException(shardId, "Failed to write commit point", e);
                }
                snapshotStatus.moveToDone(this.threadPool.absoluteTimeInMillis(), indexGeneration);
                listener.onResponse((Object)indexGeneration);
            }, arg_0 -> listener.onFailure(arg_0));
            if (indexIncrementalFileCount == 0) {
                allFilesUploadedListener.onResponse(Collections.emptyList());
                return;
            }
            ExecutorService executor = this.threadPool.executor(SNAPSHOT_CODEC);
            int workers = Math.min(this.threadPool.info(SNAPSHOT_CODEC).getMax(), indexIncrementalFileCount);
            ActionListener<Void> filesListener = BlobStoreRepository.fileQueueListener(filesToSnapshot, workers, allFilesUploadedListener);
            for (int i = 0; i < workers; ++i) {
                this.executeOneFileSnapshot(store, snapshotId, indexId, snapshotStatus, filesToSnapshot, executor, filesListener);
            }
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    private void executeOneFileSnapshot(Store store, SnapshotId snapshotId, IndexId indexId, IndexShardSnapshotStatus snapshotStatus, BlockingQueue<BlobStoreIndexShardSnapshot.FileInfo> filesToSnapshot, Executor executor, ActionListener<Void> listener) throws InterruptedException {
        ShardId shardId = store.shardId();
        BlobStoreIndexShardSnapshot.FileInfo snapshotFileInfo = filesToSnapshot.poll(0L, TimeUnit.MILLISECONDS);
        if (snapshotFileInfo == null) {
            listener.onResponse(null);
        } else {
            executor.execute((Runnable)ActionRunnable.wrap(listener, l -> {
                try (Releasable ignored = BlobStoreRepository.incrementStoreRef(store, snapshotStatus, shardId);){
                    this.snapshotFile(snapshotFileInfo, indexId, shardId, snapshotId, snapshotStatus, store);
                    this.executeOneFileSnapshot(store, snapshotId, indexId, snapshotStatus, filesToSnapshot, executor, (ActionListener<Void>)l);
                }
            }));
        }
    }

    private static Releasable incrementStoreRef(Store store, IndexShardSnapshotStatus snapshotStatus, ShardId shardId) {
        if (!store.tryIncRef()) {
            if (snapshotStatus.isAborted()) {
                throw new AbortedSnapshotException();
            }
            assert (false) : "Store should not be closed concurrently unless snapshot is aborted";
            throw new IndexShardSnapshotFailedException(shardId, "Store got closed concurrently");
        }
        return store::decRef;
    }

    private static boolean assertFileContentsMatchHash(BlobStoreIndexShardSnapshot.FileInfo fileInfo, Store store) {
        try (IndexInput indexInput = store.openVerifyingInput(fileInfo.physicalName(), IOContext.READONCE, fileInfo.metadata());){
            byte[] tmp = new byte[Math.toIntExact(fileInfo.metadata().length())];
            indexInput.readBytes(tmp, 0, tmp.length);
            assert (fileInfo.metadata().hash().bytesEquals(new BytesRef(tmp)));
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        return true;
    }

    @Override
    public void restoreShard(final Store store, SnapshotId snapshotId, IndexId indexId, ShardId snapshotShardId, RecoveryState recoveryState, ActionListener<Void> listener) {
        ShardId shardId = store.shardId();
        ActionListener<Void> restoreListener = ActionListenerHelper.delegateResponse(listener, (l, e) -> l.onFailure((Exception)new IndexShardRestoreFailedException(shardId, "failed to restore snapshot [" + String.valueOf(snapshotId) + "]", (Throwable)e)));
        final ExecutorService executor = this.threadPool.executor(SNAPSHOT_CODEC);
        final BlobContainer container = this.shardContainer(indexId, snapshotShardId);
        executor.execute((Runnable)ActionRunnable.wrap(restoreListener, l -> {
            IndexShardSnapshot indexShardSnapshot = this.loadShardSnapshot(container, snapshotId);
            assert (indexShardSnapshot instanceof BlobStoreIndexShardSnapshot) : "indexShardSnapshot should be an instance of BlobStoreIndexShardSnapshot";
            BlobStoreIndexShardSnapshot snapshot = (BlobStoreIndexShardSnapshot)indexShardSnapshot;
            final SnapshotFiles snapshotFiles = new SnapshotFiles(snapshot.snapshot(), snapshot.indexFiles(), null);
            new FileRestoreContext(this.metadata.name(), shardId, snapshotId, recoveryState){

                @Override
                protected void restoreFiles(List<BlobStoreIndexShardSnapshot.FileInfo> filesToRecover, Store store2, ActionListener<Void> listener) {
                    if (filesToRecover.isEmpty()) {
                        listener.onResponse(null);
                    } else {
                        int workers = Math.min(BlobStoreRepository.this.threadPool.info(BlobStoreRepository.SNAPSHOT_CODEC).getMax(), snapshotFiles.indexFiles().size());
                        LinkedBlockingQueue<BlobStoreIndexShardSnapshot.FileInfo> files = new LinkedBlockingQueue<BlobStoreIndexShardSnapshot.FileInfo>(filesToRecover);
                        ActionListener<Void> allFilesListener = BlobStoreRepository.fileQueueListener(files, workers, ActionListenerHelper.map(listener, v -> null));
                        for (int i = 0; i < workers; ++i) {
                            try {
                                this.executeOneFileRestore(files, allFilesListener);
                                continue;
                            }
                            catch (Exception e) {
                                allFilesListener.onFailure(e);
                            }
                        }
                    }
                }

                private void executeOneFileRestore(BlockingQueue<BlobStoreIndexShardSnapshot.FileInfo> files, ActionListener<Void> allFilesListener) throws InterruptedException {
                    BlobStoreIndexShardSnapshot.FileInfo fileToRecover = files.poll(0L, TimeUnit.MILLISECONDS);
                    if (fileToRecover == null) {
                        allFilesListener.onResponse(null);
                    } else {
                        executor.execute((Runnable)ActionRunnable.wrap(allFilesListener, filesListener -> {
                            store.incRef();
                            try {
                                this.restoreFile(fileToRecover, store);
                            }
                            finally {
                                store.decRef();
                            }
                            this.executeOneFileRestore(files, (ActionListener<Void>)filesListener);
                        }));
                    }
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                private void restoreFile(final BlobStoreIndexShardSnapshot.FileInfo fileInfo, final Store store2) throws IOException {
                    this.ensureNotClosing(store2);
                    FileRestoreContext.logger.trace(() -> new ParameterizedMessage("[{}] restoring [{}] to [{}]", new Object[]{BlobStoreRepository.this.metadata.name(), fileInfo, store2}));
                    boolean success = false;
                    try {
                        try (IndexOutput indexOutput = store2.createVerifyingOutput(fileInfo.physicalName(), fileInfo.metadata(), IOContext.READONCE);){
                            if (fileInfo.name().startsWith(BlobStoreRepository.VIRTUAL_DATA_BLOB_PREFIX)) {
                                BytesRef hash = fileInfo.metadata().hash();
                                indexOutput.writeBytes(hash.bytes, hash.offset, hash.length);
                                this.recoveryState.getIndex().addRecoveredBytesToFile(fileInfo.physicalName(), hash.length);
                            } else {
                                try (InputStream stream = BlobStoreRepository.this.maybeRateLimitRestores(new SlicedInputStream(fileInfo.numberOfParts()){

                                    @Override
                                    protected InputStream openSlice(int slice) throws IOException {
                                        this.ensureNotClosing(store2);
                                        return container.readBlob(fileInfo.partName(slice));
                                    }
                                });){
                                    int length;
                                    byte[] buffer = new byte[Math.toIntExact(Math.min((long)BlobStoreRepository.this.bufferSize, fileInfo.length()))];
                                    while ((length = stream.read(buffer)) > 0) {
                                        this.ensureNotClosing(store2);
                                        indexOutput.writeBytes(buffer, 0, length);
                                        this.recoveryState.getIndex().addRecoveredBytesToFile(fileInfo.physicalName(), length);
                                    }
                                }
                            }
                            Store.verify(indexOutput);
                            indexOutput.close();
                            store2.directory().sync(Collections.singleton(fileInfo.physicalName()));
                            success = true;
                        }
                        if (success) return;
                    }
                    catch (CorruptIndexException | IndexFormatTooNewException | IndexFormatTooOldException ex) {
                        try {
                            try {
                                store2.markStoreCorrupted((IOException)ex);
                                throw ex;
                            }
                            catch (IOException e) {
                                FileRestoreContext.logger.warn("store cannot be marked as corrupted", (Throwable)e);
                            }
                            throw ex;
                        }
                        catch (Throwable throwable) {
                            if (success) throw throwable;
                            store2.deleteQuiet(fileInfo.physicalName());
                            throw throwable;
                        }
                    }
                    store2.deleteQuiet(fileInfo.physicalName());
                    return;
                }

                void ensureNotClosing(Store store2) throws AlreadyClosedException {
                    assert (store2.refCount() > 0);
                    if (store2.isClosing()) {
                        throw new AlreadyClosedException("store is closing");
                    }
                }
            }.restore(snapshotFiles, store, (ActionListener<Void>)l);
        }));
    }

    private static ActionListener<Void> fileQueueListener(BlockingQueue<BlobStoreIndexShardSnapshot.FileInfo> files, int workers, ActionListener<Collection<Void>> listener) {
        return ActionListenerHelper.delegateResponse(new GroupedActionListener<Void>(listener, workers), (l, e) -> {
            files.clear();
            l.onFailure(e);
        });
    }

    private static void mayBeLogRateLimits(BlobStoreTransferContext context, RateLimiter rateLimiter, long time) {
        logger.debug(() -> new ParameterizedMessage("Rate limited blob store transfer, context [{}], for duration [{} ms] for configured rate [{} MBps]", new Object[]{context, TimeValue.timeValueNanos((long)time).millis(), rateLimiter.getMBPerSec()}));
    }

    private static InputStream maybeRateLimit(InputStream stream, Supplier<RateLimiter> rateLimiterSupplier, CounterMetric metric, BlobStoreTransferContext context) {
        return new RateLimitingInputStream(stream, rateLimiterSupplier, t -> {
            BlobStoreRepository.mayBeLogRateLimits(context, (RateLimiter)rateLimiterSupplier.get(), t);
            metric.inc(t);
        });
    }

    private static OffsetRangeInputStream maybeRateLimitRemoteTransfers(OffsetRangeInputStream offsetRangeInputStream, Supplier<RateLimiter> rateLimiterSupplier, CounterMetric metric, BlobStoreTransferContext context) {
        return new RateLimitingOffsetRangeInputStream(offsetRangeInputStream, rateLimiterSupplier, t -> {
            BlobStoreRepository.mayBeLogRateLimits(context, (RateLimiter)rateLimiterSupplier.get(), t);
            metric.inc(t);
        });
    }

    public InputStream maybeRateLimitRestores(InputStream stream) {
        return BlobStoreRepository.maybeRateLimit(BlobStoreRepository.maybeRateLimit(stream, () -> this.restoreRateLimiter, this.restoreRateLimitingTimeInNanos, BlobStoreTransferContext.SNAPSHOT_RESTORE), this.recoverySettings::rateLimiter, this.restoreRateLimitingTimeInNanos, BlobStoreTransferContext.SNAPSHOT_RESTORE);
    }

    public OffsetRangeInputStream maybeRateLimitRemoteUploadTransfers(OffsetRangeInputStream offsetRangeInputStream) {
        return BlobStoreRepository.maybeRateLimitRemoteTransfers(offsetRangeInputStream, () -> this.remoteUploadRateLimiter, this.remoteUploadRateLimitingTimeInNanos, BlobStoreTransferContext.REMOTE_UPLOAD);
    }

    public InputStream maybeRateLimitRemoteDownloadTransfers(InputStream inputStream) {
        return BlobStoreRepository.maybeRateLimit(BlobStoreRepository.maybeRateLimit(inputStream, () -> this.remoteDownloadRateLimiter, this.remoteDownloadRateLimitingTimeInNanos, BlobStoreTransferContext.REMOTE_DOWNLOAD), this.recoverySettings::rateLimiter, this.remoteDownloadRateLimitingTimeInNanos, BlobStoreTransferContext.REMOTE_DOWNLOAD);
    }

    public InputStream maybeRateLimitSnapshots(InputStream stream) {
        return BlobStoreRepository.maybeRateLimit(stream, () -> this.snapshotRateLimiter, this.snapshotRateLimitingTimeInNanos, BlobStoreTransferContext.SNAPSHOT);
    }

    @Override
    public List<Setting<?>> getRestrictedSystemRepositorySettings() {
        return Arrays.asList(BlobStoreRepositorySettings.SYSTEM_REPOSITORY_SETTING, BlobStoreRepositorySettings.READONLY_SETTING, BlobStoreRepositorySettings.REMOTE_STORE_INDEX_SHALLOW_COPY);
    }

    @Override
    public RemoteStoreShardShallowCopySnapshot getRemoteStoreShallowCopyShardMetadata(SnapshotId snapshotId, IndexId indexId, ShardId snapshotShardId) {
        BlobContainer container = this.shardContainer(indexId, snapshotShardId);
        IndexShardSnapshot indexShardSnapshot = this.loadShardSnapshot(container, snapshotId);
        assert (indexShardSnapshot instanceof RemoteStoreShardShallowCopySnapshot) : "indexShardSnapshot should be an instance of RemoteStoreShardShallowCopySnapshot";
        return (RemoteStoreShardShallowCopySnapshot)indexShardSnapshot;
    }

    @Override
    public IndexShardSnapshotStatus getShardSnapshotStatus(SnapshotId snapshotId, IndexId indexId, ShardId shardId) {
        IndexShardSnapshot snapshot = this.loadShardSnapshot(this.shardContainer(indexId, shardId), snapshotId);
        return snapshot.getIndexShardSnapshotStatus();
    }

    @Override
    public void verify(String seed, DiscoveryNode localNode) {
        if (!this.isSystemRepository) {
            this.assertSnapshotOrGenericThread();
        }
        if (this.isReadOnly()) {
            try {
                this.latestIndexBlobId();
            }
            catch (Exception e) {
                throw new RepositoryVerificationException(this.metadata.name(), "path " + String.valueOf(this.basePath()) + " is not accessible on node " + String.valueOf(localNode), e);
            }
        }
        BlobContainer testBlobContainer = this.blobStore().blobContainer(this.basePath().add(BlobStoreRepository.testBlobPrefix(seed)));
        try {
            BytesArray bytes = new BytesArray(seed);
            try (StreamInput stream = bytes.streamInput();){
                testBlobContainer.writeBlob("data-" + localNode.getId() + ".dat", (InputStream)stream, (long)bytes.length(), true);
            }
        }
        catch (Exception exp) {
            throw new RepositoryVerificationException(this.metadata.name(), "store location [" + String.valueOf(this.blobStore()) + "] is not accessible on the node [" + String.valueOf(localNode) + "]", exp);
        }
        if (!this.isSystemRepository) {
            try (InputStream masterDat = testBlobContainer.readBlob("master.dat");){
                String seedRead = Streams.readFully(masterDat).utf8ToString();
                if (!seedRead.equals(seed)) {
                    throw new RepositoryVerificationException(this.metadata.name(), "Seed read from master.dat was [" + seedRead + "] but expected seed [" + seed + "]");
                }
            }
            catch (NoSuchFileException e) {
                throw new RepositoryVerificationException(this.metadata.name(), "a file written by cluster-manager to the store [" + String.valueOf(this.blobStore()) + "] cannot be accessed on the node [" + String.valueOf(localNode) + "]. This might indicate that the store [" + String.valueOf(this.blobStore()) + "] is not shared between this node and the cluster-manager node or that permissions on the store don't allow reading files written by the cluster-manager node", e);
            }
            catch (Exception e) {
                throw new RepositoryVerificationException(this.metadata.name(), "Failed to verify repository", e);
            }
        }
    }

    public String toString() {
        return "BlobStoreRepository[[" + this.metadata.name() + "], [" + String.valueOf(this.blobStore.get()) + "]]";
    }

    private ShardSnapshotMetaDeleteResult deleteFromShardSnapshotMeta(Set<SnapshotId> survivingSnapshots, IndexId indexId, int snapshotShardId, Collection<SnapshotId> snapshotIds, BlobContainer shardContainer, Set<String> blobs, BlobStoreIndexShardSnapshots snapshots, long indexGeneration, RemoteStoreLockManagerFactory remoteStoreLockManagerFactory) {
        ArrayList<SnapshotFiles> newSnapshotsList = new ArrayList<SnapshotFiles>();
        Set survivingSnapshotNames = survivingSnapshots.stream().map(SnapshotId::getName).collect(Collectors.toSet());
        for (SnapshotFiles point : snapshots) {
            if (!survivingSnapshotNames.contains(point.snapshot())) continue;
            newSnapshotsList.add(point);
        }
        String writtenGeneration = null;
        try {
            BlobStoreIndexShardSnapshots updatedSnapshots;
            if (survivingSnapshots.isEmpty()) {
                return new ShardSnapshotMetaDeleteResult(indexId, snapshotShardId, "_deleted", blobs);
            }
            if (newSnapshotsList.size() > 0) {
                updatedSnapshots = new BlobStoreIndexShardSnapshots(newSnapshotsList);
                if (indexGeneration < 0L) {
                    writtenGeneration = UUIDs.randomBase64UUID();
                    INDEX_SHARD_SNAPSHOTS_FORMAT.write(updatedSnapshots, shardContainer, writtenGeneration, this.compressor);
                } else {
                    writtenGeneration = String.valueOf(indexGeneration);
                    this.writeShardIndexBlobAtomic(shardContainer, indexGeneration, updatedSnapshots);
                }
            } else {
                updatedSnapshots = BlobStoreIndexShardSnapshots.EMPTY;
                writtenGeneration = "_deleted";
            }
            Set<String> survivingSnapshotUUIDs = survivingSnapshots.stream().map(SnapshotId::getUUID).collect(Collectors.toSet());
            return new ShardSnapshotMetaDeleteResult(indexId, snapshotShardId, writtenGeneration, BlobStoreRepository.unusedBlobs(blobs, survivingSnapshotUUIDs, updatedSnapshots, remoteStoreLockManagerFactory));
        }
        catch (IOException e) {
            throw new RepositoryException(this.metadata.name(), "Failed to finalize snapshot deletion " + String.valueOf(snapshotIds) + " with shard index [" + INDEX_SHARD_SNAPSHOTS_FORMAT.blobName(writtenGeneration) + "]", e);
        }
    }

    private void writeShardIndexBlobAtomic(BlobContainer shardContainer, long indexGeneration, BlobStoreIndexShardSnapshots updatedSnapshots) throws IOException {
        assert (indexGeneration >= 0L) : "Shard generation must not be negative but saw [" + indexGeneration + "]";
        logger.trace(() -> new ParameterizedMessage("[{}] Writing shard index [{}] to [{}]", new Object[]{this.metadata.name(), indexGeneration, shardContainer.path()}));
        String blobName = INDEX_SHARD_SNAPSHOTS_FORMAT.blobName(String.valueOf(indexGeneration));
        this.writeAtomic(shardContainer, blobName, INDEX_SHARD_SNAPSHOTS_FORMAT.serialize(updatedSnapshots, blobName, this.compressor, ChecksumBlobStoreFormat.SNAPSHOT_ONLY_FORMAT_PARAMS), true);
    }

    private static List<String> unusedBlobs(Set<String> blobs, Set<String> survivingSnapshotUUIDs, BlobStoreIndexShardSnapshots updatedSnapshots, RemoteStoreLockManagerFactory remoteStoreLockManagerFactory) {
        return blobs.stream().filter(blob -> {
            if (blob.startsWith("index-")) return true;
            if (blob.startsWith(SNAPSHOT_PREFIX) && blob.endsWith(".dat")) {
                if (!survivingSnapshotUUIDs.contains(blob.substring(SNAPSHOT_PREFIX.length(), blob.length() - ".dat".length()))) return true;
            }
            if (remoteStoreLockManagerFactory != null) {
                if (BlobStoreRepository.extractShallowSnapshotUUID(blob).map(survivingSnapshotUUIDs::contains).orElse(false) != false) return true;
            }
            if (blob.startsWith(UPLOADED_DATA_BLOB_PREFIX)) {
                if (updatedSnapshots.findNameFile(BlobStoreIndexShardSnapshot.FileInfo.canonicalName(blob)) == null) return true;
            }
            if (!FsBlobContainer.isTempBlobName(blob)) return false;
            return true;
        }).collect(Collectors.toList());
    }

    public IndexShardSnapshot loadShardSnapshot(BlobContainer shardContainer, SnapshotId snapshotId) {
        try {
            if (shardContainer.blobExists(INDEX_SHARD_SNAPSHOT_FORMAT.blobName(snapshotId.getUUID()))) {
                return INDEX_SHARD_SNAPSHOT_FORMAT.read(shardContainer, snapshotId.getUUID(), this.namedXContentRegistry);
            }
            if (shardContainer.blobExists(REMOTE_STORE_SHARD_SHALLOW_COPY_SNAPSHOT_FORMAT.blobName(snapshotId.getUUID()))) {
                return REMOTE_STORE_SHARD_SHALLOW_COPY_SNAPSHOT_FORMAT.read(shardContainer, snapshotId.getUUID(), this.namedXContentRegistry);
            }
            throw new SnapshotMissingException(this.metadata.name(), snapshotId.getName());
        }
        catch (IOException ex) {
            throw new SnapshotException(this.metadata.name(), snapshotId, "failed to read shard snapshot file for [" + String.valueOf(shardContainer.path()) + "]", (Throwable)ex);
        }
    }

    private Tuple<BlobStoreIndexShardSnapshots, String> buildBlobStoreIndexShardSnapshots(Set<String> blobs, BlobContainer shardContainer, @Nullable String generation) throws IOException {
        if (generation != null) {
            if (generation.equals("_new")) {
                return new Tuple((Object)BlobStoreIndexShardSnapshots.EMPTY, (Object)"_new");
            }
            return new Tuple((Object)INDEX_SHARD_SNAPSHOTS_FORMAT.read(shardContainer, generation, this.namedXContentRegistry), (Object)generation);
        }
        Tuple<BlobStoreIndexShardSnapshots, Long> legacyIndex = this.buildBlobStoreIndexShardSnapshots(blobs, shardContainer);
        return new Tuple((Object)((BlobStoreIndexShardSnapshots)legacyIndex.v1()), (Object)String.valueOf(legacyIndex.v2()));
    }

    private Tuple<BlobStoreIndexShardSnapshots, Long> buildBlobStoreIndexShardSnapshots(Set<String> blobs, BlobContainer shardContainer) throws IOException {
        long latest = this.latestGeneration(blobs);
        if (latest >= 0L) {
            BlobStoreIndexShardSnapshots shardSnapshots = INDEX_SHARD_SNAPSHOTS_FORMAT.read(shardContainer, Long.toString(latest), this.namedXContentRegistry);
            return new Tuple((Object)shardSnapshots, (Object)latest);
        }
        if (blobs.stream().anyMatch(b -> b.startsWith(SNAPSHOT_PREFIX) || b.startsWith("index-") || b.startsWith(UPLOADED_DATA_BLOB_PREFIX))) {
            logger.warn("Could not find a readable index-N file in a non-empty shard snapshot directory [" + String.valueOf(shardContainer.path()) + "]");
        }
        return new Tuple((Object)BlobStoreIndexShardSnapshots.EMPTY, (Object)latest);
    }

    private void snapshotFile(final BlobStoreIndexShardSnapshot.FileInfo fileInfo, IndexId indexId, final ShardId shardId, final SnapshotId snapshotId, final IndexShardSnapshotStatus snapshotStatus, Store store) throws IOException {
        BlobContainer shardContainer = this.shardContainer(indexId, shardId);
        String file = fileInfo.physicalName();
        try (IndexInput indexInput = store.openVerifyingInput(file, IOContext.READONCE, fileInfo.metadata());){
            for (int i = 0; i < fileInfo.numberOfParts(); ++i) {
                long partBytes = fileInfo.partBytes(i);
                FilterInputStream inputStream = new FilterInputStream(this, this.maybeRateLimitSnapshots(new InputStreamIndexInput(indexInput, partBytes))){

                    @Override
                    public int read() throws IOException {
                        this.checkAborted();
                        return super.read();
                    }

                    @Override
                    public int read(byte[] b, int off, int len) throws IOException {
                        this.checkAborted();
                        return super.read(b, off, len);
                    }

                    private void checkAborted() {
                        if (snapshotStatus.isAborted()) {
                            logger.debug("[{}] [{}] Aborted on the file [{}], exiting", (Object)shardId, (Object)snapshotId, (Object)fileInfo.physicalName());
                            throw new AbortedSnapshotException();
                        }
                    }
                };
                String partName = fileInfo.partName(i);
                logger.trace(() -> new ParameterizedMessage("[{}] Writing [{}] to [{}]", new Object[]{this.metadata.name(), partName, shardContainer.path()}));
                shardContainer.writeBlob(partName, (InputStream)inputStream, partBytes, false);
            }
            Store.verify(indexInput);
            snapshotStatus.addProcessedFile(fileInfo.length());
        }
        catch (Exception t) {
            BlobStoreRepository.failStoreIfCorrupted(store, t);
            snapshotStatus.addProcessedFile(0L);
            throw t;
        }
    }

    private static void failStoreIfCorrupted(Store store, Exception e) {
        if (Lucene.isCorruptionException(e)) {
            try {
                store.markStoreCorrupted((IOException)e);
            }
            catch (IOException inner) {
                inner.addSuppressed(e);
                logger.warn("store cannot be marked as corrupted", (Throwable)inner);
            }
        }
    }

    private static Optional<String> extractShallowSnapshotUUID(String blobName) {
        if (blobName.startsWith(SHALLOW_SNAPSHOT_PREFIX)) {
            return Optional.of(blobName.substring(SHALLOW_SNAPSHOT_PREFIX.length(), blobName.length() - ".dat".length()));
        }
        return Optional.empty();
    }

    static enum BlobStoreTransferContext {
        REMOTE_UPLOAD("remote_upload"),
        REMOTE_DOWNLOAD("remote_download"),
        SNAPSHOT("snapshot"),
        SNAPSHOT_RESTORE("snapshot_restore");

        private final String name;

        private BlobStoreTransferContext(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    private static final class ShardSnapshotMetaDeleteResult {
        private final IndexId indexId;
        private final int shardId;
        private final String newGeneration;
        private final Collection<String> blobsToDelete;

        ShardSnapshotMetaDeleteResult(IndexId indexId, int shardId, String newGeneration, Collection<String> blobsToDelete) {
            this.indexId = indexId;
            this.shardId = shardId;
            this.newGeneration = newGeneration;
            this.blobsToDelete = blobsToDelete;
        }
    }
}

