/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.repositories.blobstore;

import io.skylite.common.util.concurrent.ConcurrentCollections;
import io.skylite.core.index.shard.ShardId;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RemoteStoreShardCleanupTask
implements Runnable {
    private final Runnable task;
    private final String shardIdentifier;
    static final Set<String> ongoingRemoteDirectoryCleanups = ConcurrentCollections.newConcurrentSet();
    static final Map<String, Runnable> pendingRemoteDirectoryCleanups = ConcurrentCollections.newConcurrentMap();
    private static final Logger staticLogger = LogManager.getLogger(RemoteStoreShardCleanupTask.class);

    public RemoteStoreShardCleanupTask(Runnable task, String indexUUID, ShardId shardId) {
        this.task = task;
        this.shardIdentifier = RemoteStoreShardCleanupTask.indexShardIdentifier(indexUUID, shardId);
    }

    private static String indexShardIdentifier(String indexUUID, ShardId shardId) {
        return String.join((CharSequence)"/", indexUUID, String.valueOf(shardId.id()));
    }

    @Override
    public void run() {
        if (pendingRemoteDirectoryCleanups.put(this.shardIdentifier, this.task) == null) {
            if (ongoingRemoteDirectoryCleanups.add(this.shardIdentifier)) {
                while (pendingRemoteDirectoryCleanups.containsKey(this.shardIdentifier)) {
                    Runnable newTask = pendingRemoteDirectoryCleanups.get(this.shardIdentifier);
                    pendingRemoteDirectoryCleanups.remove(this.shardIdentifier);
                    newTask.run();
                }
                ongoingRemoteDirectoryCleanups.remove(this.shardIdentifier);
            } else {
                staticLogger.debug("one task is already ongoing for shard {}, we can leave entry in pending", (Object)this.shardIdentifier);
            }
        } else {
            staticLogger.debug("one cleanup task for shard {} is already in pending, we can skip this task", (Object)this.shardIdentifier);
        }
    }
}

