/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.search;

import io.skylite.core.ParseField;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.search.SearchExtBuilder;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParseException;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class GenericSearchExtBuilder
extends SearchExtBuilder {
    public static final ParseField EXT_BUILDER_NAME = new ParseField("generic_ext", new String[0]);
    private final Object genericObj;
    private final ValueType valueType;

    public GenericSearchExtBuilder(Object genericObj, ValueType valueType) {
        this.genericObj = genericObj;
        this.valueType = valueType;
    }

    public GenericSearchExtBuilder(StreamInput in) throws IOException {
        this.valueType = ValueType.fromInt(in.readInt());
        switch (this.valueType.ordinal()) {
            case 0: {
                this.genericObj = in.readGenericValue();
                break;
            }
            case 1: {
                this.genericObj = in.readMap();
                break;
            }
            case 2: {
                this.genericObj = in.readList(r -> r.readGenericValue());
                break;
            }
            default: {
                throw new IllegalStateException("Unable to construct GenericSearchExtBuilder from incoming stream.");
            }
        }
    }

    public static GenericSearchExtBuilder fromXContent(XContentParser parser) throws IOException {
        ValueType valueType;
        Object genericObj;
        XContentParser.Token token = parser.currentToken();
        if (token == XContentParser.Token.START_OBJECT) {
            genericObj = parser.map();
            valueType = ValueType.MAP;
        } else if (token == XContentParser.Token.START_ARRAY) {
            genericObj = parser.list();
            valueType = ValueType.LIST;
        } else if (token.isValue()) {
            genericObj = parser.objectText();
            valueType = ValueType.SIMPLE;
        } else {
            throw new XContentParseException("Unknown token: " + String.valueOf((Object)token));
        }
        return new GenericSearchExtBuilder(genericObj, valueType);
    }

    @Override
    public String getWriteableName() {
        return EXT_BUILDER_NAME.getPreferredName();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeInt(this.valueType.getValue());
        switch (this.valueType.ordinal()) {
            case 0: {
                out.writeGenericValue(this.genericObj);
                break;
            }
            case 1: {
                out.writeMap((Map)this.genericObj);
                break;
            }
            case 2: {
                out.writeCollection((List)this.genericObj, StreamOutput::writeGenericValue);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown valueType: " + String.valueOf((Object)this.valueType));
            }
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        switch (this.valueType.ordinal()) {
            case 0: {
                return builder.field(EXT_BUILDER_NAME.getPreferredName(), this.genericObj);
            }
            case 1: {
                return builder.field(EXT_BUILDER_NAME.getPreferredName(), (Map)this.genericObj);
            }
            case 2: {
                return builder.field(EXT_BUILDER_NAME.getPreferredName(), (List)this.genericObj);
            }
        }
        return null;
    }

    Object getValue() {
        return this.genericObj;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.valueType, this.genericObj});
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GenericSearchExtBuilder)) {
            return false;
        }
        return Objects.equals(this.getValue(), ((GenericSearchExtBuilder)obj).getValue()) && Objects.equals((Object)this.valueType, (Object)((GenericSearchExtBuilder)obj).valueType);
    }

    public static enum ValueType {
        SIMPLE(0),
        MAP(1),
        LIST(2);

        private final int value;

        private ValueType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        static ValueType fromInt(int value) {
            switch (value) {
                case 0: {
                    return SIMPLE;
                }
                case 1: {
                    return MAP;
                }
                case 2: {
                    return LIST;
                }
            }
            throw new IllegalArgumentException("Unsupported value: " + value);
        }
    }
}

