/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.search;

import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.index.fielddata.AbstractBinaryDocValues;
import io.skylite.core.index.fielddata.AbstractNumericDocValues;
import io.skylite.core.index.fielddata.AbstractSortedDocValues;
import io.skylite.core.index.fielddata.FieldData;
import io.skylite.core.index.fielddata.NumericDoubleValues;
import io.skylite.core.index.fielddata.SortedBinaryDocValues;
import io.skylite.core.index.fielddata.SortedNumericDoubleValues;
import java.io.IOException;
import java.util.Locale;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;

public enum MultiValueMode implements Writeable
{
    SUM{

        @Override
        protected long pick(SortedNumericDocValues values) throws IOException {
            int count = values.docValueCount();
            long total = 0L;
            for (int index = 0; index < count; ++index) {
                total += values.nextValue();
            }
            return total;
        }

        @Override
        protected long pick(SortedNumericDocValues values, long missingValue, DocIdSetIterator docItr, int startDoc, int endDoc, int maxChildren) throws IOException {
            int totalCount = 0;
            long totalValue = 0L;
            int count = 0;
            int doc = startDoc;
            while (doc < endDoc) {
                if (values.advanceExact(doc)) {
                    if (++count > maxChildren) break;
                    int docCount = values.docValueCount();
                    for (int index = 0; index < docCount; ++index) {
                        totalValue += values.nextValue();
                    }
                    totalCount += docCount;
                }
                doc = docItr.nextDoc();
            }
            return totalCount > 0 ? totalValue : missingValue;
        }

        @Override
        protected double pick(SortedNumericDoubleValues values) throws IOException {
            int count = values.docValueCount();
            double total = 0.0;
            for (int index = 0; index < count; ++index) {
                total += values.nextValue();
            }
            return total;
        }

        @Override
        protected double pick(SortedNumericDoubleValues values, double missingValue, DocIdSetIterator docItr, int startDoc, int endDoc, int maxChildren) throws IOException {
            int totalCount = 0;
            double totalValue = 0.0;
            int count = 0;
            int doc = startDoc;
            while (doc < endDoc) {
                if (values.advanceExact(doc)) {
                    if (++count > maxChildren) break;
                    int docCount = values.docValueCount();
                    for (int index = 0; index < docCount; ++index) {
                        totalValue += values.nextValue();
                    }
                    totalCount += docCount;
                }
                doc = docItr.nextDoc();
            }
            return totalCount > 0 ? totalValue : missingValue;
        }
    }
    ,
    AVG{

        @Override
        protected long pick(SortedNumericDocValues values) throws IOException {
            int count = values.docValueCount();
            long total = 0L;
            for (int index = 0; index < count; ++index) {
                total += values.nextValue();
            }
            return count > 1 ? Math.round((double)total / (double)count) : total;
        }

        @Override
        protected long pick(SortedNumericDocValues values, long missingValue, DocIdSetIterator docItr, int startDoc, int endDoc, int maxChildren) throws IOException {
            int totalCount = 0;
            long totalValue = 0L;
            int count = 0;
            int doc = startDoc;
            while (doc < endDoc) {
                if (values.advanceExact(doc)) {
                    if (++count > maxChildren) break;
                    int docCount = values.docValueCount();
                    for (int index = 0; index < docCount; ++index) {
                        totalValue += values.nextValue();
                    }
                    totalCount += docCount;
                }
                doc = docItr.nextDoc();
            }
            if (totalCount < 1) {
                return missingValue;
            }
            return totalCount > 1 ? Math.round((double)totalValue / (double)totalCount) : totalValue;
        }

        @Override
        protected double pick(SortedNumericDoubleValues values) throws IOException {
            int count = values.docValueCount();
            double total = 0.0;
            for (int index = 0; index < count; ++index) {
                total += values.nextValue();
            }
            return total / (double)count;
        }

        @Override
        protected double pick(SortedNumericDoubleValues values, double missingValue, DocIdSetIterator docItr, int startDoc, int endDoc, int maxChildren) throws IOException {
            int totalCount = 0;
            double totalValue = 0.0;
            int count = 0;
            int doc = startDoc;
            while (doc < endDoc) {
                if (values.advanceExact(doc)) {
                    if (++count > maxChildren) break;
                    int docCount = values.docValueCount();
                    for (int index = 0; index < docCount; ++index) {
                        totalValue += values.nextValue();
                    }
                    totalCount += docCount;
                }
                doc = docItr.nextDoc();
            }
            if (totalCount < 1) {
                return missingValue;
            }
            return totalValue / (double)totalCount;
        }
    }
    ,
    MEDIAN{

        @Override
        protected long pick(SortedNumericDocValues values) throws IOException {
            int count = values.docValueCount();
            for (int i = 0; i < (count - 1) / 2; ++i) {
                values.nextValue();
            }
            if (count % 2 == 0) {
                return Math.round(((double)values.nextValue() + (double)values.nextValue()) / 2.0);
            }
            return values.nextValue();
        }

        @Override
        protected double pick(SortedNumericDoubleValues values) throws IOException {
            int count = values.docValueCount();
            for (int i = 0; i < (count - 1) / 2; ++i) {
                values.nextValue();
            }
            if (count % 2 == 0) {
                return (values.nextValue() + values.nextValue()) / 2.0;
            }
            return values.nextValue();
        }
    }
    ,
    MIN{

        @Override
        protected long pick(SortedNumericDocValues values) throws IOException {
            return values.nextValue();
        }

        @Override
        protected long pick(SortedNumericDocValues values, long missingValue, DocIdSetIterator docItr, int startDoc, int endDoc, int maxChildren) throws IOException {
            boolean hasValue = false;
            long minValue = Long.MAX_VALUE;
            int count = 0;
            int doc = startDoc;
            while (doc < endDoc) {
                if (values.advanceExact(doc)) {
                    if (++count > maxChildren) break;
                    minValue = Math.min(minValue, values.nextValue());
                    hasValue = true;
                }
                doc = docItr.nextDoc();
            }
            return hasValue ? minValue : missingValue;
        }

        @Override
        protected double pick(SortedNumericDoubleValues values) throws IOException {
            return values.nextValue();
        }

        @Override
        protected double pick(SortedNumericDoubleValues values, double missingValue, DocIdSetIterator docItr, int startDoc, int endDoc, int maxChildren) throws IOException {
            boolean hasValue = false;
            double minValue = Double.POSITIVE_INFINITY;
            int count = 0;
            int doc = startDoc;
            while (doc < endDoc) {
                if (values.advanceExact(doc)) {
                    if (++count > maxChildren) break;
                    minValue = Math.min(minValue, values.nextValue());
                    hasValue = true;
                }
                doc = docItr.nextDoc();
            }
            return hasValue ? minValue : missingValue;
        }

        @Override
        protected BytesRef pick(SortedBinaryDocValues values) throws IOException {
            return values.nextValue();
        }

        @Override
        protected BytesRef pick(BinaryDocValues values, BytesRefBuilder builder, DocIdSetIterator docItr, int startDoc, int endDoc, int maxChildren) throws IOException {
            BytesRefBuilder bytesRefBuilder = null;
            int count = 0;
            int doc = startDoc;
            while (doc < endDoc) {
                if (values.advanceExact(doc)) {
                    if (++count > maxChildren) break;
                    BytesRef innerValue = values.binaryValue();
                    if (bytesRefBuilder == null) {
                        builder.copyBytes(innerValue);
                        bytesRefBuilder = builder;
                    } else {
                        BytesRef min;
                        BytesRef bytesRef = min = bytesRefBuilder.get().compareTo(innerValue) <= 0 ? bytesRefBuilder.get() : innerValue;
                        if (min == innerValue) {
                            bytesRefBuilder.copyBytes(min);
                        }
                    }
                }
                doc = docItr.nextDoc();
            }
            return bytesRefBuilder == null ? null : bytesRefBuilder.get();
        }

        @Override
        protected int pick(SortedSetDocValues values) throws IOException {
            return Math.toIntExact(values.nextOrd());
        }

        @Override
        protected int pick(SortedDocValues values, DocIdSetIterator docItr, int startDoc, int endDoc, int maxChildren) throws IOException {
            int ord = Integer.MAX_VALUE;
            boolean hasValue = false;
            int count = 0;
            int doc = startDoc;
            while (doc < endDoc) {
                if (values.advanceExact(doc)) {
                    if (++count > maxChildren) break;
                    int innerOrd = values.ordValue();
                    ord = Math.min(ord, innerOrd);
                    hasValue = true;
                }
                doc = docItr.nextDoc();
            }
            return hasValue ? ord : -1;
        }
    }
    ,
    MAX{

        @Override
        protected long pick(SortedNumericDocValues values) throws IOException {
            int count = values.docValueCount();
            for (int i = 0; i < count - 1; ++i) {
                values.nextValue();
            }
            return values.nextValue();
        }

        @Override
        protected long pick(SortedNumericDocValues values, long missingValue, DocIdSetIterator docItr, int startDoc, int endDoc, int maxChildren) throws IOException {
            boolean hasValue = false;
            long maxValue = Long.MIN_VALUE;
            int count = 0;
            int doc = startDoc;
            while (doc < endDoc) {
                if (values.advanceExact(doc)) {
                    if (++count > maxChildren) break;
                    int docCount = values.docValueCount();
                    for (int i = 0; i < docCount - 1; ++i) {
                        values.nextValue();
                    }
                    maxValue = Math.max(maxValue, values.nextValue());
                    hasValue = true;
                }
                doc = docItr.nextDoc();
            }
            return hasValue ? maxValue : missingValue;
        }

        @Override
        protected double pick(SortedNumericDoubleValues values) throws IOException {
            int count = values.docValueCount();
            for (int i = 0; i < count - 1; ++i) {
                values.nextValue();
            }
            return values.nextValue();
        }

        @Override
        protected double pick(SortedNumericDoubleValues values, double missingValue, DocIdSetIterator docItr, int startDoc, int endDoc, int maxChildren) throws IOException {
            boolean hasValue = false;
            double maxValue = Double.NEGATIVE_INFINITY;
            int count = 0;
            int doc = startDoc;
            while (doc < endDoc) {
                if (values.advanceExact(doc)) {
                    if (++count > maxChildren) break;
                    int docCount = values.docValueCount();
                    for (int i = 0; i < docCount - 1; ++i) {
                        values.nextValue();
                    }
                    maxValue = Math.max(maxValue, values.nextValue());
                    hasValue = true;
                }
                doc = docItr.nextDoc();
            }
            return hasValue ? maxValue : missingValue;
        }

        @Override
        protected BytesRef pick(SortedBinaryDocValues values) throws IOException {
            int count = values.docValueCount();
            for (int i = 0; i < count - 1; ++i) {
                values.nextValue();
            }
            return values.nextValue();
        }

        @Override
        protected BytesRef pick(BinaryDocValues values, BytesRefBuilder builder, DocIdSetIterator docItr, int startDoc, int endDoc, int maxChildren) throws IOException {
            BytesRefBuilder bytesRefBuilder = null;
            int count = 0;
            int doc = startDoc;
            while (doc < endDoc) {
                if (values.advanceExact(doc)) {
                    if (++count > maxChildren) break;
                    BytesRef innerValue = values.binaryValue();
                    if (bytesRefBuilder == null) {
                        builder.copyBytes(innerValue);
                        bytesRefBuilder = builder;
                    } else {
                        BytesRef max;
                        BytesRef bytesRef = max = bytesRefBuilder.get().compareTo(innerValue) > 0 ? bytesRefBuilder.get() : innerValue;
                        if (max == innerValue) {
                            bytesRefBuilder.copyBytes(max);
                        }
                    }
                }
                doc = docItr.nextDoc();
            }
            return bytesRefBuilder == null ? null : bytesRefBuilder.get();
        }

        @Override
        protected int pick(SortedSetDocValues values) throws IOException {
            int count = values.docValueCount();
            for (int i = 0; i < count - 1; ++i) {
                values.nextOrd();
            }
            return Math.toIntExact(values.nextOrd());
        }

        @Override
        protected int pick(SortedDocValues values, DocIdSetIterator docItr, int startDoc, int endDoc, int maxChildren) throws IOException {
            int ord = -1;
            int count = 0;
            int doc = startDoc;
            while (doc < endDoc) {
                if (values.advanceExact(doc)) {
                    if (++count > maxChildren) break;
                    ord = Math.max(ord, values.ordValue());
                }
                doc = docItr.nextDoc();
            }
            return ord;
        }
    };


    public static MultiValueMode fromString(String sortMode) {
        try {
            return MultiValueMode.valueOf(sortMode.toUpperCase(Locale.ROOT));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Illegal sort mode: " + sortMode);
        }
    }

    public NumericDocValues select(final SortedNumericDocValues values) {
        NumericDocValues singleton = DocValues.unwrapSingleton((SortedNumericDocValues)values);
        if (singleton != null) {
            return singleton;
        }
        return new AbstractNumericDocValues(){
            private long value;

            public boolean advanceExact(int target) throws IOException {
                if (values.advanceExact(target)) {
                    this.value = MultiValueMode.this.pick(values);
                    return true;
                }
                return false;
            }

            public int docID() {
                return values.docID();
            }

            public long longValue() throws IOException {
                return this.value;
            }
        };
    }

    protected long pick(SortedNumericDocValues values) throws IOException {
        throw new IllegalArgumentException("Unsupported sort mode: " + String.valueOf(this));
    }

    public NumericDocValues select(final SortedNumericDocValues values, final long missingValue, final BitSet parentDocs, final DocIdSetIterator childDocs, int maxDoc, final int maxChildren) throws IOException {
        if (parentDocs == null || childDocs == null) {
            return FieldData.replaceMissing(DocValues.emptyNumeric(), missingValue);
        }
        return new AbstractNumericDocValues(){
            int lastSeenParentDoc = -1;
            long lastEmittedValue = missingValue;

            public boolean advanceExact(int parentDoc) throws IOException {
                assert (parentDoc >= this.lastSeenParentDoc) : "can only evaluate current and upcoming parent docs";
                if (parentDoc == this.lastSeenParentDoc) {
                    return true;
                }
                if (parentDoc == 0) {
                    this.lastEmittedValue = missingValue;
                    return true;
                }
                int prevParentDoc = parentDocs.prevSetBit(parentDoc - 1);
                int firstChildDoc = childDocs.docID() > prevParentDoc ? childDocs.docID() : childDocs.advance(prevParentDoc + 1);
                this.lastSeenParentDoc = parentDoc;
                this.lastEmittedValue = MultiValueMode.this.pick(values, missingValue, childDocs, firstChildDoc, parentDoc, maxChildren);
                return true;
            }

            public int docID() {
                return this.lastSeenParentDoc;
            }

            public long longValue() {
                return this.lastEmittedValue;
            }
        };
    }

    protected long pick(SortedNumericDocValues values, long missingValue, DocIdSetIterator docItr, int startDoc, int endDoc, int maxChildren) throws IOException {
        throw new IllegalArgumentException("Unsupported sort mode: " + String.valueOf(this));
    }

    public NumericDoubleValues select(final SortedNumericDoubleValues values) {
        NumericDoubleValues singleton = FieldData.unwrapSingleton(values);
        if (singleton != null) {
            return singleton;
        }
        return new NumericDoubleValues(){
            private double value;

            public boolean advanceExact(int target) throws IOException {
                if (values.advanceExact(target)) {
                    this.value = MultiValueMode.this.pick(values);
                    return true;
                }
                return false;
            }

            public double doubleValue() throws IOException {
                return this.value;
            }

            @Override
            public int advance(int target) throws IOException {
                return values.advance(target);
            }
        };
    }

    protected double pick(SortedNumericDoubleValues values) throws IOException {
        throw new IllegalArgumentException("Unsupported sort mode: " + String.valueOf(this));
    }

    public NumericDoubleValues select(final SortedNumericDoubleValues values, final double missingValue, final BitSet parentDocs, final DocIdSetIterator childDocs, int maxDoc, final int maxChildren) throws IOException {
        if (parentDocs == null || childDocs == null) {
            return FieldData.replaceMissing(FieldData.emptyNumericDouble(), missingValue);
        }
        return new NumericDoubleValues(){
            int lastSeenParentDoc = 0;
            double lastEmittedValue = missingValue;

            public boolean advanceExact(int parentDoc) throws IOException {
                assert (parentDoc >= this.lastSeenParentDoc) : "can only evaluate current and upcoming parent docs";
                if (parentDoc == this.lastSeenParentDoc) {
                    return true;
                }
                int prevParentDoc = parentDocs.prevSetBit(parentDoc - 1);
                int firstChildDoc = childDocs.docID() > prevParentDoc ? childDocs.docID() : childDocs.advance(prevParentDoc + 1);
                this.lastSeenParentDoc = parentDoc;
                this.lastEmittedValue = MultiValueMode.this.pick(values, missingValue, childDocs, firstChildDoc, parentDoc, maxChildren);
                return true;
            }

            public double doubleValue() throws IOException {
                return this.lastEmittedValue;
            }

            @Override
            public int advance(int target) throws IOException {
                return values.advance(target);
            }
        };
    }

    protected double pick(SortedNumericDoubleValues values, double missingValue, DocIdSetIterator docItr, int startDoc, int endDoc, int maxChildren) throws IOException {
        throw new IllegalArgumentException("Unsupported sort mode: " + String.valueOf(this));
    }

    public BinaryDocValues select(final SortedBinaryDocValues values, final BytesRef missingValue) {
        final BinaryDocValues singleton = FieldData.unwrapSingleton(values);
        if (singleton != null) {
            if (missingValue == null) {
                return singleton;
            }
            return new AbstractBinaryDocValues(this){
                private BytesRef value;

                public boolean advanceExact(int target) throws IOException {
                    this.value = singleton.advanceExact(target) ? singleton.binaryValue() : missingValue;
                    return true;
                }

                public BytesRef binaryValue() throws IOException {
                    return this.value;
                }
            };
        }
        return new AbstractBinaryDocValues(){
            private BytesRef value;

            public boolean advanceExact(int target) throws IOException {
                if (values.advanceExact(target)) {
                    this.value = MultiValueMode.this.pick(values);
                    return true;
                }
                this.value = missingValue;
                return missingValue != null;
            }

            public BytesRef binaryValue() throws IOException {
                return this.value;
            }
        };
    }

    protected BytesRef pick(SortedBinaryDocValues values) throws IOException {
        throw new IllegalArgumentException("Unsupported sort mode: " + String.valueOf(this));
    }

    public BinaryDocValues select(SortedBinaryDocValues values, final BytesRef missingValue, final BitSet parentDocs, final DocIdSetIterator childDocs, int maxDoc, final int maxChildren) throws IOException {
        if (parentDocs == null || childDocs == null) {
            return this.select(FieldData.emptySortedBinary(), missingValue);
        }
        final BinaryDocValues selectedValues = this.select(values, null);
        return new AbstractBinaryDocValues(){
            final BytesRefBuilder builder = new BytesRefBuilder();
            int lastSeenParentDoc = 0;
            BytesRef lastEmittedValue = missingValue;

            public boolean advanceExact(int parentDoc) throws IOException {
                assert (parentDoc >= this.lastSeenParentDoc) : "can only evaluate current and upcoming root docs";
                if (parentDoc == this.lastSeenParentDoc) {
                    return true;
                }
                int prevParentDoc = parentDocs.prevSetBit(parentDoc - 1);
                int firstChildDoc = childDocs.docID() > prevParentDoc ? childDocs.docID() : childDocs.advance(prevParentDoc + 1);
                this.lastSeenParentDoc = parentDoc;
                this.lastEmittedValue = MultiValueMode.this.pick(selectedValues, this.builder, childDocs, firstChildDoc, parentDoc, maxChildren);
                if (this.lastEmittedValue == null) {
                    this.lastEmittedValue = missingValue;
                }
                return true;
            }

            public BytesRef binaryValue() throws IOException {
                return this.lastEmittedValue;
            }
        };
    }

    protected BytesRef pick(BinaryDocValues values, BytesRefBuilder builder, DocIdSetIterator docItr, int startDoc, int endDoc, int maxChildren) throws IOException {
        throw new IllegalArgumentException("Unsupported sort mode: " + String.valueOf(this));
    }

    public SortedDocValues select(final SortedSetDocValues values) {
        if (values.getValueCount() >= Integer.MAX_VALUE) {
            throw new UnsupportedOperationException("fields containing more than 2147483646 unique terms are unsupported");
        }
        SortedDocValues singleton = DocValues.unwrapSingleton((SortedSetDocValues)values);
        if (singleton != null) {
            return singleton;
        }
        return new AbstractSortedDocValues(){
            int ord;

            public boolean advanceExact(int target) throws IOException {
                if (values.advanceExact(target)) {
                    this.ord = MultiValueMode.this.pick(values);
                    return true;
                }
                this.ord = -1;
                return false;
            }

            public int docID() {
                return values.docID();
            }

            public int ordValue() {
                assert (this.ord != -1);
                return this.ord;
            }

            public BytesRef lookupOrd(int ord) throws IOException {
                return values.lookupOrd((long)ord);
            }

            public int getValueCount() {
                return (int)values.getValueCount();
            }
        };
    }

    protected int pick(SortedSetDocValues values) throws IOException {
        throw new IllegalArgumentException("Unsupported sort mode: " + String.valueOf(this));
    }

    public SortedDocValues select(SortedSetDocValues values, final BitSet parentDocs, final DocIdSetIterator childDocs, final int maxChildren) throws IOException {
        if (parentDocs == null || childDocs == null) {
            return this.select(DocValues.emptySortedSet());
        }
        final SortedDocValues selectedValues = this.select(values);
        return new AbstractSortedDocValues(){
            int docID = -1;
            int lastSeenParentDoc = 0;
            int lastEmittedOrd = -1;

            public BytesRef lookupOrd(int ord) throws IOException {
                return selectedValues.lookupOrd(ord);
            }

            public int getValueCount() {
                return selectedValues.getValueCount();
            }

            public boolean advanceExact(int parentDoc) throws IOException {
                assert (parentDoc >= this.lastSeenParentDoc) : "can only evaluate current and upcoming root docs";
                if (parentDoc == this.lastSeenParentDoc) {
                    return this.lastEmittedOrd != -1;
                }
                int prevParentDoc = parentDocs.prevSetBit(parentDoc - 1);
                int firstChildDoc = childDocs.docID() > prevParentDoc ? childDocs.docID() : childDocs.advance(prevParentDoc + 1);
                this.docID = this.lastSeenParentDoc = parentDoc;
                this.lastEmittedOrd = MultiValueMode.this.pick(selectedValues, childDocs, firstChildDoc, parentDoc, maxChildren);
                return this.lastEmittedOrd != -1;
            }

            public int docID() {
                return this.docID;
            }

            public int ordValue() {
                return this.lastEmittedOrd;
            }
        };
    }

    protected int pick(SortedDocValues values, DocIdSetIterator docItr, int startDoc, int endDoc, int maxChildren) throws IOException {
        throw new IllegalArgumentException("Unsupported sort mode: " + String.valueOf(this));
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeEnum(this);
    }

    public static MultiValueMode readMultiValueModeFrom(StreamInput in) throws IOException {
        return in.readEnum(MultiValueMode.class);
    }
}

