/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.search;

import io.skylite.SkyliteException;
import io.skylite.SkyliteExceptionProvider;
import io.skylite.Version;
import io.skylite.common.CheckedFunction;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.search.internal.ShardSearchContextId;
import java.io.IOException;

public class SearchContextMissingException
extends SkyliteException {
    private final ShardSearchContextId contextId;

    public SearchContextMissingException(ShardSearchContextId contextId) {
        super("No search context found for id [" + contextId.getId() + "]", new Object[0]);
        this.contextId = contextId;
    }

    public ShardSearchContextId contextId() {
        return this.contextId;
    }

    @Override
    public RestStatus status() {
        return RestStatus.NOT_FOUND;
    }

    public SearchContextMissingException(StreamInput in) throws IOException {
        super(in);
        this.contextId = new ShardSearchContextId(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.contextId.writeTo(out);
    }

    public static class Registration
    implements SkyliteExceptionProvider<SearchContextMissingException> {
        @Override
        public Class<SearchContextMissingException> getExceptionClass() {
            return SearchContextMissingException.class;
        }

        @Override
        public CheckedFunction<StreamInput, SearchContextMissingException, IOException> getConstructor() {
            return SearchContextMissingException::new;
        }

        @Override
        public Version<?> getVersionAdded() {
            return SkyliteException.UNKNOWN_VERSION_ADDED;
        }

        @Override
        public int getLegacyId() {
            return 24;
        }
    }
}

