/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.search;

import io.skylite.SkyliteException;
import io.skylite.SkyliteExceptionProvider;
import io.skylite.SkyliteWrapperException;
import io.skylite.Version;
import io.skylite.common.CheckedFunction;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.search.SearchShardTarget;
import java.io.IOException;

public class SearchException
extends SkyliteException
implements SkyliteWrapperException {
    private final SearchShardTarget shardTarget;

    public SearchException(SearchShardTarget shardTarget, String msg) {
        this(shardTarget, msg, null);
    }

    public SearchException(SearchShardTarget shardTarget, String msg, Throwable cause) {
        super(msg, cause, new Object[0]);
        this.shardTarget = shardTarget;
    }

    public SearchException(StreamInput in) throws IOException {
        super(in);
        this.shardTarget = in.readBoolean() ? new SearchShardTarget(in) : null;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (this.shardTarget == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.shardTarget.writeTo(out);
        }
    }

    public SearchShardTarget shard() {
        return this.shardTarget;
    }

    public static class Registration
    implements SkyliteExceptionProvider<SearchException> {
        @Override
        public Class<SearchException> getExceptionClass() {
            return SearchException.class;
        }

        @Override
        public CheckedFunction<StreamInput, SearchException, IOException> getConstructor() {
            return SearchException::new;
        }

        @Override
        public Version<?> getVersionAdded() {
            return SkyliteException.UNKNOWN_VERSION_ADDED;
        }

        @Override
        public int getLegacyId() {
            return 36;
        }
    }
}

