/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.search.backpressure.stats;

import io.skylite.OpenSearchVersion;
import io.skylite.common.collect.MapBuilder;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.search.backpressure.trackers.CpuUsageTracker;
import io.skylite.core.search.backpressure.trackers.ElapsedTimeTracker;
import io.skylite.core.search.backpressure.trackers.HeapUsageTracker;
import io.skylite.core.search.backpressure.trackers.TaskResourceUsageTracker;
import io.skylite.core.search.backpressure.trackers.TaskResourceUsageTrackerType;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;

public class SearchShardTaskStats
implements ToXContentObject,
Writeable {
    private final long cancellationCount;
    private final long limitReachedCount;
    private final long completionCount;
    private final Map<TaskResourceUsageTrackerType, TaskResourceUsageTracker.Stats> resourceUsageTrackerStats;

    public SearchShardTaskStats(long cancellationCount, long limitReachedCount, long completionCount, Map<TaskResourceUsageTrackerType, TaskResourceUsageTracker.Stats> resourceUsageTrackerStats) {
        this.cancellationCount = cancellationCount;
        this.limitReachedCount = limitReachedCount;
        this.completionCount = completionCount;
        this.resourceUsageTrackerStats = resourceUsageTrackerStats;
    }

    public SearchShardTaskStats(StreamInput in) throws IOException {
        this.cancellationCount = in.readVLong();
        this.limitReachedCount = in.readVLong();
        this.completionCount = in.getVersion().onOrAfter(OpenSearchVersion.V_3_0_0) ? in.readVLong() : -1L;
        MapBuilder builder = new MapBuilder();
        builder.put((Object)TaskResourceUsageTrackerType.CPU_USAGE_TRACKER, (Object)in.readOptionalWriteable(CpuUsageTracker.Stats::new));
        builder.put((Object)TaskResourceUsageTrackerType.HEAP_USAGE_TRACKER, (Object)in.readOptionalWriteable(HeapUsageTracker.Stats::new));
        builder.put((Object)TaskResourceUsageTrackerType.ELAPSED_TIME_TRACKER, (Object)in.readOptionalWriteable(ElapsedTimeTracker.Stats::new));
        this.resourceUsageTrackerStats = builder.immutableMap();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startObject("resource_tracker_stats");
        for (Map.Entry<TaskResourceUsageTrackerType, TaskResourceUsageTracker.Stats> entry : this.resourceUsageTrackerStats.entrySet()) {
            builder.field(entry.getKey().getName(), entry.getValue());
        }
        builder.endObject();
        if (this.completionCount != -1L) {
            builder.field("completion_count", this.completionCount);
        }
        builder.startObject("cancellation_stats").field("cancellation_count", this.cancellationCount).field("cancellation_limit_reached_count", this.limitReachedCount).endObject();
        return builder.endObject();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.cancellationCount);
        out.writeVLong(this.limitReachedCount);
        if (out.getVersion().onOrAfter(OpenSearchVersion.V_3_0_0)) {
            out.writeVLong(this.completionCount);
        }
        out.writeOptionalWriteable(this.resourceUsageTrackerStats.get((Object)TaskResourceUsageTrackerType.CPU_USAGE_TRACKER));
        out.writeOptionalWriteable(this.resourceUsageTrackerStats.get((Object)TaskResourceUsageTrackerType.HEAP_USAGE_TRACKER));
        out.writeOptionalWriteable(this.resourceUsageTrackerStats.get((Object)TaskResourceUsageTrackerType.ELAPSED_TIME_TRACKER));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchShardTaskStats that = (SearchShardTaskStats)o;
        return this.cancellationCount == that.cancellationCount && this.limitReachedCount == that.limitReachedCount && this.completionCount == that.completionCount && this.resourceUsageTrackerStats.equals(that.resourceUsageTrackerStats);
    }

    public int hashCode() {
        return Objects.hash(this.cancellationCount, this.limitReachedCount, this.resourceUsageTrackerStats, this.completionCount);
    }
}

