/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.search.dfs;

import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.CollectionStatistics;
import org.apache.lucene.search.TermStatistics;
import org.apache.lucene.util.BytesRef;

public class AggregatedDfs
implements Writeable {
    private static final TermStatistics[] EMPTY_TERM_STATS = new TermStatistics[0];
    private Map<Term, TermStatistics> termStatistics;
    private Map<String, CollectionStatistics> fieldStatistics;
    private long maxDoc;

    public AggregatedDfs(StreamInput in) throws IOException {
        int size = in.readVInt();
        HashMap<Term, TermStatistics> termStatistics = new HashMap<Term, TermStatistics>(size);
        for (int i = 0; i < size; ++i) {
            Term term = new Term(in.readString(), in.readBytesRef());
            TermStatistics stats = new TermStatistics(in.readBytesRef(), in.readVLong(), AggregatedDfs.subOne(in.readVLong()));
            termStatistics.put(term, stats);
        }
        this.termStatistics = Collections.unmodifiableMap(termStatistics);
        this.fieldStatistics = AggregatedDfs.readFieldStats(in);
        this.maxDoc = in.readVLong();
    }

    public AggregatedDfs(Map<Term, TermStatistics> termStatistics, Map<String, CollectionStatistics> fieldStatistics, long maxDoc) {
        this.termStatistics = termStatistics;
        this.fieldStatistics = fieldStatistics;
        this.maxDoc = maxDoc;
    }

    public static void writeFieldStats(StreamOutput out, Map<String, CollectionStatistics> fieldStatistics) throws IOException {
        out.writeVInt(fieldStatistics.size());
        for (Map.Entry<String, CollectionStatistics> c : fieldStatistics.entrySet()) {
            out.writeString(c.getKey());
            CollectionStatistics statistics = c.getValue();
            assert (statistics.maxDoc() >= 0L);
            out.writeVLong(statistics.maxDoc());
            out.writeVLong(statistics.docCount());
            out.writeVLong(statistics.sumTotalTermFreq());
            out.writeVLong(statistics.sumDocFreq());
        }
    }

    public Map<Term, TermStatistics> termStatistics() {
        return this.termStatistics;
    }

    public Map<String, CollectionStatistics> fieldStatistics() {
        return this.fieldStatistics;
    }

    public long maxDoc() {
        return this.maxDoc;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.termStatistics.size());
        for (Map.Entry<Term, TermStatistics> c : this.termStatistics().entrySet()) {
            Term term = c.getKey();
            out.writeString(term.field());
            out.writeBytesRef(term.bytes());
            TermStatistics stats = c.getValue();
            out.writeBytesRef(stats.term());
            out.writeVLong(stats.docFreq());
            out.writeVLong(AggregatedDfs.addOne(stats.totalTermFreq()));
        }
        AggregatedDfs.writeFieldStats(out, this.fieldStatistics);
        out.writeVLong(this.maxDoc);
    }

    public static void writeTermStats(StreamOutput out, TermStatistics[] termStatistics) throws IOException {
        out.writeVInt(termStatistics.length);
        for (TermStatistics termStatistic : termStatistics) {
            AggregatedDfs.writeSingleTermStats(out, termStatistic);
        }
    }

    public static void writeSingleTermStats(StreamOutput out, TermStatistics termStatistic) throws IOException {
        if (termStatistic != null) {
            assert (termStatistic.docFreq() > 0L);
            out.writeVLong(termStatistic.docFreq());
            out.writeVLong(AggregatedDfs.addOne(termStatistic.totalTermFreq()));
        } else {
            out.writeVLong(0L);
            out.writeVLong(0L);
        }
    }

    public static TermStatistics[] readTermStats(StreamInput in, Term[] terms) throws IOException {
        TermStatistics[] termStatistics;
        int termsStatsSize = in.readVInt();
        if (termsStatsSize == 0) {
            termStatistics = EMPTY_TERM_STATS;
        } else {
            termStatistics = new TermStatistics[termsStatsSize];
            assert (terms.length == termsStatsSize);
            for (int i = 0; i < termStatistics.length; ++i) {
                BytesRef term = terms[i].bytes();
                long docFreq = in.readVLong();
                assert (docFreq >= 0L);
                long totalTermFreq = AggregatedDfs.subOne(in.readVLong());
                if (docFreq == 0L) continue;
                termStatistics[i] = new TermStatistics(term, docFreq, totalTermFreq);
            }
        }
        return termStatistics;
    }

    public static long addOne(long value) {
        assert (value + 1L >= 0L);
        return value + 1L;
    }

    public static long subOne(long value) {
        assert (value >= 0L);
        return value - 1L;
    }

    public static Map<String, CollectionStatistics> readFieldStats(StreamInput in) throws IOException {
        int numFieldStatistics = in.readVInt();
        HashMap<String, CollectionStatistics> fieldStatistics = new HashMap<String, CollectionStatistics>(numFieldStatistics);
        for (int i = 0; i < numFieldStatistics; ++i) {
            String field = in.readString();
            assert (field != null);
            long maxDoc = in.readVLong();
            long docCount = in.readVLong();
            long sumTotalTermFreq = in.readVLong();
            long sumDocFreq = in.readVLong();
            CollectionStatistics stats = new CollectionStatistics(field, maxDoc, docCount, sumTotalTermFreq, sumDocFreq);
            fieldStatistics.put(field, stats);
        }
        return Collections.unmodifiableMap(fieldStatistics);
    }
}

