/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.search.dfs;

import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.search.SearchPhaseResult;
import io.skylite.core.search.SearchShardTarget;
import io.skylite.core.search.dfs.AggregatedDfs;
import io.skylite.core.search.internal.ShardSearchContextId;
import io.skylite.core.search.internal.ShardSearchRequest;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.CollectionStatistics;
import org.apache.lucene.search.TermStatistics;

public class DfsSearchResult
extends SearchPhaseResult {
    private static final Term[] EMPTY_TERMS = new Term[0];
    private Term[] terms;
    private TermStatistics[] termStatistics;
    private Map<String, CollectionStatistics> fieldStatistics;
    private int maxDoc;

    public DfsSearchResult(StreamInput in) throws IOException {
        super(in);
        this.contextId = new ShardSearchContextId(in);
        int termsSize = in.readVInt();
        if (termsSize == 0) {
            this.terms = EMPTY_TERMS;
        } else {
            this.terms = new Term[termsSize];
            for (int i = 0; i < this.terms.length; ++i) {
                this.terms[i] = new Term(in.readString(), in.readBytesRef());
            }
        }
        this.termStatistics = AggregatedDfs.readTermStats(in, this.terms);
        this.fieldStatistics = AggregatedDfs.readFieldStats(in);
        this.maxDoc = in.readVInt();
        this.setShardSearchRequest(in.readOptionalWriteable(ShardSearchRequest::new));
    }

    public DfsSearchResult(ShardSearchContextId contextId, SearchShardTarget shardTarget, ShardSearchRequest shardSearchRequest) {
        this.setSearchShardTarget(shardTarget);
        this.contextId = contextId;
        this.setShardSearchRequest(shardSearchRequest);
    }

    public DfsSearchResult maxDoc(int maxDoc) {
        this.maxDoc = maxDoc;
        return this;
    }

    public int maxDoc() {
        return this.maxDoc;
    }

    public DfsSearchResult termsStatistics(Term[] terms, TermStatistics[] termStatistics) {
        this.terms = terms;
        this.termStatistics = termStatistics;
        return this;
    }

    public DfsSearchResult fieldStatistics(Map<String, CollectionStatistics> fieldStatistics) {
        this.fieldStatistics = Collections.unmodifiableMap(fieldStatistics);
        return this;
    }

    public Term[] terms() {
        return this.terms;
    }

    public TermStatistics[] termStatistics() {
        return this.termStatistics;
    }

    public Map<String, CollectionStatistics> fieldStatistics() {
        return this.fieldStatistics;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.contextId.writeTo(out);
        out.writeVInt(this.terms.length);
        for (Term term : this.terms) {
            out.writeString(term.field());
            out.writeBytesRef(term.bytes());
        }
        AggregatedDfs.writeTermStats(out, this.termStatistics);
        AggregatedDfs.writeFieldStats(out, this.fieldStatistics);
        out.writeVInt(this.maxDoc);
        out.writeOptionalWriteable(this.getShardSearchRequest());
    }
}

