/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.search.internal;

import io.skylite.common.lease.Releasable;
import io.skylite.common.profile.Timer;
import io.skylite.core.index.fielddata.DocValueFormat;
import io.skylite.core.lucene.search.TopDocsAndMaxScore;
import io.skylite.core.lucene.util.CombinedBitSet;
import io.skylite.core.profile.ContextualProfileBreakdown;
import io.skylite.core.search.builder.SearchSourceBuilder;
import io.skylite.core.search.dfs.AggregatedDfs;
import io.skylite.core.search.internal.CancellableBulkScorer;
import io.skylite.core.search.internal.ExitableDirectoryReader;
import io.skylite.core.search.internal.MaxTargetSliceSupplier;
import io.skylite.core.search.internal.ProfilableIndexSearcher;
import io.skylite.core.search.internal.SearchExecutionContext;
import io.skylite.core.search.profile.query.ProfileWeight;
import io.skylite.core.search.profile.query.QueryProfiler;
import io.skylite.core.search.profile.query.QueryTimingType;
import io.skylite.core.search.query.QueryPhase;
import io.skylite.core.search.query.QuerySearchResult;
import io.skylite.core.search.sort.FieldSortBuilder;
import io.skylite.core.search.sort.MinAndMax;
import io.skylite.core.search.sort.SortOrder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.CollectionStatistics;
import org.apache.lucene.search.CollectionTerminatedException;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.CollectorManager;
import org.apache.lucene.search.ConjunctionUtils;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryCache;
import org.apache.lucene.search.QueryCachingPolicy;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.TermStatistics;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.TotalHits;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.BitSetIterator;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.SparseFixedBitSet;

public class ContextIndexSearcher
extends IndexSearcher
implements ProfilableIndexSearcher,
Releasable {
    private static final Logger logger = LogManager.getLogger(ContextIndexSearcher.class);
    private static final int CHECK_CANCELLED_SCORER_INTERVAL = 2048;
    private AggregatedDfs aggregatedDfs;
    private QueryProfiler profiler;
    private MutableQueryTimeout cancellable;
    private SearchExecutionContext searchContext;
    private final boolean hasExecutor;

    public ContextIndexSearcher(IndexReader reader, Similarity similarity, QueryCache queryCache, QueryCachingPolicy queryCachingPolicy, boolean wrapWithExitableDirectoryReader, Executor executor, SearchExecutionContext searchContext) throws IOException {
        this(reader, similarity, queryCache, queryCachingPolicy, new MutableQueryTimeout(), wrapWithExitableDirectoryReader, executor, searchContext);
    }

    private ContextIndexSearcher(IndexReader reader, Similarity similarity, QueryCache queryCache, QueryCachingPolicy queryCachingPolicy, MutableQueryTimeout cancellable, boolean wrapWithExitableDirectoryReader, Executor executor, SearchExecutionContext searchContext) throws IOException {
        super((IndexReader)(wrapWithExitableDirectoryReader ? new ExitableDirectoryReader((DirectoryReader)reader, cancellable) : reader), executor);
        this.hasExecutor = executor != null;
        this.setSimilarity(similarity);
        this.setQueryCache(queryCache);
        this.setQueryCachingPolicy(queryCachingPolicy);
        this.cancellable = cancellable;
        this.searchContext = searchContext;
    }

    public boolean hasExecutor() {
        return this.hasExecutor;
    }

    @Override
    public void setProfiler(QueryProfiler profiler) {
        this.profiler = profiler;
    }

    public Runnable addQueryCancellation(Runnable action) {
        return this.cancellable.add(action);
    }

    public void removeQueryCancellation(Runnable action) {
        this.cancellable.remove(action);
    }

    public void close() {
        this.cancellable.clear();
    }

    public boolean hasCancellations() {
        return this.cancellable.isEnabled();
    }

    public void setAggregatedDfs(AggregatedDfs aggregatedDfs) {
        this.aggregatedDfs = aggregatedDfs;
    }

    public Query rewrite(Query original) throws IOException {
        if (this.profiler != null) {
            this.profiler.startRewriteTime();
        }
        try {
            Query query = super.rewrite(original);
            return query;
        }
        finally {
            if (this.profiler != null) {
                this.profiler.stopAndAddRewriteTime();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Weight createWeight(Query query, ScoreMode scoreMode, float boost) throws IOException {
        if (this.profiler != null) {
            Weight weight;
            ContextualProfileBreakdown profile = (ContextualProfileBreakdown)((Object)this.profiler.getQueryBreakdown(query));
            Timer timer = profile.getTimer(QueryTimingType.CREATE_WEIGHT);
            timer.start();
            try {
                weight = query.createWeight((IndexSearcher)this, scoreMode, boost);
            }
            finally {
                timer.stop();
                this.profiler.pollLastElement();
            }
            return new ProfileWeight(query, weight, profile);
        }
        return super.createWeight(query, scoreMode, boost);
    }

    private Query rewrite(Query original, boolean needsScores) throws IOException {
        if (needsScores) {
            return this.rewrite(original);
        }
        return this.rewrite((Query)new ConstantScoreQuery(original));
    }

    public void search(Query query, Collector results) throws IOException {
        query = this.rewrite(query, results.scoreMode().needsScores());
        Weight weight = this.createWeight(query, results.scoreMode(), 1.0f);
        IndexSearcher.LeafReaderContextPartition[] partition = (IndexSearcher.LeafReaderContextPartition[])this.leafContexts.stream().map(IndexSearcher.LeafReaderContextPartition::createForEntireSegment).toArray(IndexSearcher.LeafReaderContextPartition[]::new);
        this.search(partition, weight, results);
    }

    public void search(IndexSearcher.LeafReaderContextPartition[] leaves, Weight weight, CollectorManager manager, QuerySearchResult result, DocValueFormat[] formats, TotalHits totalHits) throws IOException {
        ArrayList<Collector> collectors = new ArrayList<Collector>(leaves.length);
        for (IndexSearcher.LeafReaderContextPartition partition : leaves) {
            LeafReaderContext ctx = partition.ctx;
            Collector collector = manager.newCollector();
            this.searchLeaf(ctx, partition.minDocId, partition.maxDocId, weight, collector);
            collectors.add(collector);
        }
        TopFieldDocs mergedTopDocs = (TopFieldDocs)manager.reduce(collectors);
        for (ScoreDoc scoreDoc : mergedTopDocs.scoreDocs) {
            scoreDoc.shardIndex = -1;
        }
        if (totalHits != null) {
            mergedTopDocs = new TopFieldDocs(totalHits, mergedTopDocs.scoreDocs, mergedTopDocs.fields);
        }
        result.topDocs(new TopDocsAndMaxScore((TopDocs)mergedTopDocs, Float.NaN), formats);
    }

    public void search(Query query, CollectorManager<?, TopFieldDocs> manager, QuerySearchResult result, DocValueFormat[] formats, TotalHits totalHits) throws IOException {
        TopFieldDocs mergedTopDocs = (TopFieldDocs)this.search(query, manager);
        for (ScoreDoc scoreDoc : mergedTopDocs.scoreDocs) {
            scoreDoc.shardIndex = -1;
        }
        if (totalHits != null) {
            mergedTopDocs = new TopFieldDocs(totalHits, mergedTopDocs.scoreDocs, mergedTopDocs.fields);
        }
        result.topDocs(new TopDocsAndMaxScore((TopDocs)mergedTopDocs, Float.NaN), formats);
    }

    protected void search(IndexSearcher.LeafReaderContextPartition[] leaves, Weight weight, Collector collector) throws IOException {
        int start = this.searchContext.shouldUseTimeSeriesDescSortOptimization() ? leaves.length - 1 : 0;
        int end = this.searchContext.shouldUseTimeSeriesDescSortOptimization() ? -1 : leaves.length;
        int step = this.searchContext.shouldUseTimeSeriesDescSortOptimization() ? -1 : 1;
        for (int i = start; i != end; i += step) {
            IndexSearcher.LeafReaderContextPartition lrcp = leaves[i];
            this.searchLeaf(lrcp.ctx, lrcp.minDocId, lrcp.maxDocId, weight, collector);
        }
        this.searchContext.bucketCollectorProcessor().processPostCollection(collector);
    }

    protected void searchLeaf(LeafReaderContext ctx, int minDocId, int maxDocId, Weight weight, Collector collector) throws IOException {
        LeafCollector leafCollector;
        if (!this.canMatch(ctx)) {
            return;
        }
        try {
            this.cancellable.checkCancelled();
            if (weight instanceof ProfileWeight) {
                ((ProfileWeight)weight).associateCollectorToLeaves(ctx, collector);
            }
            weight = this.wrapWeight(weight);
            collector.setWeight(weight);
            leafCollector = collector.getLeafCollector(ctx);
        }
        catch (QueryPhase.TimeExceededException | CollectionTerminatedException e) {
            if (e instanceof QueryPhase.TimeExceededException) {
                this.searchContext.setSearchTimedOut(true);
            }
            return;
        }
        Bits liveDocs = ctx.reader().getLiveDocs();
        BitSet liveDocsBitSet = ContextIndexSearcher.getSparseBitSetOrNull(liveDocs);
        if (liveDocsBitSet == null) {
            BulkScorer bulkScorer = weight.bulkScorer(ctx);
            if (bulkScorer != null) {
                try {
                    bulkScorer.score(leafCollector, liveDocs, minDocId, maxDocId);
                }
                catch (QueryPhase.TimeExceededException | CollectionTerminatedException e) {
                    if (e instanceof QueryPhase.TimeExceededException) {
                        this.searchContext.setSearchTimedOut(true);
                    }
                    return;
                }
            }
        } else {
            Scorer scorer = weight.scorer(ctx);
            if (scorer != null) {
                try {
                    ContextIndexSearcher.intersectScorerAndBitSet(scorer, liveDocsBitSet, leafCollector, this.cancellable.isEnabled() ? this.cancellable::checkCancelled : () -> {});
                }
                catch (QueryPhase.TimeExceededException | CollectionTerminatedException e) {
                    if (e instanceof QueryPhase.TimeExceededException) {
                        this.searchContext.setSearchTimedOut(true);
                    }
                    return;
                }
            }
        }
        leafCollector.finish();
    }

    private Weight wrapWeight(final Weight weight) {
        if (!this.cancellable.isEnabled()) {
            return weight;
        }
        return new Weight(weight.getQuery()){

            public Explanation explain(LeafReaderContext context, int doc) throws IOException {
                throw new UnsupportedOperationException();
            }

            public boolean isCacheable(LeafReaderContext ctx) {
                throw new UnsupportedOperationException();
            }

            public ScorerSupplier scorerSupplier(final LeafReaderContext context) throws IOException {
                final Scorer scorer = weight.scorer(context);
                return new ScorerSupplier(){

                    public Scorer get(long leadCost) throws IOException {
                        return scorer;
                    }

                    public long cost() {
                        return scorer.iterator().cost();
                    }

                    public BulkScorer bulkScorer() throws IOException {
                        BulkScorer in = weight.bulkScorer(context);
                        if (in != null) {
                            return new CancellableBulkScorer(in, ContextIndexSearcher.this.cancellable::checkCancelled);
                        }
                        return null;
                    }
                };
            }
        };
    }

    private static BitSet getSparseBitSetOrNull(Bits liveDocs) {
        if (liveDocs instanceof SparseFixedBitSet) {
            return (BitSet)liveDocs;
        }
        if (liveDocs instanceof CombinedBitSet && ((CombinedBitSet)liveDocs).getFirst() instanceof SparseFixedBitSet) {
            return (BitSet)liveDocs;
        }
        return null;
    }

    static void intersectScorerAndBitSet(Scorer scorer, BitSet acceptDocs, LeafCollector collector, Runnable checkCancelled) throws IOException {
        collector.setScorer((Scorable)scorer);
        DocIdSetIterator iterator = ConjunctionUtils.intersectIterators(Arrays.asList(new BitSetIterator(acceptDocs, (long)acceptDocs.approximateCardinality()), scorer.iterator()));
        int seen = 0;
        checkCancelled.run();
        int docId = iterator.nextDoc();
        while (docId < Integer.MAX_VALUE) {
            if (++seen % 2048 == 0) {
                checkCancelled.run();
            }
            collector.collect(docId);
            docId = iterator.nextDoc();
        }
        checkCancelled.run();
    }

    public TermStatistics termStatistics(Term term, int docFreq, long totalTermFreq) throws IOException {
        if (this.aggregatedDfs == null) {
            return super.termStatistics(term, docFreq, totalTermFreq);
        }
        TermStatistics termStatistics = this.aggregatedDfs.termStatistics().get(term);
        if (termStatistics == null) {
            return super.termStatistics(term, docFreq, totalTermFreq);
        }
        return termStatistics;
    }

    public CollectionStatistics collectionStatistics(String field) throws IOException {
        if (this.aggregatedDfs == null) {
            return super.collectionStatistics(field);
        }
        CollectionStatistics collectionStatistics = this.aggregatedDfs.fieldStatistics().get(field);
        if (collectionStatistics == null) {
            return super.collectionStatistics(field);
        }
        return collectionStatistics;
    }

    protected IndexSearcher.LeafSlice[] slices(List<LeafReaderContext> leaves) {
        return this.slicesInternal(leaves, this.searchContext.getTargetMaxSliceCount());
    }

    public DirectoryReader getDirectoryReader() {
        IndexReader reader = this.getIndexReader();
        assert (reader instanceof DirectoryReader) : "expected an instance of DirectoryReader, got " + String.valueOf(reader.getClass());
        return (DirectoryReader)reader;
    }

    private boolean canMatch(LeafReaderContext ctx) throws IOException {
        return this.canMatchSearchAfter(ctx);
    }

    private boolean canMatchSearchAfter(LeafReaderContext ctx) throws IOException {
        FieldSortBuilder primarySortField;
        if (this.searchContext.request() != null && this.searchContext.request().source() != null && (primarySortField = SearchSourceBuilder.getPrimaryFieldSortOrNull(this.searchContext.request().source())) != null) {
            MinAndMax<?> minMax = FieldSortBuilder.getMinMaxOrNullForSegment(this.searchContext.getQueryShardContext(), ctx, primarySortField);
            return ContextIndexSearcher.canMatchSearchAfter(this.searchContext.searchAfter(), minMax, primarySortField, this.searchContext.trackTotalHitsUpTo());
        }
        return true;
    }

    IndexSearcher.LeafSlice[] slicesInternal(List<LeafReaderContext> leaves, int targetMaxSlice) {
        if (targetMaxSlice == 0) {
            IndexSearcher.LeafSlice[] leafSlices = super.slices(leaves);
            if (logger.isDebugEnabled()) {
                logger.debug("Slice count using lucene default [{}]", (Object)leafSlices.length);
            }
            return leafSlices;
        }
        IndexSearcher.LeafSlice[] leafSlices = MaxTargetSliceSupplier.getSlices(leaves, targetMaxSlice);
        if (logger.isDebugEnabled()) {
            logger.debug("Slice count using max target slice supplier [{}]", (Object)leafSlices.length);
        }
        return leafSlices;
    }

    public static boolean canMatchSearchAfter(FieldDoc searchAfter, MinAndMax<?> minMax, FieldSortBuilder primarySortField, Integer trackTotalHitsUpto) {
        if (searchAfter != null && minMax != null && primarySortField != null && primarySortField.missing() == null && Objects.equals(trackTotalHitsUpto, -1)) {
            Object searchAfterPrimary = searchAfter.fields[0];
            if (primarySortField.order() == SortOrder.DESC ? minMax.compareMin(searchAfterPrimary) > 0 : minMax.compareMax(searchAfterPrimary) < 0) {
                return false;
            }
        }
        return true;
    }

    private static class MutableQueryTimeout
    implements ExitableDirectoryReader.QueryCancellation {
        private final Set<Runnable> runnables = new HashSet<Runnable>();

        private MutableQueryTimeout() {
        }

        private Runnable add(Runnable action) {
            Objects.requireNonNull(action, "cancellation runnable should not be null");
            if (!this.runnables.add(action)) {
                throw new IllegalArgumentException("Cancellation runnable already added");
            }
            return action;
        }

        private void remove(Runnable action) {
            this.runnables.remove(action);
        }

        @Override
        public void checkCancelled() {
            for (Runnable timeout : this.runnables) {
                timeout.run();
            }
        }

        @Override
        public boolean isEnabled() {
            return !this.runnables.isEmpty();
        }

        public void clear() {
            this.runnables.clear();
        }
    }
}

