/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.search.internal;

import io.skylite.core.action.search.SearchScrollRequest;
import io.skylite.core.action.search.SearchShardTask;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.search.Scroll;
import io.skylite.core.search.internal.ShardSearchContextId;
import io.skylite.core.tasks.Task;
import io.skylite.core.tasks.TaskId;
import io.skylite.core.transport.TransportRequest;
import java.io.IOException;
import java.util.Map;

public class InternalScrollSearchRequest
extends TransportRequest {
    private ShardSearchContextId contextId;
    private Scroll scroll;

    public InternalScrollSearchRequest() {
    }

    public InternalScrollSearchRequest(SearchScrollRequest request, ShardSearchContextId contextId) {
        this.contextId = contextId;
        this.scroll = request.scroll();
    }

    public InternalScrollSearchRequest(StreamInput in) throws IOException {
        super(in);
        this.contextId = new ShardSearchContextId(in);
        this.scroll = in.readOptionalWriteable(Scroll::new);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.contextId.writeTo(out);
        out.writeOptionalWriteable(this.scroll);
    }

    public ShardSearchContextId contextId() {
        return this.contextId;
    }

    public Scroll scroll() {
        return this.scroll;
    }

    public InternalScrollSearchRequest scroll(Scroll scroll) {
        this.scroll = scroll;
        return this;
    }

    @Override
    public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
        return new SearchShardTask(id, type, action, this.getDescription(), parentTaskId, headers);
    }

    @Override
    public String getDescription() {
        return "id[" + this.contextId.getId() + "], scroll[" + String.valueOf(this.scroll) + "]";
    }
}

