/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.search.internal;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.IndexSearcher;

final class MaxTargetSliceSupplier {
    static final double MINIMUM_DOCS_PERCENT_PER_SLICE = 0.1;

    MaxTargetSliceSupplier() {
    }

    static IndexSearcher.LeafSlice[] getSlices(List<LeafReaderContext> leaves, int targetMaxSlice) {
        IndexSearcher.LeafSlice[] leafSlices = MaxTargetSliceSupplier.computeSlices(leaves, targetMaxSlice, Integer.MIN_VALUE);
        return leafSlices;
    }

    public static IndexSearcher.LeafSlice[] computeSlices(List<LeafReaderContext> leaves, int maxSliceNum, int minDocsPerSlice) {
        if (maxSliceNum < 1) {
            throw new IllegalArgumentException("maxSliceNum must be >= 1 (got " + maxSliceNum + ")");
        }
        if (maxSliceNum == 1) {
            return new IndexSearcher.LeafSlice[]{new IndexSearcher.LeafSlice(new ArrayList<IndexSearcher.LeafReaderContextPartition>(leaves.stream().map(IndexSearcher.LeafReaderContextPartition::createForEntireSegment).toList()))};
        }
        int numDocs = leaves.stream().mapToInt(l -> l.reader().maxDoc()).sum();
        minDocsPerSlice = Math.max(minDocsPerSlice, (int)(Math.max(0.1, 1.0 / (double)maxSliceNum) * (double)numDocs));
        return MaxTargetSliceSupplier.computeSlices(leaves, minDocsPerSlice);
    }

    private static IndexSearcher.LeafSlice[] computeSlices(List<LeafReaderContext> leaves, int minDocsPerSlice) {
        ArrayList<LeafReaderContext> sortedLeaves = new ArrayList<LeafReaderContext>(leaves);
        sortedLeaves.sort((c1, c2) -> Integer.compare(c2.reader().maxDoc(), c1.reader().maxDoc()));
        PriorityQueue<List> queue = new PriorityQueue<List>(Comparator.comparingInt(MaxTargetSliceSupplier::sumMaxDocValues));
        long docSum = 0L;
        ArrayList<LeafReaderContext> group = new ArrayList<LeafReaderContext>(sortedLeaves.size());
        for (LeafReaderContext ctx : sortedLeaves) {
            group.add(ctx);
            if ((docSum += (long)ctx.reader().maxDoc()) <= (long)minDocsPerSlice) continue;
            queue.add(new ArrayList(group));
            group.clear();
            docSum = 0L;
        }
        if (!group.isEmpty()) {
            if (queue.isEmpty()) {
                queue.add(new ArrayList(group));
            } else {
                for (LeafReaderContext context : group) {
                    List head = queue.poll();
                    head.add(context);
                    queue.add(head);
                }
            }
        }
        IndexSearcher.LeafSlice[] slices = new IndexSearcher.LeafSlice[queue.size()];
        int index = 0;
        while (!queue.isEmpty()) {
            List currentLeaf = queue.poll();
            slices[index++] = new IndexSearcher.LeafSlice(new ArrayList<IndexSearcher.LeafReaderContextPartition>(currentLeaf.stream().map(IndexSearcher.LeafReaderContextPartition::createForEntireSegment).toList()));
        }
        return slices;
    }

    private static int sumMaxDocValues(List<LeafReaderContext> l) {
        int sum = 0;
        for (LeafReaderContext lr : l) {
            sum += lr.reader().maxDoc();
        }
        return sum;
    }
}

