/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.search.internal;

import io.skylite.common.Nullable;
import io.skylite.common.lease.Releasable;
import io.skylite.common.lease.Releasables;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.action.search.SearchShardTask;
import io.skylite.core.action.support.IndicesOptions;
import io.skylite.core.aggregations.BucketCollectorProcessor;
import io.skylite.core.aggregations.InternalAggregation;
import io.skylite.core.aggregations.SearchContextAggregations;
import io.skylite.core.common.util.BigArrays;
import io.skylite.core.index.cache.bitset.BitsetFilterCache;
import io.skylite.core.index.query.ParsedQuery;
import io.skylite.core.index.query.QueryShardContext;
import io.skylite.core.index.shard.BaseIndexShard;
import io.skylite.core.mapper.MapperService;
import io.skylite.core.search.SearchShardTarget;
import io.skylite.core.search.collapse.CollapseContext;
import io.skylite.core.search.fetch.StoredFieldsContext;
import io.skylite.core.search.internal.ContextIndexSearcher;
import io.skylite.core.search.internal.ScrollContext;
import io.skylite.core.search.internal.ShardSearchContextId;
import io.skylite.core.search.internal.ShardSearchRequest;
import io.skylite.core.search.profile.Profilers;
import io.skylite.core.search.query.QuerySearchResult;
import io.skylite.core.search.query.ReduceableSearchResult;
import io.skylite.core.search.rescore.RescoreContext;
import io.skylite.core.search.sort.SortAndFormats;
import io.skylite.core.search.suggest.SuggestionSearchContext;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.CollectorManager;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.Query;

public abstract class SearchExecutionContext
implements Releasable {
    public static final int DEFAULT_TERMINATE_AFTER = 0;
    public static final int TRACK_TOTAL_HITS_ACCURATE = Integer.MAX_VALUE;
    public static final int TRACK_TOTAL_HITS_DISABLED = -1;
    public static final int DEFAULT_TRACK_TOTAL_HITS_UP_TO = 10000;
    public static final IndicesOptions DEFAULT_INDICES_OPTIONS = IndicesOptions.strictExpandOpenAndForbidClosedIgnoreThrottled();
    protected final List<Releasable> releasables = new CopyOnWriteArrayList<Releasable>();
    private final AtomicBoolean closed = new AtomicBoolean(false);
    protected volatile boolean searchTimedOut;

    public void addReleasable(Releasable releasable) {
        this.releasables.add(releasable);
    }

    public final void close() {
        if (this.closed.compareAndSet(false, true)) {
            Releasables.close(this.releasables);
        }
    }

    public abstract List<RescoreContext> rescore();

    public abstract BigArrays bigArrays();

    public abstract SearchShardTarget shardTarget();

    public abstract Query query();

    public abstract Profilers getProfilers();

    public abstract InternalAggregation.ReduceContext partialOnShard();

    public abstract SearchContextAggregations aggregations();

    public abstract SearchExecutionContext aggregations(SearchContextAggregations var1);

    public abstract void setTask(SearchShardTask var1);

    public abstract SearchShardTask getTask();

    public abstract QueryShardContext getQueryShardContext();

    public abstract BitsetFilterCache bitsetFilterCache();

    public abstract ShardSearchRequest request();

    public abstract Query buildFilteredQuery(Query var1);

    public abstract SuggestionSearchContext suggest();

    public abstract ContextIndexSearcher searcher();

    public void setSearchTimedOut(boolean searchTimedOut) {
        this.searchTimedOut = searchTimedOut;
    }

    public boolean isSearchTimedOut() {
        return this.searchTimedOut;
    }

    public abstract ScrollContext scrollContext();

    public abstract BaseIndexShard indexShard();

    public abstract int numberOfShards();

    public abstract void preProcess(boolean var1);

    public abstract ShardSearchContextId id();

    public abstract MapperService mapperService();

    public abstract boolean hasStoredFields();

    public abstract StoredFieldsContext storedFieldsContext();

    public abstract SearchExecutionContext storedFieldsContext(StoredFieldsContext var1);

    public final boolean hasOnlySuggest() {
        return this.request().source() != null && this.request().source().isSuggestOnly();
    }

    public boolean shouldUseConcurrentSearch() {
        return false;
    }

    public abstract void setBucketCollectorProcessor(BucketCollectorProcessor var1);

    public abstract Map<Class<?>, CollectorManager<? extends Collector, ReduceableSearchResult>> queryCollectorManagers();

    public abstract QuerySearchResult queryResult();

    public abstract boolean shouldUseTimeSeriesDescSortOptimization();

    public abstract BucketCollectorProcessor bucketCollectorProcessor();

    public abstract SortAndFormats sort();

    public abstract int terminateAfter();

    public abstract void terminateAfter(int var1);

    public abstract SearchExecutionContext sort(SortAndFormats var1);

    public abstract long getRelativeTimeInMillis();

    public long getRelativeTimeInMillis(boolean useCache) {
        if (useCache) {
            return this.getRelativeTimeInMillis();
        }
        return TimeValue.nsecToMSec((long)System.nanoTime());
    }

    public abstract int from();

    public abstract SearchExecutionContext from(int var1);

    public abstract int size();

    public abstract SearchExecutionContext size(int var1);

    public abstract SearchExecutionContext parsedPostFilter(ParsedQuery var1);

    public abstract ParsedQuery parsedPostFilter();

    public abstract SearchExecutionContext minimumScore(float var1);

    public abstract Float minimumScore();

    public abstract TimeValue timeout();

    public abstract void timeout(TimeValue var1);

    public abstract boolean lowLevelCancellation();

    public abstract SearchExecutionContext trackScores(boolean var1);

    public abstract boolean trackScores();

    public abstract SearchExecutionContext trackTotalHitsUpTo(int var1);

    public abstract int trackTotalHitsUpTo();

    public abstract SearchExecutionContext collapse(CollapseContext var1);

    public abstract CollapseContext collapse();

    public abstract SearchExecutionContext searchAfter(FieldDoc var1);

    public abstract FieldDoc searchAfter();

    public abstract int getTargetMaxSliceCount();

    @Nullable
    public abstract List<String> groupStats();
}

