/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.search.lookup;

import io.skylite.core.mapper.BaseMappedFieldType;
import java.util.ArrayList;
import java.util.List;

public class FieldLookup {
    private final BaseMappedFieldType fieldType;
    private final List<Object> values = new ArrayList<Object>();
    private boolean valuesLoaded = false;

    FieldLookup(BaseMappedFieldType fieldType) {
        this.fieldType = fieldType;
    }

    BaseMappedFieldType fieldType() {
        return this.fieldType;
    }

    public List<Object> getValues() {
        assert (this.valuesLoaded) : "Get values from FieldLookup called without initializing the values";
        return this.values;
    }

    public void setValues(List<Object> values) {
        assert (!this.valuesLoaded) : "FieldLookup values are already loaded! Call clear before setting new values";
        this.values.addAll(values);
        this.valuesLoaded = true;
    }

    public void clear() {
        this.values.clear();
        this.valuesLoaded = false;
    }

    public boolean isEmpty() {
        assert (this.valuesLoaded) : "FieldLookup was never loaded with data. Load data before calling isEmpty";
        return this.values.isEmpty();
    }

    public Object getValue() {
        assert (this.valuesLoaded) : "Get values from FieldLookup called without initializing the values";
        if (this.values.isEmpty()) {
            return null;
        }
        return this.values.get(0);
    }

    public boolean valuesLoaded() {
        return this.valuesLoaded;
    }
}

