/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.search.lookup;

import io.skylite.SkyliteExceptionsHelper;
import io.skylite.core.index.fielddata.BaseIndexFieldData;
import io.skylite.core.index.fielddata.ScriptDocValues;
import io.skylite.core.mapper.BaseMappedFieldType;
import java.io.IOException;
import java.security.AccessController;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.lucene.index.LeafReaderContext;

public class LeafDocLookup
implements Map<String, ScriptDocValues<?>> {
    private final Map<String, ScriptDocValues<?>> localCacheFieldData = new HashMap(4);
    private final Function<String, BaseMappedFieldType> fieldTypeLookup;
    private final Function<BaseMappedFieldType, BaseIndexFieldData<?>> fieldDataLookup;
    private final LeafReaderContext reader;
    private int docId = -1;

    LeafDocLookup(Function<String, BaseMappedFieldType> fieldTypeLookup, Function<BaseMappedFieldType, BaseIndexFieldData<?>> fieldDataLookup, LeafReaderContext reader) {
        this.fieldTypeLookup = fieldTypeLookup;
        this.fieldDataLookup = fieldDataLookup;
        this.reader = reader;
    }

    public void setDocument(int docId) {
        this.docId = docId;
    }

    @Override
    public ScriptDocValues<?> get(Object key) {
        String fieldName = key.toString();
        ScriptDocValues scriptValues = this.localCacheFieldData.get(fieldName);
        if (scriptValues == null) {
            BaseMappedFieldType fieldType = this.fieldTypeLookup.apply(fieldName);
            if (fieldType == null) {
                throw new IllegalArgumentException("No field found for [" + fieldName + "] in mapping");
            }
            scriptValues = AccessController.doPrivileged(() -> this.fieldDataLookup.apply(fieldType).load(this.reader).getScriptValues());
            this.localCacheFieldData.put(fieldName, scriptValues);
        }
        try {
            scriptValues.setNextDocId(this.docId);
        }
        catch (IOException e) {
            throw SkyliteExceptionsHelper.convertToOpenSearchException(e);
        }
        return scriptValues;
    }

    @Override
    public boolean containsKey(Object key) {
        String fieldName = key.toString();
        ScriptDocValues<?> scriptValues = this.localCacheFieldData.get(fieldName);
        return scriptValues != null || this.fieldTypeLookup.apply(fieldName) != null;
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ScriptDocValues<?> put(String key, ScriptDocValues<?> value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ScriptDocValues<?> remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends String, ? extends ScriptDocValues<?>> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<String> keySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<ScriptDocValues<?>> values() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Map.Entry<String, ScriptDocValues<?>>> entrySet() {
        throw new UnsupportedOperationException();
    }
}

