/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.search.lookup;

import io.skylite.SkyliteParseException;
import io.skylite.common.CheckedSupplier;
import io.skylite.core.index.storedfieldloader.SingleStoredFieldLoader;
import io.skylite.core.mapper.BaseMappedFieldType;
import io.skylite.core.search.lookup.FieldLookup;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.StoredFields;

public class LeafStoredFieldsLookup
implements Map<Object, Object> {
    private final Function<String, BaseMappedFieldType> fieldTypeLookup;
    private final CheckedSupplier<StoredFields, IOException> storedFieldsProvider;
    private StoredFields storedFields = null;
    private int docId = -1;
    private final Map<String, FieldLookup> cachedFieldData = new HashMap<String, FieldLookup>();

    public LeafStoredFieldsLookup(Function<String, BaseMappedFieldType> fieldTypeLookup, CheckedSupplier<StoredFields, IOException> reader) {
        this.fieldTypeLookup = fieldTypeLookup;
        this.storedFieldsProvider = reader;
    }

    public void setDocument(int docId) {
        if (this.docId == docId) {
            return;
        }
        this.docId = docId;
        this.clearCache();
    }

    @Override
    public Object get(Object key) {
        try {
            return this.loadFieldData(key.toString());
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to load stored fields for doc id [" + this.docId + "]", e);
        }
    }

    @Override
    public boolean containsKey(Object key) {
        try {
            this.loadFieldData(key.toString());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set keySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection values() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set entrySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object put(Object key, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    private FieldLookup loadFieldData(String name) throws IOException {
        FieldLookup cachedField;
        if (this.storedFields == null) {
            this.storedFields = (StoredFields)this.storedFieldsProvider.get();
        }
        if ((cachedField = this.cachedFieldData.get(name)) == null) {
            BaseMappedFieldType fieldType = this.fieldTypeLookup.apply(name);
            if (fieldType == null) {
                throw new IllegalArgumentException("No field found for [" + name + "] in mapping");
            }
            cachedField = new FieldLookup(fieldType);
            this.cachedFieldData.put(name, cachedField);
        }
        if (!cachedField.valuesLoaded()) {
            ArrayList<Object> values = new ArrayList<Object>(2);
            BaseMappedFieldType dataFieldType = cachedField.fieldType();
            SingleStoredFieldLoader visitor = new SingleStoredFieldLoader(dataFieldType.name(), dataFieldType::valueForDisplay, values);
            try {
                this.storedFields.document(this.docId, (StoredFieldVisitor)visitor);
            }
            catch (IOException e) {
                throw new SkyliteParseException("failed to load field [{}]", (Throwable)e, name);
            }
            cachedField.setValues(values);
        }
        return cachedField;
    }

    private void clearCache() {
        for (Map.Entry<String, FieldLookup> entry : this.cachedFieldData.entrySet()) {
            entry.getValue().clear();
        }
    }
}

