/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.search.pipeline;

import io.skylite.core.ParseField;
import io.skylite.core.common.AbstractDiffable;
import io.skylite.core.common.Strings;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.xcontent.ContextParser;
import io.skylite.core.xcontent.MediaType;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.ObjectParser;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentHelper;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;

public class PipelineConfiguration
extends AbstractDiffable<PipelineConfiguration>
implements ToXContentObject {
    public static final String NOOP_PIPELINE_ID = "_none";
    public static final String NOOP_PIPELINE_NAME = "_none";
    private static final ObjectParser<Builder, Void> PARSER = new ObjectParser("pipeline_config", true, Builder::new);
    private final String id;
    private final BytesReference config;
    private final MediaType mediaType;

    public static ContextParser<Void, PipelineConfiguration> getParser() {
        return (parser, context) -> PARSER.apply(parser, null).build();
    }

    public PipelineConfiguration(String id, BytesReference config, MediaType mediaType) {
        this.id = Objects.requireNonNull(id);
        this.config = Objects.requireNonNull(config);
        this.mediaType = Objects.requireNonNull(mediaType);
    }

    public String getId() {
        return this.id;
    }

    public Map<String, Object> getConfigAsMap() {
        return (Map)XContentHelper.convertToMap(this.config, true, this.mediaType).v2();
    }

    MediaType getMediaType() {
        return this.mediaType;
    }

    BytesReference getConfig() {
        return this.config;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("id", this.id);
        builder.field("config", this.getConfigAsMap());
        builder.endObject();
        return builder;
    }

    public String toString() {
        return Strings.toString(MediaTypeRegistry.JSON, this);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.id);
        out.writeBytesReference(this.config);
        this.mediaType.writeTo(out);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PipelineConfiguration that = (PipelineConfiguration)o;
        if (!this.id.equals(that.id)) {
            return false;
        }
        return this.getConfigAsMap().equals(that.getConfigAsMap());
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = 31 * result + this.getConfigAsMap().hashCode();
        return result;
    }

    static {
        PARSER.declareString(Builder::setId, new ParseField("id", new String[0]));
        PARSER.declareField((parser, builder, aVoid) -> {
            XContentBuilder contentBuilder = XContentBuilder.builder(parser.contentType().xContent());
            contentBuilder.generator().copyCurrentStructure(parser);
            builder.setConfig(BytesReference.bytes(contentBuilder), contentBuilder.contentType());
        }, new ParseField("config", new String[0]), ObjectParser.ValueType.OBJECT);
    }

    private static class Builder {
        private String id;
        private BytesReference config;
        private MediaType mediaType;

        private Builder() {
        }

        void setId(String id) {
            this.id = id;
        }

        void setConfig(BytesReference config, MediaType mediaType) {
            this.config = config;
            this.mediaType = mediaType;
        }

        PipelineConfiguration build() {
            return new PipelineConfiguration(this.id, this.config, this.mediaType);
        }
    }
}

